/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.mediation.synchronize.util.SynchronizeUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractSynchronizer
implements ISynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(AbstractSynchronizer.class);
    private XmlSynchronizeContext neSyncMapping = null;

    public final XmlSynchronizeContext getNeSyncMapping() {
        return this.neSyncMapping;
    }

    public final void setNeSyncMapping(XmlSynchronizeContext neSyncMapping) {
        this.neSyncMapping = neSyncMapping;
    }

    protected final void populateMoPropertyValue(String propertyValue, String propertyType, String propertyName, ManagedObject managedObject) {
        Class<?> moClass = managedObject.getClass();
        try {
            if ((this.check(propertyType) || "java.lang.Long".equals(propertyType) || "boolean".equals(propertyType) || "java.lang.Boolean".equals(propertyType)) && propertyValue != null && propertyValue.contains("(")) {
                int beginIndex = propertyValue.indexOf("(");
                int endIndex = propertyValue.indexOf(")");
                propertyValue = propertyValue.subSequence(beginIndex + 1, endIndex).toString();
            }
            this.invokeFieldMethod(propertyValue, propertyType, propertyName, managedObject, moClass);
        }
        catch (Exception e) {
            LOGGER.error((Object)"exception when populateMoPropertyValue, propertyName is : %s,propertyType is : %s,managedObject is : %s,error is %s.", propertyName, propertyType, managedObject, ExceptionUtil.getErrorMessage(e));
        }
    }

    private void invokeFieldMethod(String propertyValue, String propertyType, String propertyName, ManagedObject managedObject, Class<?> moClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object parsedValue;
        Class<Object> propertyTypeClass;
        if ("int".equals(propertyType)) {
            propertyTypeClass = Integer.TYPE;
            parsedValue = NumberUtil.convertToInteger(propertyValue);
        } else if ("java.lang.Integer".equals(propertyType)) {
            propertyTypeClass = Integer.class;
            parsedValue = NumberUtil.convertToInteger(propertyValue);
        } else if ("long".equals(propertyType)) {
            propertyTypeClass = Long.TYPE;
            parsedValue = NumberUtil.convertToLong(propertyValue);
        } else if ("java.lang.Long".equals(propertyType)) {
            propertyTypeClass = Long.class;
            parsedValue = NumberUtil.convertToLong(propertyValue);
        } else if ("boolean".equals(propertyType)) {
            propertyTypeClass = Boolean.TYPE;
            parsedValue = propertyValue;
        } else if ("java.lang.Boolean".equals(propertyType)) {
            propertyTypeClass = Boolean.class;
            parsedValue = propertyValue;
        } else {
            propertyTypeClass = String.class;
            parsedValue = propertyValue;
        }
        Method fieldMethod = moClass.getMethod("set" + SynchronizeUtil.formatPropertyName(propertyName), propertyTypeClass);
        fieldMethod.invoke((Object)managedObject, parsedValue);
    }

    private boolean check(String propertyType) {
        return "int".equals(propertyType) || "java.lang.Integer".equals(propertyType) || "long".equals(propertyType);
    }

    @Override
    public int getSyncMOCount() {
        return 0;
    }
}

