/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sdk.model;

import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AlarmStatistic
implements Serializable {
    private static final long serialVersionUID = 7381141719592455286L;
    private static final int ZERO = 0;
    private long moId;
    private String moName;
    private Map<FaultEnum.AlarmSeverity, Integer> unClearedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();
    private Map<FaultEnum.AlarmSeverity, Integer> unConfirmedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();

    public AlarmStatistic(long moId, String moName) {
        this.moId = moId;
        this.moName = moName;
        this.unClearedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unClearedCount.put(severity, 0);
        }
        this.unConfirmedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unConfirmedCount.put(severity, 0);
        }
    }

    public AlarmStatistic() {
        this.unClearedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unClearedCount.put(severity, 0);
        }
        this.unConfirmedCount = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unConfirmedCount.put(severity, 0);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void updateUnClearedCount(FaultEnum.AlarmSeverity severity, int count) {
        Integer oldCount = this.unClearedCount.get((Object)severity);
        if (null == oldCount) {
            this.unClearedCount.put(severity, count);
        } else {
            this.unClearedCount.put(severity, count + oldCount);
        }
    }

    public void resetUnClearedCount(FaultEnum.AlarmSeverity severity, int count) {
        this.unClearedCount.put(severity, count);
    }

    public void updateUnConfirmedCount(FaultEnum.AlarmSeverity severity, int count) {
        Integer oldCount = this.unConfirmedCount.get((Object)severity);
        if (null == oldCount) {
            this.unConfirmedCount.put(severity, count);
        } else {
            this.unConfirmedCount.put(severity, count + oldCount);
        }
    }

    public void resetUnConfirmedCount(FaultEnum.AlarmSeverity severity, int count) {
        this.unConfirmedCount.put(severity, count);
    }

    public int getTotalAlarmCount() {
        int total = 0;
        if (null != this.unClearedCount) {
            FaultEnum.AlarmSeverity[] severities;
            for (FaultEnum.AlarmSeverity severity : severities = FaultEnum.AlarmSeverity.getAllSeverity()) {
                total += this.unClearedCount.get((Object)severity).intValue();
            }
        }
        return total;
    }

    public int getAlarmCount(FaultEnum.AlarmSeverity severity) {
        if (null == this.unClearedCount) {
            return 0;
        }
        Integer count = this.unClearedCount.get((Object)severity);
        if (null == count) {
            return 0;
        }
        return count;
    }

    public int getUnConfirmedCount(FaultEnum.AlarmSeverity severity) {
        if (null == this.unConfirmedCount) {
            return 0;
        }
        Integer count = this.unConfirmedCount.get((Object)severity);
        if (null == count) {
            return 0;
        }
        return count;
    }

    public long getMoId() {
        return this.moId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("moId[");
        buf.append(this.moId);
        buf.append(']');
        FaultEnum.AlarmSeverity[] severities = FaultEnum.AlarmSeverity.getAllSeverity();
        buf.append(", ");
        for (FaultEnum.AlarmSeverity severity : severities) {
            buf.append(severity.getValue());
            buf.append('[');
            buf.append(this.getAlarmCount(severity));
            buf.append("] ");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        FaultEnum.AlarmSeverity[] severities;
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof AlarmStatistic)) {
            return false;
        }
        AlarmStatistic oldAlarmStatistic = (AlarmStatistic)obj;
        if (oldAlarmStatistic.getMoId() != this.moId) {
            return false;
        }
        for (FaultEnum.AlarmSeverity severity : severities = FaultEnum.AlarmSeverity.getAllSeverity()) {
            int newAlarmCount;
            int oldAlarmCount = oldAlarmStatistic.getAlarmCount(severity);
            if (oldAlarmCount == (newAlarmCount = this.getAlarmCount(severity))) continue;
            return false;
        }
        return true;
    }

    public String getMoName() {
        return this.moName;
    }

    public void setMoName(String moName) {
        this.moName = moName;
    }
}

