/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.auth;

import com.huawei.common.FileUtil;
import com.huawei.dbtool.WccTool;
import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;

public class ChangeAuth {
    private static final Log logger = LogFactory.getInstance(ChangeAuth.class);
    private static final String HACONFIG = "/ha/local/conf/ha.properties";
    private static final String USERKEY = "alarm.user";
    private static final String USERPWD = "alarm.password";
    private static final String DBNAME = "lego";
    private static final int PASSWORD_ERROR = 2;
    private static final int CHANGE_PASSWORD_FAILED = 4;
    private static final int CONFIRM_PASSWORD_FAILED = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try (Scanner scanner = new Scanner(System.in);){
            String string = scanner.nextLine();
            String string2 = scanner.nextLine();
            String string3 = scanner.nextLine();
            try {
                ChangeAuth.checkParam(stringArray, string2, string3);
                User user = new User();
                user.setUserName(ChangeAuth.getHaAlarmAuthUser());
                if (!user.isSyncAdmin()) {
                    throw new LegoCheckedException("The user not supported, user: " + user.getUserName());
                }
                ChangeAuth.checkAuthInfo(user.getUserName(), string);
                ChangeAuth.changePassword(user.getUserName(), string, string2, stringArray[1], stringArray[2]);
                ChangeAuth.changeHaAuthInfo(string2);
            }
            finally {
                SecurityUtil.sensitiveClean((String)string);
                SecurityUtil.sensitiveClean((String)string2);
                SecurityUtil.sensitiveClean((String)string3);
            }
            logger.info((Object)"Action: %s exec successful.", stringArray[0]);
            System.exit(0);
        }
        catch (LegoCheckedException legoCheckedException) {
            logger.error((Object)legoCheckedException, "AlarmAction failed.");
            if (legoCheckedException.getErrorCode() == 2L) {
                logger.error((Object)legoCheckedException, "AlarmAction failed because password error.");
                System.exit(2);
            }
            if (legoCheckedException.getErrorCode() == 4L) {
                logger.error((Object)legoCheckedException, "AlarmAction failed because change password error.");
                System.exit(4);
            }
            if (legoCheckedException.getErrorCode() == 5L) {
                logger.error((Object)legoCheckedException, "AlarmAction failed because confirm password error.");
                System.exit(5);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Action: " + stringArray[0] + " exec failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(1);
    }

    private static void changeHaAuthInfo(String string) {
        String string2 = WccTool.getInstance().encrypt(string);
        FileUtil.modifyConfigFile(ChangeAuth.getHAConfigFile(), USERPWD, string2);
    }

    private static String getHaAlarmAuthUser() {
        File file = new File(ChangeAuth.getHAConfigFile());
        if (!file.exists()) {
            throw new LegoCheckedException("GetHaAlarmAuthUser failed.");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty(USERKEY);
            return string;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, "GetHaAlarmAuthUser failed.");
            throw new LegoCheckedException("GetHaAlarmAuthUser failed.");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, "Close fip failed.");
                }
            }
        }
    }

    private static String getHAConfigFile() {
        try {
            String string = new File("../").getCanonicalPath();
            String string2 = string + HACONFIG;
            File file = new File(string2);
            if (!file.exists()) {
                throw new FileNotFoundException("Ha config file not found.");
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new LegoCheckedException("GetAuthUser failed.", (Throwable)iOException);
        }
    }

    private static void checkParam(String[] stringArray, String string, String string2) {
        if (stringArray.length < 3) {
            throw new LegoCheckedException("CheckParam failed, len=" + stringArray.length);
        }
        if (!string.equals(string2)) {
            throw new LegoCheckedException(5L, "The two passwords do not match.");
        }
        if (!"change".equals(stringArray[0])) {
            throw new LegoCheckedException("CheckParam failed, args[0]=" + stringArray[0]);
        }
    }

    private static void checkAuthInfo(String string, String string2) {
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        try (Connection connection = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, DBNAME);
             PreparedStatement preparedStatement = ChangeAuth.prepareStatement(connection, string);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                if (KmcCompatible.isDataSame((String)string2, (String)string4, (String)string3)) continue;
                throw new LegoCheckedException(2L, "new auth is error.");
            }
        }
        catch (LegoCheckedException legoCheckedException) {
            throw legoCheckedException;
        }
        catch (Exception exception) {
            throw new LegoCheckedException("CheckAuthInfo failed: " + ExceptionUtil.getErrorMessage((Throwable)exception));
        }
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws LegoCheckedException {
        String string2 = "select USER_PWD,USER_PWD_SALT from t_user where USER_NAME= ?;";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            logger.error((Object)("Prepare statement failed, SQLException: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)));
            throw new LegoCheckedException("Prepare statement failed.");
        }
    }

    private static void changePassword(String string, String string2, String string3, String string4, String string5) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Accept", "application/json;version=1.0;charset=UTF-8");
        hashMap.put("Content-Type", "application/json");
        hashMap.put("x-auth-user", string);
        hashMap.put("x-auth-key", string2);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"newPassword", (Object)string3);
        jSONObject.put((Object)"confirmPassword", (Object)string3);
        jSONObject.put((Object)"oldPassword", (Object)string2);
        try {
            RestClient restClient = new RestClient(string4, string5);
            ResponseResult responseResult = restClient.doPut("/ws/users/action/userModifyPassword", hashMap, jSONObject.toString());
            if (!responseResult.isSuccess()) {
                logger.error((Object)"Change password failed.");
                throw new LegoCheckedException(4L);
            }
        }
        catch (AppException appException) {
            logger.error((Object)("Change password failed, Exception: " + ExceptionUtil.getErrorMessage((Throwable)appException)));
            throw new LegoCheckedException("Change password failed.");
        }
    }
}

