/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class ConfigFailoverMode {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILED = 1;
    private static final int NUMBER_ONE = 1;
    private static final int NUMBER_TWO = 2;
    private static final String CLOUDCONFIG = "TI_CLOUDCONFIG";
    private static final Log LOGGER = LogFactory.getInstance(ConfigFailoverMode.class);
    private static final String DB_NAME = "lego";

    public void queryAutoFailover(String string) {
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String string2 = "select PROPNAME, PROPVALUE from ti_cloudconfig_props where CONFIGTYPE='system' and PROPNAME like '%_system_autorecovery';";
        Statement statement = null;
        Connection connection = null;
        try {
            Object object;
            CharSequence charSequence;
            connection = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, DB_NAME);
            statement = InitSQL.executeSQLQuery((Connection)connection, (String)string2);
            ResultSet resultSet = statement.executeQuery();
            HashMap<String[], Boolean> hashMap = new HashMap<String[], Boolean>();
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                object = ((String)charSequence).substring(0, ((String)charSequence).indexOf("_system_autorecovery"));
                hashMap.put((String[])object, resultSet.getBoolean(2));
            }
            charSequence = new StringBuilder();
            for (String string3 : object = string.trim().split("&")) {
                String string4;
                if (string3.trim().isEmpty() || !ParamCheck.checkRegion((String)(string4 = string3.substring(0, string3.indexOf(".arb.enable"))))) continue;
                String string5 = hashMap.getOrDefault(string4, true) != false ? "automatic switchover" : "manual switchover";
                ((StringBuilder)charSequence).append(string4).append(" : ").append(string5).append(System.getProperty("line.separator"));
            }
            System.out.println(charSequence);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("QueryAutoFailover failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            throw new PatchException("QueryAutoFailover failed");
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error((Object)("Close statement failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
            }
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error((Object)("Close connect failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
            }
        }
    }

    public void configAutoFailover(String string, String string2) {
        LOGGER.info((Object)"Begain change the AutoRecovery modle.", "");
        int n = 1;
        if (!string2.equals("true") && !string2.equals("false")) {
            LOGGER.error((Object)("Wrong param... strModle: " + string2), "");
            System.exit(1);
        }
        if (!ParamCheck.checkRegion((String)string)) {
            LOGGER.error((Object)("Wrong param... regionId: " + string), "");
            System.exit(1);
        }
        boolean bl = false;
        bl = string2.equals("true");
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        Connection connection = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, DB_NAME);
        try {
            if (!this.queryTableExist(connection)) {
                this.createCloudconfigTable(connection);
            }
            this.insertValueToTable(connection, string, bl, this.configInit(connection));
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Check isTableExists failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            n = this.closeConnection(connection);
            System.exit(1);
        }
        LOGGER.info((Object)"Change the AutoRecovery modle success.", "");
        n = this.closeConnection(connection);
        System.exit(n);
    }

    public boolean configInit(Connection connection) {
        boolean bl = false;
        String string = "select * from TI_CLOUDCONFIG where CONFIGTYPE='system';";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (null != resultSet && resultSet.next()) {
                bl = true;
            } else {
                LOGGER.error((Object)"ResultSet is null.");
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error((Object)("Check isTableExists failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)));
            throw new PatchException("Check isTableExists failed.");
        }
        finally {
            this.closePreparedStatement(preparedStatement);
        }
        return bl;
    }

    public boolean queryTableExist(Connection connection) {
        boolean bl = false;
        String string = "select * from pg_tables where TABLENAME=?;";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, CLOUDCONFIG.toLowerCase(Locale.ENGLISH));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (null != resultSet) {
                while (resultSet.next()) {
                    bl = true;
                }
            } else {
                LOGGER.error((Object)"ResultSet is null.", "");
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error((Object)("Check isTableExists failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
            throw new PatchException("Check isTableExists failed.");
        }
        finally {
            this.closePreparedStatement(preparedStatement);
        }
        return bl;
    }

    public void createCloudconfigTable(Connection connection) {
        LOGGER.info((Object)"Table not exits, create it now.", "");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "CREATE TABLE TI_CLOUDCONFIG (CONFIGTYPE CHARACTER VARYING(255) NOT NULL);CREATE TABLE IF NOT EXISTS TI_CLOUDCONFIG_PROPS (CONFIGTYPE CHARACTER VARYING(255) NOT NULL,PROPVALUE CHARACTER VARYING(1024),PROPNAME CHARACTER VARYING(255) NOT NULL);ALTER TABLE ONLY TI_CLOUDCONFIG ADD CONSTRAINT TI_CLOUDCONFIG_PKEY PRIMARY KEY (CONFIGTYPE);ALTER TABLE ONLY TI_CLOUDCONFIG_PROPS ADD CONSTRAINT TI_CLOUDCONFIG_PROPS_PKEY PRIMARY KEY (CONFIGTYPE, PROPNAME);ALTER TABLE ONLY TI_CLOUDCONFIG_PROPS ADD CONSTRAINT FK196C119E6CD038A5 FOREIGN KEY (CONFIGTYPE) REFERENCES TI_CLOUDCONFIG(CONFIGTYPE);";
        arrayList.add(string);
        InitSQL.executeSQL((Connection)connection, arrayList);
        LOGGER.info((Object)"Table not exits, create it OK.", "");
    }

    public void insertValueToTable(Connection connection, String string, boolean bl, boolean bl2) {
        String string2 = bl ? "Auto" : "Manual";
        LOGGER.info((Object)String.format(Locale.ENGLISH, "%s change the CONFIGTYPE to %s ..., bAutoRecovery: %s", string, string2, bl), "");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = (bl2 ? "delete TI_CLOUDCONFIG_PROPS where CONFIGTYPE ='system' and PROPNAME = '" + string + "_system_autorecovery';" : "insert into TI_CLOUDCONFIG values('system');") + "insert into TI_CLOUDCONFIG_PROPS (configtype, propvalue, propname) values ('system'," + bl + ",'" + string + "_system_autorecovery');";
        arrayList.add(string3);
        InitSQL.executeSQL((Connection)connection, arrayList);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "%s change the CONFIGTYPE to %s OK!", string, string2), "");
    }

    public int closeConnection(Connection connection) {
        int n = 0;
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                n = 1;
                LOGGER.error((Object)("Close error: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
            }
        }
        return n;
    }

    private void closePreparedStatement(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error((Object)("Close error: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
        }
    }
}

