/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TestConnection {
    private static final Log logger = LogFactory.getInstance(TestConnection.class);
    private static final int NUMBER_1 = 1;
    private static final int NUMBER_2 = 2;
    private static final int NUMBER_3 = 3;
    private static final int NUMBER_4 = 4;
    private static final int NUMBER_65535 = 65535;
    private static final int STATUS_OK = 0;
    private static final int STATUS_FAIL = 1;
    private static final int TIMEOUT = 5000;

    public static void main(String[] stringArray) {
        if (!TestConnection.checkParams(stringArray)) {
            System.exit(1);
        }
        try {
            TestConnection.checkConnection(stringArray[0], Integer.parseInt(stringArray[1]));
            TestConnection.checkConnection(stringArray[2], Integer.parseInt(stringArray[3]));
            System.exit(0);
        }
        catch (Exception exception) {
            logger.error((Object)("Check connection failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            System.exit(1);
        }
    }

    private static void checkConnection(String string, int n) {
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
            sSLSocket.connect(new InetSocketAddress(string, n), 5000);
            if (!sSLSocket.isConnected()) {
                throw new RuntimeException("Connect to " + string + ":" + n + " failed.");
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Check connection failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            throw new RuntimeException("Connect to " + string + ":" + n + " failed.");
        }
        finally {
            try {
                if (null != sSLSocket) {
                    sSLSocket.close();
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Close socket failed. errmsg=" + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            }
        }
    }

    private static boolean checkPort(String string) {
        try {
            if (VerifyUtil.isEmpty((String)string)) {
                logger.error((Object)"The port is error.", "");
                return false;
            }
            int n = Integer.parseInt(string);
            if (n < 1 || n > 65535) {
                logger.error((Object)("Port is not illeage. port=" + string), "");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)("The port is not a number. port=" + string), "");
            return false;
        }
        return true;
    }

    private static boolean checkParams(String[] stringArray) {
        if (stringArray.length < 4) {
            logger.error((Object)"Params is error.", "");
            return false;
        }
        if (!AddressUtil.isIpAddress((String)stringArray[0])) {
            logger.error((Object)("Ip address format error. ip=" + stringArray[0]), "");
            return false;
        }
        if (!TestConnection.checkPort(stringArray[1])) {
            return false;
        }
        if (!AddressUtil.isIpAddress((String)stringArray[2])) {
            logger.error((Object)("Ip address format error. ip=" + stringArray[2]), "");
            return false;
        }
        return TestConnection.checkPort(stringArray[3]);
    }
}

