/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.adapter.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.provider.AbstractDataBaseProvider;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.opengauss.adapter.service.impl.OpenGaussManagerImpl;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.sdk.IOpenGaussService;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OpenGaussProvider
extends AbstractDataBaseProvider {
    private static final Log LOG = LogFactory.getInstance(OpenGaussProvider.class);
    private static final List<Integer> SUPPORT_POLICY = Collections.singletonList(57);
    private OpenGaussManagerImpl openGaussManager;
    private IOpenGaussService openGaussService;
    private IPolicyTemplateManager policyTemplateManager;

    protected List<ProtectObjectStorageInfo> getPoStorageInfo(ProtectObject protectObject) {
        return Collections.emptyList();
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ProtectObject po = new ProtectObject();
        po.setPoType(19);
        po.setName("OpenGauss");
        return Collections.singletonList(po);
    }

    protected List<PolicyTemplate> getAppSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        List list = this.policyTemplateManager.getAllTemplate(0L);
        return list.stream().filter(policy -> SUPPORT_POLICY.contains(policy.getType())).collect(Collectors.toList());
    }

    public int getProviderByType() {
        return 19;
    }

    public void updateProtectObjectProps(ProtectObject protectObject, Map<String, String> props) {
        LOG.debug((Object)"Update opengauss props.");
        if (props == null) {
            LOG.debug((Object)"Opengauss props is null.");
            return;
        }
        String userName = props.get("USERNAME");
        String pwd = props.get("PASSWD");
        VerifyUtil.checkStrs((String[])new String[]{userName, pwd});
        super.updateProtectObjectProps(protectObject, props);
    }

    public void buildSubAppProtectObjects(ProtectGroup protectGroup) {
        this.loadProtectObjectStorageInfo(new ArrayList(protectGroup.getPolist()));
    }

    protected void loadAppStorageInfo(List<ProtectObject> protectObjectList) {
        super.loadAppStorageInfo(protectObjectList);
        VerifyUtil.checkObject(protectObjectList);
        ProtectObject protectObject = (ProtectObject)CommonUtil.getFirstElement(protectObjectList);
        List<ProtectObjectStorageInfo> storageInfo = this.getProtectObjectStorageInfo(protectObject);
        protectObject.setUsedStorageResourceSet(new HashSet<ProtectObjectStorageInfo>(storageInfo));
        protectObject.getProps().put("nodeInfo", protectObject.getProps().get("nodeConfig"));
        protectObject.getProps().put("nodeConfig", this.buildNodeConfig(protectObject));
    }

    private String buildNodeConfig(ProtectObject protectObject) {
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        String remoteIpJson = (String)protectObject.getProps().get("remoteIp");
        String localIpJson = (String)protectObject.getProps().get("localIp");
        Set<String> remoteIpList = this.castToIpList(remoteIpJson, clusterUser, obj -> (String)CastUtil.castTo((Object)obj, String.class));
        Set<String> localIpList = this.castToIpList(localIpJson, clusterUser, obj -> (String)CastUtil.castTo((Object)obj, String.class));
        String primaryIpJson = (String)protectObject.getProps().get("nodeConfig");
        Set<String> nodeIpSet = this.castToIpList(primaryIpJson, clusterUser, obj -> {
            JSONObject jsonObject = (JSONObject)CastUtil.castTo((Object)obj, JSONObject.class);
            return jsonObject.getString("ip");
        });
        if (VerifyUtil.isEmpty(remoteIpList) || VerifyUtil.isEmpty(localIpList) || VerifyUtil.isEmpty(nodeIpSet)) {
            LOG.error((Object)"Ip list is empty: %s", new Object[]{clusterUser});
            throw new LegoCheckedException(1073947393L);
        }
        List openGaussClusters = this.getClusterByIpList("localIp", remoteIpList, clusterUser);
        if (VerifyUtil.isEmpty(openGaussClusters)) {
            LOG.error((Object)"Cant find standby cluster: hostSn:%s, clusterUser:%s", new Object[]{protectObject.getProviderSN(), clusterUser});
            throw new LegoCheckedException(1073948191L);
        }
        JSONArray standbySnArr = new JSONArray();
        openGaussClusters.stream().map(ClusterInstance::getHostSN).forEach(arg_0 -> ((JSONArray)standbySnArr).add(arg_0));
        List<DrResource> drResourcesByPo = OpenGaussProvider.getDrResourcesByPo(protectObject);
        List primaryIpList = drResourcesByPo.stream().map(DrResource::getIpAddress).collect(Collectors.toList());
        openGaussClusters = this.openGaussService.queryCluster(primaryIpList, clusterUser);
        if (VerifyUtil.isEmpty((Collection)openGaussClusters)) {
            LOG.error((Object)"Cant find primary cluster: hostSn:%s, clusterUser:%s", new Object[]{protectObject.getProviderSN(), clusterUser});
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray primarySnArr = new JSONArray();
        openGaussClusters.stream().map(ClusterInstance::getHostSN).forEach(arg_0 -> ((JSONArray)primarySnArr).add(arg_0));
        JSONObject nodeConfig = new JSONObject();
        nodeConfig.put((Object)"PRIMARY", (Object)primarySnArr);
        nodeConfig.put((Object)"STANDBY", (Object)standbySnArr);
        return nodeConfig.toString();
    }

    private List<OpenGaussCluster> getClusterByIpList(String ipKey, Set<String> ipList, String clusterUser) {
        List drHostGroups = this.openGaussService.queryOpenGaussGroup();
        List standbyCluster = Collections.emptyList();
        for (DrHostGroup filteredHostGroup : drHostGroups) {
            List tmpHostIps = filteredHostGroup.getChildResources().stream().map(DrResource::getIpAddress).collect(Collectors.toList());
            List standbyClusters = this.openGaussService.queryCluster(tmpHostIps, clusterUser);
            if (standbyClusters.isEmpty()) continue;
            boolean isAllMatchedIp = false;
            try {
                Set matchedIpCollections = standbyClusters.stream().map(cluster -> this.castToIpList((String)cluster.getProps().get(ipKey), clusterUser, obj -> (String)CastUtil.castTo((Object)obj, String.class))).collect(Collectors.toSet());
                isAllMatchedIp = matchedIpCollections.stream().allMatch(ipList::containsAll);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Get isAllMatchedIp error:%s", new Object[]{e.getMessage()});
            }
            if (!isAllMatchedIp) continue;
            standbyCluster = standbyClusters;
            break;
        }
        return standbyCluster;
    }

    private Set<String> castToIpList(String ipJson, String clusterUser, Function<Object, String> converter) {
        JSONArray jsonArray = JSONArray.fromObject((Object)ipJson);
        if (VerifyUtil.isEmpty((Collection)jsonArray)) {
            LOG.error((Object)"Cant find rep conn ip info: %s", new Object[]{clusterUser});
            throw new LegoCheckedException(1073947394L);
        }
        HashSet<String> hostIpList = new HashSet<String>();
        for (Object value : jsonArray) {
            String ip = converter.apply(value);
            hostIpList.add(ip);
        }
        return hostIpList;
    }

    public boolean testProtectObject(ProtectObject po) {
        VerifyUtil.checkObject((Object)po);
        if (po.getPoType() == 14) {
            LOG.debug((Object)"Po is nas, not support Testing,poName=%s, sn=%s", new Object[]{po.getName(), po.getProviderSN()});
            return true;
        }
        List<ProtectObject> testPoList = this.createTestProtectObjectByHostSn(po);
        Optional<Object> ex = Optional.empty();
        for (ProtectObject testPo : testPoList) {
            try {
                this.openGaussManager.testConnecting(testPo);
                return true;
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Test po failed.");
                ex = Optional.of(e);
            }
        }
        if (ex.isPresent()) {
            throw (LegoCheckedException)((Object)ex.get());
        }
        return true;
    }

    private List<ProtectObject> createTestProtectObjectByHostSn(ProtectObject po) {
        List<DrResource> hostList = OpenGaussProvider.getDrResourcesByPo(po);
        return this.createTestPoList(hostList, po);
    }

    private static List<DrResource> getDrResourcesByPo(ProtectObject po) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(po.getProviderSN());
        VerifyUtil.checkObject((Object)resource);
        ArrayList<DrResource> hostList = new ArrayList<DrResource>();
        if (resource instanceof DrHostGroup) {
            Set childResources = resource.getChildResources();
            hostList.addAll(childResources);
        } else {
            hostList.add(resource);
        }
        return hostList;
    }

    private List<ProtectObject> createTestPoList(List<DrResource> hostList, ProtectObject po) {
        ArrayList<ProtectObject> testPoList = new ArrayList<ProtectObject>();
        for (DrResource drResource : hostList) {
            String clusterUser;
            String hostSn = drResource.getDeviceSn();
            Optional clusterOpt = this.openGaussService.queryCluster(hostSn, clusterUser = OpenGaussUtil.getClusterUser(po));
            if (!clusterOpt.isPresent()) {
                LOG.error((Object)"Cant find cluster: hostSn=%s, clusterUser=%s", new Object[]{hostSn, clusterUser});
                throw new LegoCheckedException(1073947394L);
            }
            testPoList.add(this.createTestPo(hostSn, (OpenGaussCluster)clusterOpt.get(), po));
        }
        return testPoList;
    }

    private ProtectObject createTestPo(String hostSn, OpenGaussCluster openGaussCluster, ProtectObject po) {
        ProtectObject protectObject = new ProtectObject();
        protectObject.setProviderSN(hostSn);
        Map props = protectObject.getProps();
        props.put("USERNAME", openGaussCluster.getClusterUser());
        props.put("hostSN", hostSn);
        if (po.getProps().containsKey("PASSWD")) {
            props.put("PASSWD", po.getProps().get("PASSWD"));
        }
        return protectObject;
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject protectObject) {
        List<ProtectObject> clusterPoList = this.createTestProtectObjectByHostSn(protectObject);
        Optional<ProtectObject> primaryPo = clusterPoList.stream().filter(this::isPrimary).findFirst();
        primaryPo.ifPresent(this.openGaussManager::generateLUNDetail);
        return new ArrayList<ProtectObjectStorageInfo>(primaryPo.orElseThrow(() -> new LegoCheckedException(201L)).getUsedStorageResourceSet());
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(poProviderSn);
        if (drResource instanceof DrHost) {
            HashSet<DrResource> set = new HashSet<DrResource>();
            set.add(drResource);
            return this.getAvailableProtectObjectByHosts(set, poProviderSn, DrmEnumDefine.ProviderTypeE.HOST);
        }
        if (drResource instanceof DrHostGroup) {
            return this.getAvailableProtectObjectByHosts(drResource.getChildResources(), poProviderSn, DrmEnumDefine.ProviderTypeE.HOSTGROUP);
        }
        LOG.info((Object)"Get open gauss available protect object is null,poProviderSn:%s", new Object[]{poProviderSn});
        return Collections.emptyList();
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        return Collections.emptyList();
    }

    private List<ProtectObject> getAvailableProtectObjectByHosts(Set<DrResource> hosts, String providerSn, DrmEnumDefine.ProviderTypeE providerTypeE) {
        List<OpenGaussCluster> clusters = this.queryOpenGaussClusterByHosts(hosts);
        if (VerifyUtil.isEmpty(clusters)) {
            LOG.info((Object)"Get available open gauss protect object is null.");
            return Collections.emptyList();
        }
        List<ProtectObject> protectObjects = this.queryProtectObjectByHosts(hosts);
        if (VerifyUtil.isEmpty(protectObjects)) {
            return this.convertClusterListToProtectObjectList(clusters, providerSn, providerTypeE);
        }
        List<OpenGaussCluster> filtered = this.filterUnprotectedClusterList(clusters, protectObjects);
        return this.convertClusterListToProtectObjectList(filtered, providerSn, providerTypeE);
    }

    private List<OpenGaussCluster> filterUnprotectedClusterList(List<OpenGaussCluster> clusters, List<ProtectObject> poList) {
        ArrayList<OpenGaussCluster> re = new ArrayList<OpenGaussCluster>();
        for (OpenGaussCluster cluster : clusters) {
            String uuid = cluster.getUuid();
            boolean isExist = false;
            for (ProtectObject protectObject : poList) {
                if (!uuid.equals(protectObject.getMoUuid())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            re.add(cluster);
        }
        return re;
    }

    private List<OpenGaussCluster> queryOpenGaussClusterByHosts(Set<DrResource> hosts) {
        ArrayList<OpenGaussCluster> re = new ArrayList<OpenGaussCluster>();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (DrResource host : hosts) {
            List filtered;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("hostSN", host.getDeviceSn());
            List clusters = moDao.findMoBy(OpenGaussCluster.class, param);
            if (VerifyUtil.isEmpty((Collection)clusters) || VerifyUtil.isEmpty(filtered = clusters.stream().filter(cluster -> cluster.getIsPrimary() && ClusterInstance.ClusterState.isClusterAvailable((String)cluster.getClusterState())).collect(Collectors.toList()))) continue;
            re.addAll(filtered);
        }
        return re;
    }

    private List<ProtectObject> queryProtectObjectByHosts(Set<DrResource> hosts) {
        ArrayList<ProtectObject> re = new ArrayList<ProtectObject>();
        for (DrResource host : hosts) {
            List protectObjects = ProtectObjectAppUtil.getProtectObjectByHostSnAndPoType((String)host.getDeviceSn(), (Integer)19);
            if (VerifyUtil.isEmpty((Collection)protectObjects)) continue;
            re.addAll(protectObjects);
        }
        return re;
    }

    private List<ProtectObject> convertClusterListToProtectObjectList(List<OpenGaussCluster> clusters, String sn, DrmEnumDefine.ProviderTypeE providerTypeE) {
        ArrayList<ProtectObject> re = new ArrayList<ProtectObject>();
        for (OpenGaussCluster cluster : clusters) {
            ProtectObject po = new ProtectObject();
            po.setMoUuid(cluster.getUuid());
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                po.setUuid(UUIDGenerator.getUUID());
            }
            po.setName(cluster.getClusterName());
            po.setProviderSN(sn);
            po.setPoType(19);
            po.getProps().put("version", cluster.getVersion());
            po.getProps().put("productName", cluster.getProductName());
            po.getProps().put("clusterUser", cluster.getClusterUser());
            po.getProps().put("nodeConfig", cluster.getProps().get("nodeConfig"));
            po.getProps().put("remoteIp", cluster.getProps().get("remoteIp"));
            po.getProps().put("localIp", cluster.getProps().get("localIp"));
            po.getProps().put("PROVIDER_TYPE", String.valueOf(providerTypeE.getValue()));
            re.add(po);
        }
        return re;
    }

    public void setOpenGaussService(IOpenGaussService openGaussService) {
        this.openGaussService = openGaussService;
    }

    public void setOpenGaussManager(OpenGaussManagerImpl openGaussManager) {
        this.openGaussManager = openGaussManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    private boolean isPrimary(ProtectObject po) {
        DrResource drResource = new DrResource();
        drResource.setDeviceSn(po.getProviderSN());
        return this.openGaussManager.isPrimary(drResource.getDeviceSn(), (String)po.getProps().get("USERNAME"));
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        for (ProtectObject po : protectObjectList) {
            if (VerifyUtil.isEmpty((Map)po.getProps())) continue;
            po.getProps().remove("PASSWD");
        }
    }

    public void refreshProtectGroup(ProtectGroup pg) {
        boolean isStorageChanged;
        ProtectGroupHelper helper = ProtectGroupHelper.getInstance();
        PolicyTemplate newTemplate = helper.matchAvailableTemplate(pg);
        if (!VerifyUtil.isEmpty((Object)newTemplate)) {
            pg.setTemplate(newTemplate);
        } else {
            helper.checkPolicyTemplate(pg);
        }
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        Map changes = service.getStorageInfoChangedProtectObjectList(pg);
        boolean bl = isStorageChanged = !VerifyUtil.isEmpty((Map)changes);
        if (isStorageChanged) {
            int oldSubType = pg.getTemplate().getSubType();
            helper.buildReplica(pg, false);
            this.refreshPolicyTemplate(pg, oldSubType);
            pg.setStatus(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
        }
        for (ProtectObject po : pg.getPolist()) {
            Map props = po.getProps();
            String decryptPwd = WccEncryptor.decrypt((String)((String)props.get("PASSWD")));
            props.put("PASSWD", decryptPwd);
            this.updateProtectObjectProps(po, props);
            this.updateDataDiskInfo(po);
        }
    }

    private void updateDataDiskInfo(ProtectObject po) {
        String hostSn;
        NeMgrProtocolExtend ne;
        Set<String> hostSns = OpenGaussUtil.getPrimaryHostSns(po);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        String clusterUser = (String)po.getProps().get("USERNAME");
        OpenGaussAction opAction = null;
        Iterator<String> iterator = hostSns.iterator();
        while (iterator.hasNext() && !(opAction = new OpenGaussAction(ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)(hostSn = iterator.next())), (String)ne.getExtendParams().get("mac_address"))).isPrimary(clusterUser)) {
        }
        if (VerifyUtil.isEmpty(opAction)) {
            LOG.error((Object)"The database cluster of user(%s) is unavailable.", new Object[]{clusterUser});
            throw new LegoCheckedException(1073948119L);
        }
        JSONObject lunInfoJsonObj = opAction.queryLunList(clusterUser);
        this.openGaussManager.updatePoPropWithLunInfo(po, "DATA_DISKS", lunInfoJsonObj, "data_disks");
    }

    public void offerLoadAppStorageInfo(List<ProtectObject> protectObjectList) {
        super.loadAppStorageInfo(protectObjectList);
        VerifyUtil.checkObject(protectObjectList);
        ProtectObject protectObject = (ProtectObject)CommonUtil.getFirstElement(protectObjectList);
        List<ProtectObjectStorageInfo> storageInfo = this.getStorageInfo(protectObject);
        protectObject.setUsedStorageResourceSet(new HashSet<ProtectObjectStorageInfo>(storageInfo));
    }

    private List<ProtectObjectStorageInfo> getStorageInfo(ProtectObject protectObject) {
        List<ProtectObject> clusterPoList = this.createTestProtectObjectByHostSn(protectObject);
        Optional<ProtectObject> primaryPo = clusterPoList.stream().filter(this::isPrimary).findFirst();
        if (primaryPo.isPresent()) {
            ProtectObject po = primaryPo.get();
            this.openGaussManager.generateLUNDetail(po);
            protectObject.getProps().put("DATA_DISKS", po.getProps().get("DATA_DISKS"));
            protectObject.getProps().put("SHARED_DISKS", po.getProps().get("SHARED_DISKS"));
            protectObject.getProps().put("VOTING_DISKS", po.getProps().get("VOTING_DISKS"));
        }
        return new ArrayList<ProtectObjectStorageInfo>(primaryPo.orElseThrow(() -> new LegoCheckedException(201L)).getUsedStorageResourceSet());
    }
}

