/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateOpenGaussSnapshotProcessor
extends CreateSnapshotProcessor {
    private static final Log LOGGER = LogFactory.getInstance(CreateOpenGaussSnapshotProcessor.class);
    private static final long serialVersionUID = -5927698726937203399L;
    private static final Map<String, String> DISK_TYPE_MAP = new HashMap<String, String>();

    protected boolean rebuildSubProcessors(Set<RecoveryTask> recoveryTasks) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        LOGGER.info((Object)"Begin execute create openGauss snapshot processors.");
        try {
            this.initClusterUser();
            HashSet<CreateSnapshotSubProcessor> subProcessors = new HashSet<CreateSnapshotSubProcessor>();
            for (RecoveryTask recoveryTask : recoveryTasks) {
                subProcessors.addAll(this.buildSubProcessorByRecoveryTask(recoveryTask));
            }
            if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
                this.setChildProc(subProcessors);
            } else {
                this.updateSubProcessors(subProcessors);
            }
            LOGGER.info((Object)"Success to to execute create openGauss snapshot processor.");
            return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to execute create openGauss snapshot processor. errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), new String[0]);
            return false;
        }
    }

    private void initClusterUser() {
        ProtectObject protectObject = (ProtectObject)DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)this.getContextRef()).get(0);
        this.getContextRef().setAttribute("clusterUser", (Object)OpenGaussUtil.getClusterUser(protectObject));
        LOGGER.info((Object)"Init ClusterUser success.");
    }

    private Set<CreateSnapshotSubProcessor> buildSubProcessorByRecoveryTask(RecoveryTask recoveryTask) {
        LOGGER.debug((Object)"Begin buildSubProcessorByRecoveryTask, RecoveryTask: %s.", new Object[]{recoveryTask.getTaskId()});
        HashSet<CreateSnapshotSubProcessor> processors = new HashSet<CreateSnapshotSubProcessor>();
        Map lunAndPoMap = recoveryTask.getLunAndPoMap();
        if (VerifyUtil.isEmpty((Map)lunAndPoMap)) {
            return processors;
        }
        lunAndPoMap.values().stream().map(this::filterProjectObjectSet).flatMap(Collection::stream).distinct().forEach(po -> processors.addAll(this.buildSubProcessorByProtectObject(recoveryTask, (ProtectObject)po)));
        return processors;
    }

    private Set<CreateSnapshotSubProcessor> buildSubProcessorByProtectObject(RecoveryTask recoveryTask, ProtectObject po) {
        HashSet<CreateSnapshotSubProcessor> subProcessors = new HashSet<CreateSnapshotSubProcessor>();
        String pgId = po.getProtectGroup().getUuid();
        String disasterHostSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)this.getContextRef().getRecoveryPlan(), (String)pgId, (int)this.getProcType());
        this.updateProtectObjectLunDetail(po);
        Set<ProtectObjectStorageInfo> poLunSet = this.getProjectLuns(po);
        for (ProtectObjectStorageInfo lun : poLunSet) {
            LOGGER.debug((Object)"Begin build CreateSnapshotSubProcessor, lun id: %s.", new Object[]{lun.getResourceId()});
            CreateSnapshotSubProcessor processor = new CreateSnapshotSubProcessor();
            processor.setReplicationId(recoveryTask.getProtectId());
            processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
            processor.setSrcLunId(lun.getResourceId());
            processor.setDeviceId(lun.getResourceProviderSN());
            processor.setLunId(lun.getResourceId());
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(recoveryTask.getRecoveryPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setRelationType(Integer.valueOf(recoveryTask.getProtectType()));
            processor.setHostOrGroupIds(disasterHostSn);
            subProcessors.add(processor);
            String key = RecoveryProcessUtil.generateLunAndHostMapKey((String)processor.getReplicationId(), (String)processor.getSrcDeviceId(), (String)processor.getSrcLunId(), (String)processor.getDeviceId(), (String)processor.getLunId());
            Map lunAndPgMap = recoveryTask.getLunAndPgMap();
            lunAndPgMap.computeIfAbsent(key, k -> Arrays.asList(pgId));
            String dataConsistencyCheckingKey = RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)processor.getDeviceId(), (String)processor.getLunId());
            RecoveryProcessResult processResult = this.getContextRef().getProcessResult();
            processResult.addProcessResult(dataConsistencyCheckingKey, true);
        }
        return subProcessors;
    }

    private Set<ProtectObjectStorageInfo> getProjectLuns(ProtectObject protectObject) {
        HashSet<ProtectObjectStorageInfo> lunSet = new HashSet<ProtectObjectStorageInfo>();
        String clusterUser = (String)this.getContextRef().getAttribute("clusterUser", String.class);
        ProtectObjectStorageInfo logLun = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().stream().findFirst().get();
        if (!logLun.getDeviceName().contains("_dss_private_0")) {
            logLun.setDeviceName(logLun.getDeviceName() + "/" + clusterUser + "_dss_private_0");
        }
        lunSet.add(logLun);
        for (String diskType : DISK_TYPE_MAP.keySet()) {
            List luns = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)protectObject.getProperty(diskType)), ProtectObjectStorageInfo.class);
            luns.stream().filter(lun -> !lun.getDeviceName().contains(DISK_TYPE_MAP.get(diskType))).forEach(lun -> lun.setDeviceName(lun.getDeviceName() + "/" + clusterUser + DISK_TYPE_MAP.get(diskType)));
            lunSet.addAll(luns);
        }
        protectObject.setUsedStorageResourceSet(lunSet);
        return lunSet;
    }

    private Set<ProtectObject> filterProjectObjectSet(List<String> pgIds) {
        List poList = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)this.getContextRef());
        HashSet<ProtectObject> filterSet = new HashSet<ProtectObject>();
        for (ProtectObject po : poList) {
            if (!pgIds.contains(po.getUuid())) continue;
            filterSet.add(po);
        }
        return filterSet;
    }

    private void updateProtectObjectLunDetail(ProtectObject protectObject) {
        protectObject.setProviderSN(this.getMainStandbyHostSn(protectObject));
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(protectObject.getPoType());
        applicationManager.generateLUNDetail(protectObject);
    }

    private String getMainStandbyHostSn(ProtectObject protectObject) {
        Set<String> hostSnList = OpenGaussUtil.getDisasterHost(protectObject);
        String clusterUser = OpenGaussUtil.getClusterUser(protectObject);
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        for (String devSn : hostSnList) {
            OpenGaussAction action = new OpenGaussAction(extendService.findBySn(devSn), devSn);
            if (!action.isMainStandby(clusterUser)) continue;
            return devSn;
        }
        LOGGER.error((Object)"Get MainStandby failed, hostSnList: %s, cluster: %s.", new Object[]{hostSnList, clusterUser});
        throw new LegoCheckedException(1073948118L);
    }

    static {
        DISK_TYPE_MAP.put("DATA_DISKS", "_dss_shared");
        DISK_TYPE_MAP.put("SHARED_DISKS", "_cm_shared");
        DISK_TYPE_MAP.put("VOTING_DISKS", "_cm_vote");
    }
}

