/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussSwitchoverProcessor;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class FailoverProcessor
extends OpenGaussSwitchoverProcessor {
    private static final long serialVersionUID = -8767502578629711157L;
    private static final Log LOGGER = LogFactory.getInstance(FailoverProcessor.class);

    @Override
    public boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        LOGGER.info((Object)"Begin execute failover processor.");
        if (this.isAlreadyFailover(recoveryProcessorContext)) {
            LOGGER.info((Object)"Standby cluster already failover.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.opengauss.recovery.process.failover.info", null);
            return true;
        }
        this.initStandbyActions(recoveryProcessorContext);
        OpenGaussAction mainStandby = (OpenGaussAction)((Object)recoveryProcessorContext.getAttribute("mainStandbyAction", OpenGaussAction.class));
        String clusterUser = (String)recoveryProcessorContext.getAttribute("clusterUser", String.class);
        try {
            this.switchOverCluster(recoveryProcessorContext);
            mainStandby.failoverCluster(clusterUser);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec failover fail, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    protected boolean isAlreadyFailover(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return OpenGaussUtil.isAlreadySwitchover(protectGroup, context, false);
    }
}

