/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ShutdownOpenGaussAppProcessor
extends OpenGaussBaseProcessor {
    private static final long serialVersionUID = 8677837970318155342L;
    private static final Log LOGGER = LogFactory.getInstance(ShutdownOpenGaussAppProcessor.class);
    private String clusterUser;
    private String devSn;
    private String hostSns;

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.initAttributes(context);
            return true;
        }
        this.updateProcessName();
        LOGGER.info((Object)"Begin execute shutdown open gauss processor.");
        try {
            this.shutdownCluster(context);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to shutdown cluster, cluster user: %s, dev sn: %s, errorMsg: %s", new Object[]{this.clusterUser, this.devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err." + e.getErrorCode(), new String[0]);
            return false;
        }
        LOGGER.info((Object)"Success to shutdown openGauss cluster.");
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    public void updateProcessName() {
        String processName = this.isTestClean() ? "com.huawei.ism.drm.opengauss.recovery.process.ShutdownOpenGaussAppTestProcessor" : (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() ? "com.huawei.ism.drm.opengauss.recovery.process.ShutdownOpenGaussPrimaryAppProcessor" : this.getName());
        this.setProcName(processName);
    }

    private void shutdownCluster(RecoveryProcessorContext context) {
        if (this.isTestClean()) {
            this.updateProtectObjectPrimaryHostSn(this.getProtectObject(context));
            this.stopPrimaryCluster(context);
            this.persistAttributes(context, "primaryAction");
        } else if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            this.stopPrimaryCluster(context);
            String hostSn = ((OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class))).getDevSn();
            this.setProperty("primaryHostSn", hostSn);
            context.setAttribute("primaryHostSn", (Object)hostSn);
        } else {
            this.stopStandbyCluster(context);
            this.persistAttributes(context, "mainStandbyAction");
        }
    }

    private void persistAttributes(RecoveryProcessorContext context, String actionKey) {
        boolean isPrimary = "primaryAction".equals(actionKey);
        this.clusterUser = (String)context.getAttribute("clusterUser", String.class);
        OpenGaussAction action = isPrimary ? (OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class)) : (OpenGaussAction)((Object)context.getAttribute("mainStandbyAction", OpenGaussAction.class));
        this.devSn = action.getDevSn();
        List actionList = isPrimary ? context.getObjects("primaryActionList", OpenGaussAction.class) : context.getObjects("StandbyActionList", OpenGaussAction.class);
        this.hostSns = actionList.stream().map(AgentRestAction::getDevSn).collect(Collectors.joining(","));
    }

    private boolean isTestClean() {
        return this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue();
    }

    private void initAttributes(RecoveryProcessorContext context) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            String hostSn = this.getProperty("primaryHostSn");
            context.setAttribute("primaryHostSn", (Object)hostSn);
            return;
        }
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{this.clusterUser, this.devSn, this.hostSns})) {
            LOGGER.error((Object)"Reentrant error, param error.");
            throw new LegoCheckedException(2117645L);
        }
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = extendService.findBySn(this.devSn);
        OpenGaussAction action = new OpenGaussAction(ne, this.devSn);
        List actionList = Arrays.stream(this.hostSns.split(",")).filter(devSN -> !devSN.equals(this.devSn)).map(devSN -> new OpenGaussAction(extendService.findBySn(devSN), (String)devSN)).collect(Collectors.toList());
        actionList.add(action);
        context.setAttribute("clusterUser", (Object)this.clusterUser);
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()) {
            context.setAttribute("primaryAction", (Object)action);
            context.setAttribute("primaryActionList", actionList);
        } else {
            context.setAttribute("mainStandbyAction", (Object)action);
            context.setAttribute("StandbyActionList", actionList);
        }
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setHostSns(String hostSns) {
        this.hostSns = hostSns;
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getHostSns() {
        return this.hostSns;
    }
}

