/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;

public class TestOpenGaussAppSubProcessor
extends OpenGaussBaseProcessor {
    private static final long serialVersionUID = -4405143591136568083L;
    private static final Log LOGGER = LogFactory.getInstance(TestOpenGaussAppSubProcessor.class);
    private static final long TEST_CLUSTER_TIMEOUT = 600000L;
    private static final long TEST_INTERVAL = 20000L;
    private OpenGaussAction action;
    private String clusterUser;

    public boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{this.action, recoveryProcessorContext, this.clusterUser})) {
            LOGGER.error((Object)"Illegal param, exists a null param.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        long timeout = LegoConfig.getInstance().getNumber("opengauss.testcluster.timeout", 600000L);
        long startTime = System.currentTimeMillis();
        int failedNum = 0;
        while (System.currentTimeMillis() - startTime <= timeout) {
            try {
                this.action.testConnection(this.clusterUser);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            catch (LegoCheckedException ex) {
                LOGGER.error((Object)"Cluster status is not degraded or available, failedNum: %s. dev sn: %s, cluster name: %s.", new Object[]{++failedNum, this.action.getDevSn(), this.clusterUser});
                CommUtil.pauseThread((long)20000L);
            }
        }
        this.updateProcessDetail("lego.err.1073947433", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    public void setAction(OpenGaussAction action) {
        this.action = action;
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public OpenGaussAction getAction() {
        return this.action;
    }

    public String getClusterUser() {
        return this.clusterUser;
    }
}

