/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussLunInfo;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.opengauss.adapter.service.impl.OpenGaussManagerImpl;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.sdk.IOpenGaussService;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class OpenGaussServiceImpl
implements IOpenGaussService {
    private static final Log LOG = LogFactory.getInstance(OpenGaussServiceImpl.class);
    private IMoDao moDao;
    private OpenGaussManagerImpl manager;

    public Optional<OpenGaussCluster> queryCluster(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hostSN", hostSn);
        props.put("clusterUser", clusterUser);
        List clusters = this.moDao.findMoBy(OpenGaussCluster.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)clusters)) {
            return Optional.empty();
        }
        return clusters.stream().findFirst();
    }

    public List<OpenGaussCluster> queryCluster(List<String> hostIpList, String clusterUser) {
        VerifyUtil.checkObject(hostIpList);
        ArrayList<OpenGaussCluster> openGaussClusters = new ArrayList<OpenGaussCluster>();
        for (String hostIp : hostIpList) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("managedIpAddress", hostIp);
            List hostList = this.moDao.findMoBy(Host.class, "moId", true, props);
            if (VerifyUtil.isEmpty((Collection)hostList)) continue;
            Optional<OpenGaussCluster> openGaussClusterOpt = this.queryCluster(((Host)hostList.get(0)).getHostSN(), clusterUser);
            openGaussClusterOpt.ifPresent(openGaussClusters::add);
        }
        return openGaussClusters;
    }

    public List<DrHostGroup> queryOpenGaussGroup() {
        List drHostGroup = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHostGroup where clusterType =?", new Object[]{DrmAppEnumDefine.CLUSTER_TYPE_E.OPENGAUSS.getValue()});
        return Optional.of(drHostGroup).orElseGet(Collections::emptyList);
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void setManager(OpenGaussManagerImpl manager) {
        this.manager = manager;
    }

    public void execBuild(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        String buildType = this.manager.buildCheck(hostSn, clusterUser);
        if (!OpenGaussEumDefine.BuildType.NEEDLESS_BUILD.getValue().equals(buildType)) {
            LOG.info((Object)"Start exec building, clusterUser: %s, build type: %s.", new Object[]{clusterUser, buildType});
            if (!this.manager.execBuild(hostSn, clusterUser, OpenGaussEumDefine.BuildType.getByType(buildType))) {
                LOG.error((Object)"Exec building failed, clusterUser: %s", new Object[]{clusterUser});
                throw new LegoCheckedException(1073949735L);
            }
            LOG.info((Object)"Succeed building");
        }
    }

    public void stopCluster(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        this.manager.stopCluster(hostSn, clusterUser);
    }

    public boolean isMainStandby(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        return this.manager.isMainStandby(hostSn, clusterUser);
    }

    public void configLunInfo(List<String> hostIpList, String clusterUser, OpenGaussLunInfo lunInfo) {
        VerifyUtil.checkObject(hostIpList);
        VerifyUtil.checkObject((Object)lunInfo);
        for (String hostIp : hostIpList) {
            LOG.info((Object)"Start config lun info, hostIp: %s, clusterUser: %s", new Object[]{hostIp, clusterUser});
            try {
                this.manager.configLunInfo(hostIp, clusterUser, lunInfo);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Config lun info failed, hostIp: %s, clusterUser: %s, error: %s", new Object[]{hostIp, clusterUser, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073949739L);
            }
        }
    }

    public String buildCheck(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        return this.manager.buildCheck(hostSn, clusterUser);
    }

    public void startCluster(String hostSn, String clusterUser) {
        VerifyUtil.checkStrs((String[])new String[]{hostSn, clusterUser});
        this.manager.startCluster(hostSn, clusterUser);
    }
}

