/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.topology;

import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.Group;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.Optional;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-57")
public class OpenGaussGlobalTopoBuilder
extends AbstractGlobalTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussGlobalTopoBuilder.class);
    private static final String LAYOUT = "layout";

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(context.getProtectGroup().getUuid(), false);
        int poType = protectGroup.getPoType();
        if (poType != 19 || protectGroup.getTemplate().getType() != 57) {
            return;
        }
        ElementBox layout = (ElementBox)context.find((Object)LAYOUT);
        ProtectGroupReplica protectGroupReplica = this.getProtectGroupReplica(protectGroup);
        DrStorage poStorage = this.convertToDrstorage(this.getDrResource(protectGroupReplica.getProductArray()));
        DrStorage reStorage = this.convertToDrstorage(this.getDrResource(protectGroupReplica.getRecoveryArray()));
        Node poStorageNode = this.createStorage(context, protectGroup, poStorage, layout);
        Node reStorageNode = this.createStorage(context, protectGroup, reStorage, layout);
        this.linkStorage(context, poStorageNode, reStorageNode, protectGroupReplica.getProductArray(), protectGroupReplica.getRecoveryArray());
        Set<String> productHostSns = this.getHostSnList(protectGroup, "PRIMARY");
        this.createHostAndLinkStorage(productHostSns, context, poStorage, poStorageNode);
        Set<String> disasterHostSns = this.getHostSnList(protectGroup, "STANDBY");
        this.createHostAndLinkStorage(disasterHostSns, context, reStorage, reStorageNode);
    }

    private void createHostAndLinkStorage(Set<String> hostSns, TopoBaseContext context, DrStorage storage, Node node) {
        ElementBox box = context.getElementBox();
        ElementBox layout = (ElementBox)context.find((Object)LAYOUT);
        for (String sn : hostSns) {
            DrResource host = this.getDrResourceInContext(context, sn);
            if (!(host instanceof DrHost)) continue;
            Group proSite = this.getOrCreateGroup(box, this.getSiteInContext(context, storage.getSiteId()), layout, false);
            Node hostNode = this.createHostNode(context, (DrHost)host, proSite, layout, storage.getSiteId());
            this.createHostStorageLink(context, hostNode, node, true);
        }
    }

    private void linkStorage(TopoBaseContext context, Node poStorageNode, Node reStorageNode, String productArraySn, String recoverArraySn) {
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)poStorageNode, (Node)reStorageNode);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (link == null) {
            this.createStorageLink(context, productArraySn, poStorageNode, recoverArraySn, reStorageNode);
        } else {
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    private void createStorageLink(TopoBaseContext context, String productArraySn, Node poStorageNode, String recoverArraySn, Node reStorageNode) {
        if (!productArraySn.equals(recoverArraySn)) {
            ProtectGroup protectGroup = context.getProtectGroup();
            String sLinkId = "storagelink-" + protectGroup.getUuid() + ":" + productArraySn + "->" + recoverArraySn;
            Link link = new Link((Object)sLinkId, poStorageNode, reStorageNode);
            link.setClient("linkToXOffset", 10.0);
            link.setClient("devSN", (Object)productArraySn);
            link.setClient("trgSN", (Object)recoverArraySn);
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", true);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            StringBuilder storageLinkTips = new StringBuilder();
            ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.status"));
            storageLinkTips.append(" ");
            int linkStatus = this.getStorageLinkStatus(context, productArraySn, recoverArraySn);
            if (linkStatus == 3 || linkStatus == 4) {
                link.setStyle("link.color", (Object)"0x1dcfef");
                link.setStyle("arrow.to.color", (Object)"0x1dcfef");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
            } else if (linkStatus == 2 || linkStatus == 1) {
                link.setStyle("link.color", (Object)"0xfc4133");
                link.setStyle("arrow.to.color", (Object)"0xfc4133");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.allbreak"));
            } else {
                link.setStyle("link.color", (Object)"0x31bd16");
                link.setStyle("arrow.to.color", (Object)"0x31bd16");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.normal"));
            }
            link.setToolTip(storageLinkTips.toString());
            link.setStyle("select.alpha", 1.0);
            link.setStyle("select.style", (Object)"none");
            ElementBox topoBox = context.getElementBox();
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
    }

    private Node createHostNode(TopoBaseContext context, DrHost hostInfo, Group group, ElementBox layout, String site) {
        String nodeId = hostInfo.getDeviceSn() + "---" + site;
        if (context.getElementBox().getElementByID((Object)nodeId) instanceof Node) {
            Node hostNode = (Node)context.getElementBox().getElementByID((Object)nodeId);
            return hostNode;
        }
        Node hostNode = this.initHostNode(hostInfo, nodeId);
        this.initNodeLocation(hostNode, (Node)group, layout);
        group.addChild((IData)hostNode);
        this.addIdtoList(context.getHostNodeIds(), nodeId);
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)hostNode);
        return hostNode;
    }

    private Node initHostNode(DrHost hostInfo, String nodeId) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node hostNode = new Node((Object)nodeId);
        hostNode.setStyle("label.bold", false);
        hostNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostNode.setStyle("label.color", 35020);
        HostElement.setImageByStatus((Node)hostNode, (String)hostInfo.getStatus());
        hostNode.setClient("imageWidth", 48.0);
        hostNode.setClient("imageHeight", 60.0);
        hostNode.setName(TopoServiceUtil.getNodeShowName((String)hostInfo.getName()));
        hostNode.setToolTip(HostElement.createHostToolTip((DrHost)hostInfo));
        DrResource parent = hostInfo.getParentDrResource();
        if (parent instanceof DrHostGroup) {
            hostNode.setClient("clusterSn", (Object)parent.getDeviceSn());
            this.setNodeExtName(hostNode, hostInfo.getName(), parent.getName(), "ism.drm.topo.hypermetro.hostgroup");
        }
        hostNode.setStyle("select.alpha", 1.0);
        hostNode.setStyle("select.style", (Object)"none");
        return hostNode;
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup) {
        Optional optional = protectGroup.getReplicaList().stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Protect group replica list is empty,protect group name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectGroupReplica)optional.get();
    }

    private DrStorage convertToDrstorage(DrResource drResource) {
        DrStorage drStorage = null;
        if (drResource instanceof DrStorage) {
            drStorage = (DrStorage)drResource;
        }
        return drStorage;
    }

    private Set<String> getHostSnList(ProtectGroup protectGroup, String key) {
        ProtectObject po = this.getProtectObject(protectGroup);
        if ("PRIMARY".equals(key)) {
            return OpenGaussUtil.getPrimaryHostSns(po);
        }
        return OpenGaussUtil.getDisasterHost(po);
    }

    private ProtectObject getProtectObject(ProtectGroup protectGroup) {
        Optional optional = protectGroup.getPolist().stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Protect group po list is empty,protect group name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectObject)optional.get();
    }
}

