/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.util;

import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class OpenGaussUtil {
    private static final Log LOG = LogFactory.getInstance(OpenGaussUtil.class);

    private OpenGaussUtil() {
    }

    public static String getClusterUser(ProtectObject protectObject) {
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        return Optional.ofNullable(clusterUser).orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    public static String getProtocol(String transportProtocol) {
        if (VerifyUtil.isEmpty((String)transportProtocol)) {
            return "";
        }
        if (transportProtocol.startsWith("Fibre channel")) {
            return DrmEnumDefine.InitiatorType.FC.getName();
        }
        if (transportProtocol.startsWith("RoCE")) {
            return DrmEnumDefine.InitiatorType.NVME_OVER_ROCE.getName();
        }
        return "";
    }

    public static boolean isSupportProtocol(String protocol) {
        return DrmEnumDefine.InitiatorType.FC.getName().equals(protocol) || DrmEnumDefine.InitiatorType.NVME_OVER_ROCE.getName().equals(protocol);
    }

    public static Set<String> getDisasterHost(ProtectObject protectObject) {
        String nodeConfig = (String)protectObject.getProps().get("nodeConfig");
        JSONObject jsonObject = JSONObject.fromObject((Object)nodeConfig);
        JSONArray hostList = jsonObject.getJSONArray("STANDBY");
        if (VerifyUtil.isEmpty((Collection)hostList)) {
            throw new LegoCheckedException(1073947393L);
        }
        return new HashSet<String>((Collection<String>)hostList);
    }

    public static Set<String> getPrimaryHostSns(ProtectObject protectObject) {
        String nodeConfig = (String)protectObject.getProps().get("nodeConfig");
        JSONObject jsonObject = JSONObject.fromObject((Object)nodeConfig);
        JSONArray hostList = jsonObject.getJSONArray("PRIMARY");
        if (VerifyUtil.isEmpty((Collection)hostList)) {
            throw new LegoCheckedException(1073947393L);
        }
        return new HashSet<String>((Collection<String>)hostList);
    }

    public static ProtectObject getProtectObject(ProtectGroup protectGroup) {
        VerifyUtil.checkObjs((Object[])new Object[]{protectGroup});
        Optional optional = protectGroup.getPolist().stream().findFirst();
        if (!optional.isPresent()) {
            LOG.error((Object)"Protect group po list is empty,protect group name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectObject)optional.get();
    }

    public static ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup) {
        VerifyUtil.checkObjs((Object[])new Object[]{protectGroup});
        Optional optional = protectGroup.getReplicaList().stream().findFirst();
        if (!optional.isPresent()) {
            LOG.error((Object)"Protect group replica list is empty,protect group name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectGroupReplica)optional.get();
    }

    public static boolean isAlreadySwitchover(ProtectGroup protectGroup, RecoveryProcessorContext context, boolean isPrimary) {
        ProtectObject protectObject = OpenGaussUtil.getProtectObject(protectGroup);
        Set<String> disasterHosts = isPrimary ? OpenGaussUtil.getPrimaryHostSns(protectObject) : OpenGaussUtil.getDisasterHost(protectObject);
        String clusterUser = OpenGaussUtil.getClusterUser(protectObject);
        boolean isAlreadySwitchover = false;
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        try {
            for (String sn : disasterHosts) {
                OpenGaussAction action = new OpenGaussAction(extendService.findBySn(sn), sn);
                if (isPrimary && action.isMainStandby(clusterUser)) {
                    action.testConnection(clusterUser);
                    context.setAttribute("primaryAction", (Object)action);
                    context.setAttribute("clusterUser", (Object)clusterUser);
                    isAlreadySwitchover = true;
                    break;
                }
                if (isPrimary || !action.isPrimary(clusterUser)) continue;
                action.testConnection(clusterUser);
                context.setAttribute("mainStandbyAction", (Object)action);
                context.setAttribute("clusterUser", (Object)clusterUser);
                isAlreadySwitchover = true;
                break;
            }
            return isAlreadySwitchover;
        }
        catch (LegoCheckedException e) {
            return false;
        }
    }
}

