/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.interceptor;

import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class RemoveSessionInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final transient ReentrantLock lock = new ReentrantLock(true);
    private HttpServletRequest request;

    public RemoveSessionInterceptor() {
        super("post-stream-ending");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) throws Fault {
        this.lock.lock();
        try {
            if (this.request == null) {
                return;
            }
            HttpSession session = null;
            try {
                session = this.request.getSession();
            }
            catch (Exception err) {
                this.lock.unlock();
                return;
            }
            if (session == null) {
                return;
            }
            Object isMachineLogin = session.getAttribute("IS_MACHINE_TO_MACHINE");
            if (isMachineLogin != null && isMachineLogin instanceof Boolean && ((Boolean)isMachineLogin).booleanValue()) {
                session.invalidate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRequest(HttpServletRequest request) {
        this.lock.lock();
        this.request = request;
        this.lock.unlock();
    }
}

