/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ConfigPropertyData;
import com.huawei.lego.cbb.resource.sdk.model.DeviceConfigData;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 2;
    private static final int NUM_2 = 1;
    private static final int COLUMNWIDTH = 8000;
    private static final short CELL_COLOR_WHITE_VALUE = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    private static final byte[] DEV_COLOR = new byte[]{-1, -21, -100};
    private static final short DEV_INDEX = 50;
    private static final byte[] PROPERTY_TYPE_COLOR = new byte[]{-72, -52, -28};
    private static final short PROPERTY_TYPE_INDEX = 51;
    private static final byte[] PROPERTY_COLUMN_COLOR = new byte[]{-37, -27, -15};
    private static final short PROPERTY_COLUMN_INDEX = 52;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ROW_COLUMN_ONE = 1;
    private static final int ROW_COLUMN_WIDTH = 5600;
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;
    private HSSFPalette palette = this.workbook.getCustomPalette();

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)"Do not find the file", 653110169042944L);
            return;
        }
        this.writeExcelString(dataLst);
    }

    private void writeExcelString(List<List<String>> dataLst) {
        if (dataLst == null) {
            return;
        }
        this.writeExcelWithDetail(dataLst, null);
    }

    @Override
    public void writeConfigData(List<List<DeviceConfigData>> configList) {
        if (null == this.getWriteFileName()) {
            LOGGER.info((Object)"Do not find the file", 653110169042944L);
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)"Do not find the file", 653110169042944L);
            return;
        }
        try {
            if (null != configList) {
                this.initColorAtIndex();
                HSSFCellStyle[] cellStyle = new HSSFCellStyle[4];
                this.initCellStyleArr(cellStyle);
                this.writeDevData(configList, cellStyle);
            } else {
                LOGGER.info((Object)"The product config data is null,", 653110169042944L);
            }
            this.closeFile();
        }
        catch (IOException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Export the file error", (long)-1L, null, (Log)LOGGER);
        }
    }

    private void initCellStyleArr(HSSFCellStyle[] cellStyle) {
        cellStyle[0] = this.workbook.createCellStyle();
        cellStyle[0].setBorderRight(BorderStyle.THIN);
        cellStyle[0].setBorderLeft(BorderStyle.THIN);
        cellStyle[0].setBorderTop(BorderStyle.THIN);
        cellStyle[0].setBorderBottom(BorderStyle.THIN);
        cellStyle[0].setFillForegroundColor((short)50);
        cellStyle[0].setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle[1] = this.workbook.createCellStyle();
        cellStyle[1].setBorderRight(BorderStyle.THIN);
        cellStyle[1].setBorderLeft(BorderStyle.THIN);
        cellStyle[1].setBorderTop(BorderStyle.THIN);
        cellStyle[1].setBorderBottom(BorderStyle.THIN);
        cellStyle[1].setFillForegroundColor((short)51);
        cellStyle[1].setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle[2] = this.workbook.createCellStyle();
        cellStyle[2].setBorderRight(BorderStyle.THIN);
        cellStyle[2].setBorderLeft(BorderStyle.THIN);
        cellStyle[2].setBorderTop(BorderStyle.THIN);
        cellStyle[2].setBorderBottom(BorderStyle.THIN);
        cellStyle[2].setFillForegroundColor((short)52);
        cellStyle[2].setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle[3] = this.workbook.createCellStyle();
        cellStyle[3].setBorderRight(BorderStyle.THIN);
        cellStyle[3].setBorderLeft(BorderStyle.THIN);
        cellStyle[3].setBorderTop(BorderStyle.THIN);
        cellStyle[3].setBorderBottom(BorderStyle.THIN);
        cellStyle[3].setFillForegroundColor(CELL_COLOR_WHITE_VALUE);
        cellStyle[3].setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    private void writeDevData(List<List<DeviceConfigData>> configList, HSSFCellStyle[] cellStyle) {
        for (int i = 0; i < configList.size(); ++i) {
            List<DeviceConfigData> list = configList.get(i);
            if (VerifyUtil.isEmpty(list)) {
                this.checkSheet();
                continue;
            }
            String sheetName = list.get(0).getType();
            if (this.checkSheetName(sheetName)) continue;
            if (null == sheetName) {
                sheetName = list.get(0).getType();
            }
            HSSFSheet sheet = this.workbook.createSheet(sheetName);
            this.writeDevData(i, cellStyle, list, sheet);
        }
    }

    private void checkSheet() {
        String sheet1 = "Sheet1";
        if (!this.checkSheetName(sheet1)) {
            this.workbook.createSheet(sheet1);
        }
    }

    private void writeDevData(int i, HSSFCellStyle[] cellStyle, List<DeviceConfigData> list, HSSFSheet sheet) {
        for (int j = 0; j < list.size(); ++j) {
            DeviceConfigData mo = list.get(j);
            if (null == mo) {
                LOGGER.info((Object)"The product config data is null", 653110169042944L);
                continue;
            }
            int lastRow = sheet.getLastRowNum();
            if (lastRow == -1) {
                lastRow = 0;
            }
            if (0 != j) {
                ++lastRow;
            }
            this.writeSingleDevData(i, sheet, mo, lastRow, cellStyle);
        }
    }

    private void initColorAtIndex() {
        this.palette.setColorAtIndex((short)50, DEV_COLOR[0], DEV_COLOR[1], DEV_COLOR[2]);
        this.palette.setColorAtIndex((short)51, PROPERTY_TYPE_COLOR[0], PROPERTY_TYPE_COLOR[1], PROPERTY_TYPE_COLOR[2]);
        this.palette.setColorAtIndex((short)52, PROPERTY_COLUMN_COLOR[0], PROPERTY_COLUMN_COLOR[1], PROPERTY_COLUMN_COLOR[2]);
    }

    private boolean checkSheetName(String sheetName) {
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            String oldName = this.workbook.getSheetAt(i).getSheetName();
            if (!sheetName.equals(oldName)) continue;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Duplicate sheetname, old sheet is %s,new sheetname is %s", oldName, sheetName), 653110169042944L);
            return true;
        }
        return false;
    }

    private void writeSingleDevData(int sheetIndex, HSSFSheet sheet, DeviceConfigData data, int lastRow, HSSFCellStyle[] cellStyle) {
        if (null == data) {
            LOGGER.info((Object)"The config data is null.", 653110169042944L);
            return;
        }
        int columnSize = data.getSize() - 1;
        int currentRow = lastRow;
        for (int i = 0; i < data.getList().size(); ++i) {
            ConfigPropertyData cpData = (ConfigPropertyData)data.getList().get(i);
            if (null == cpData) {
                LOGGER.debug((Object)"The configproperty data is null.", 653110169042944L);
                return;
            }
            String name = this.getFormatValue(cpData.getName());
            HSSFRow rowTitle = sheet.createRow(currentRow);
            CellRangeAddress region = new CellRangeAddress(currentRow, currentRow, 0, columnSize);
            this.setCellStyle(cellStyle, i, rowTitle, region);
            sheet.addMergedRegion(region);
            sheet.getRow(currentRow).getCell(0).setCellType(CellType.STRING);
            sheet.getRow(currentRow).getCell(0).setCellValue(name);
            rowTitle = sheet.createRow(++currentRow);
            int lastColumn = this.getLastColumn(sheetIndex, sheet, cellStyle, currentRow, cpData, rowTitle);
            this.flushBlankColumn(rowTitle, lastColumn, columnSize, cellStyle[2]);
            for (int records = 0; records < cpData.getRecords().size(); ++records) {
                rowTitle = sheet.createRow(++currentRow);
                for (lastColumn = 0; lastColumn < cpData.getHeads().size(); ++lastColumn) {
                    HSSFCell cellValueColumn = rowTitle.createCell(lastColumn);
                    cellValueColumn.setCellStyle(cellStyle[3]);
                    String columnValue = this.getFormatValue((String)((Map)cpData.getRecords().get(records)).get(cpData.getHeads().get(lastColumn)));
                    cellValueColumn.setCellValue(columnValue);
                    cellValueColumn.setCellType(CellType.STRING);
                }
                this.flushWhiteBlankColumn(rowTitle, lastColumn, columnSize, cellStyle[3]);
            }
            ++currentRow;
        }
    }

    private int getLastColumn(int sheetIndex, HSSFSheet sheet, HSSFCellStyle[] cellStyle, int currentRow, ConfigPropertyData cpData, HSSFRow rowTitle) {
        int lastColumn;
        String warningAlarm = "ism.srm.alarm.secondaryThreshold.columnname";
        String majorAlarm = "ism.srm.alarm.importantThreshold.columnname";
        for (lastColumn = 0; lastColumn < cpData.getHeads().size(); ++lastColumn) {
            HSSFCell cell = rowTitle.createCell(lastColumn);
            sheet.setColumnWidth(lastColumn, 5600);
            String propertyColumnName = this.getFormatValue((String)cpData.getHeads().get(lastColumn));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(propertyColumnName);
            cell.setCellStyle(cellStyle[2]);
            if (!this.checkHead(sheetIndex, cpData, lastColumn, warningAlarm, majorAlarm)) continue;
            CellRangeAddress region1 = new CellRangeAddress(currentRow, currentRow, lastColumn, lastColumn + 2);
            for (int m = lastColumn; m <= region1.getLastColumn(); ++m) {
                cell = rowTitle.createCell(m);
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(cellStyle[2]);
            }
            sheet.addMergedRegion(region1);
            sheet.getRow(currentRow).getCell(lastColumn).setCellType(CellType.STRING);
            sheet.getRow(currentRow).getCell(lastColumn).setCellValue(propertyColumnName);
            lastColumn += 2;
        }
        return lastColumn;
    }

    private boolean checkHead(int sheetIndex, ConfigPropertyData cpData, int lastColumn, String warningAlarm, String majorAlarm) {
        return 1 == sheetIndex && (warningAlarm.equals(cpData.getHeads().get(lastColumn)) || majorAlarm.equals(cpData.getHeads().get(lastColumn)));
    }

    private void setCellStyle(HSSFCellStyle[] cellStyle, int i, HSSFRow rowTitle, CellRangeAddress region) {
        for (int m = 0; m <= region.getLastColumn(); ++m) {
            HSSFCell cell = rowTitle.createCell(m);
            cell.setCellType(CellType.STRING);
            if (0 == i) {
                cell.setCellStyle(cellStyle[0]);
                continue;
            }
            cell.setCellStyle(cellStyle[1]);
        }
    }

    private String getFormatValue(String value) {
        if (null == value) {
            return "";
        }
        return value;
    }

    private void flushBlankColumn(HSSFRow rowTitle, int lastColumn, int columnSize, HSSFCellStyle cellstyle) {
        while (lastColumn <= columnSize) {
            HSSFCell cell = rowTitle.createCell(lastColumn);
            cell.setCellStyle(cellstyle);
            ++lastColumn;
        }
    }

    private void flushWhiteBlankColumn(HSSFRow rowTitle, int lastColumn, int columnSize, HSSFCellStyle cellstyle) {
        while (lastColumn <= columnSize) {
            HSSFCell cell = rowTitle.createCell(lastColumn);
            cell.setCellStyle(cellstyle);
            ++lastColumn;
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.workbook.write((OutputStream)this.getWriteFileOut());
        this.getWriteFileOut().flush();
        this.getWriteFileOut().close();
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"write file catch exception.", 653110169042944L);
            return;
        }
        this.writeExcelWithDetail(dataLst, detailLink);
    }

    private void writeExcelWithDetail(List<List<String>> dataLst, String detailLink) {
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowColUsr = sheet.createRow(0);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(1);
        int len = this.getColTitle().size();
        for (int i = 0; i < len; ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        CommUtil.checkObjectExists((Object[])new Object[]{this.workbook});
        short defaultDataFmt = this.workbook.createDataFormat().getFormat("text");
        int rowNumOfSheet = 2;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            int maxLength = VerifyUtil.isEmpty((String)detailLink) ? lstStr.size() : lstStr.size() - 1;
            for (int cellNumOfRow = 0; cellNumOfRow < maxLength; ++cellNumOfRow) {
                sheet.setColumnWidth(cellNumOfRow, 8000);
                this.writeCell(detailLink, lstStr, row, cellNumOfRow, defaultDataFmt);
            }
            ++rowNumOfSheet;
        }
    }

    private void writeCell(String detailLink, List<String> lstStr, HSSFRow row, int cellNumOfRow, short dataFmt) {
        HSSFCell cell = row.createCell(cellNumOfRow);
        cell.setCellType(CellType.STRING);
        HSSFCellStyle cellStyle = cell.getCellStyle();
        cellStyle.setDataFormat(dataFmt);
        if (null != lstStr.get(cellNumOfRow)) {
            cell.setCellValue(lstStr.get(cellNumOfRow));
        } else {
            cell.setCellValue("");
        }
        if (VerifyUtil.isEmpty((String)detailLink)) {
            return;
        }
        String logId = lstStr.get(lstStr.size() - 1);
        if (!logId.equals("-1") && cellNumOfRow == lstStr.size() - 2) {
            HSSFCellStyle linkStyle = this.workbook.createCellStyle();
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Arial");
            font.setUnderline((byte)1);
            font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            linkStyle.setFont(font);
            String strVal = "";
            if (null != lstStr.get(cellNumOfRow)) {
                strVal = lstStr.get(cellNumOfRow);
            }
            cell.setCellStyle(linkStyle);
            cell.setCellFormula("HYPERLINK(\"" + detailLink + logId + ".txt\",\"" + strVal + "\")");
        }
    }
}

