/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.audio.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.audio.model.AlertAudioSettingInput;
import com.huawei.ism.drm.rest.service.framework.audio.service.IAudioRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.huawei.lego.nem.fault.sdk.service.IAlertNotifyService;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class AudioRestServiceImpl
extends AbstractRestService
implements IAudioRestService {
    @Override
    @Permission(name={"lego.event.voice.scan"})
    public String getAudioSetting() {
        User currentUser = this.getCurrentUser();
        IAlertNotifyService audioService = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
        JSONObject resultObject = new JSONObject();
        if (null != audioService) {
            AlertAudioSetting setting = audioService.getAudioSetting(currentUser.getUserId().longValue());
            AlertAudioSettingInput.constructJSONObjectResult(resultObject, setting);
        }
        return resultObject.toString();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="alarm_modifyVoiceRule_operateName", operationModule="audio", level=3)
    @Permission(name={"lego.event.voice.modify"})
    public Response setAudioSetting(AlertAudioSettingInput setting) {
        AlertAudioSetting alertAudioSetting = setting.getAlertAudioSetting();
        this.checkParam(alertAudioSetting);
        alertAudioSetting.setUserId(this.getCurrentUserId().longValue());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"voiceNotificationSetting_objectName");
        try {
            IAlertNotifyService service = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
            AlertAudioSetting oldAutoSetting = service.getAudioSetting(this.getCurrentUserId().longValue());
            if (oldAutoSetting != null) {
                alertAudioSetting.setId(oldAutoSetting.getId());
            }
            service.setAudioSetting(alertAudioSetting);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkParam(AlertAudioSetting setting) {
        CommUtils.checkParamEmpty(setting);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(setting.getAudioCritical());
        params.add(setting.getAudioMajor());
        params.add(setting.getAudioWarn());
        params.add(setting.getAudioInfo());
        this.checkObjectIsNull(params);
        boolean isEnabledCritical = setting.isEnabledCritical();
        boolean isEnabledInfo = setting.isEnabledInfo();
        boolean isEnabledMajor = setting.isEnabledMajor();
        boolean isEnabledWarn = setting.isEnabledWarn();
        if (isEnabledCritical) {
            this.checkAudioType(setting.getAudioCritical());
        } else {
            setting.setAudioCritical(-1);
        }
        if (isEnabledMajor) {
            this.checkAudioType(setting.getAudioMajor());
        } else {
            setting.setAudioMajor(-1);
        }
        this.checkParam(setting, isEnabledInfo, isEnabledWarn);
    }

    private void checkParam(AlertAudioSetting setting, boolean isEnabledInfo, boolean isEnabledWarn) {
        if (isEnabledWarn) {
            this.checkAudioType(setting.getAudioWarn());
        } else {
            setting.setAudioWarn(-1);
        }
        if (isEnabledInfo) {
            this.checkAudioType(setting.getAudioInfo());
        } else {
            setting.setAudioInfo(-1);
        }
    }

    private void checkAudioType(int audioType) {
        if (audioType != 1 && audioType != 2) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkObjectIsNull(List<Object> objs) {
        for (int i = 0; i < objs.size(); ++i) {
            if (null != objs.get(i)) continue;
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    @OperationLog(operationName="open_or_close_voice_notification_operateName", operationModule="audio", level=1)
    public Response modifyAudioStatus() {
        Boolean isEnabled = true;
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"voiceNotification_objectName");
        try {
            IAlertNotifyService service = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
            User currentUser = this.getCurrentUser();
            if (null == service) {
                List<Object> params = this.getOperationParam(isEnabled);
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)params.get(0).toString());
                throw new LegoCheckedException(102410L);
            }
            long userId = currentUser.getUserId();
            isEnabled = service.getAudioSetting(userId).isEnabled();
            isEnabled = isEnabled != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
            service.modifyAudioStatus(userId, isEnabled.booleanValue());
            List<Object> params = this.getOperationParam(isEnabled);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)params.get(0).toString());
        }
        catch (LegoCheckedException e) {
            List<Object> params = this.getOperationParam(isEnabled);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)params.get(0).toString());
            throw e;
        }
        catch (Exception e) {
            List<Object> params = this.getOperationParam(isEnabled);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)params.get(0).toString());
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private List<Object> getOperationParam(Boolean isEnabled) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (isEnabled.booleanValue()) {
            params.add("alarm_openVoiceNotification_operateName");
            params.add(1);
            params.add("");
        } else {
            params.add("alarm_closeVoiceNotification_operateName");
            params.add(1);
            params.add("");
        }
        return params;
    }
}

