/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.securitypolicy.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.CertSwitchVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.MachineAccountFirstLoginSwitchVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.model.SecurityPolicyVo;
import com.huawei.ism.drm.rest.service.framework.securitypolicy.service.ISecurityPolicyRestService;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILegoConfigService;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class SecurityPolicyRestServiceImpl
extends AbstractRestService
implements ISecurityPolicyRestService {
    private static final int DEFAULT_MINLIFETIME = 3;
    private static final int UNSET_LOCK_TIME_MARK = -1;
    private static final int INIT_LOCK_TIME = 3;
    private static final int ENABLE_PASSWORD_VALID_PERIOD = 1;
    private static final int DISABLE_PASSWORD_VALID_PERIOD = 0;
    private static final Integer SESSION_OUT_TIME = Integer.MAX_VALUE;
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");

    @Override
    public SecurityPolicyVo querySecurityPolicy() {
        SecurityPolicyVo vo = new SecurityPolicyVo();
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        UserLoginPolicy usrLogPolicy = mgr.getLoginPolicy();
        vo.setPassErrNum(usrLogPolicy.getLgoinCount());
        if (usrLogPolicy.getLockTime() == -1) {
            vo.setPassLockTime(3);
        } else {
            vo.setPassLockTime(usrLogPolicy.getLockTime());
        }
        vo.setSessionTime(usrLogPolicy.getSessionTimeOut());
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        vo.setPassLenVal(usrPolicy.getPswLenth());
        String pwdComplex = usrPolicy.getComplex();
        int pwdComplexInt = 8;
        try {
            pwdComplexInt = Integer.parseInt(pwdComplex);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e, 90160758784000L);
        }
        vo.setPassComplexVal(pwdComplexInt);
        if (usrPolicy.getUnseal() == 1) {
            vo.setPassCtrl(true);
        } else {
            vo.setPassCtrl(false);
        }
        vo.setUsefulLife(usrPolicy.getUsefulLife());
        int minlifetime = usrPolicy.getMinlifetime() == null ? 3 : usrPolicy.getMinlifetime();
        vo.setMinlifetime(minlifetime);
        return vo;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_setSecurityPolicy_operateName", operationModule="security_policy", level=3)
    @Permission(name={"lego.sys.sysLoginPolicy.modify"})
    public Response modifySecurityPolicy(SecurityPolicyVo vo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"securityPolicy_objectName");
        this.checkPara(vo);
        try {
            this.doModifySecurityPolicy(vo);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_setCertSwitch_operateName", operationModule="security_policy", level=4)
    @Permission(name={"lego.sys.certSwitch.modify"})
    public Response modifyCertSwitch(CertSwitchVo certSwitchVo) {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"securityPolicy_objectName");
        if (certSwitchVo == null || certSwitchVo.getCertAuthSwitch() == null) {
            LOGGER.error((Object)"ModifyCertSwitch failed cause certAuthSwitch param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (certSwitchVo.getCertAuthSwitch().booleanValue()) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_enable_CertSwitch_operateName");
        } else {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_disable_CertSwitch_operateName");
        }
        ILegoConfigService certConfigService = this.getBundleService(ILegoConfigService.class);
        certConfigService.modifySwitch("cert.auth.switch", certSwitchVo.getCertAuthSwitch());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.sys.certSwitch.scan"})
    public CertSwitchVo getCertSwitch() {
        ILegoConfigService certConfigService = this.getBundleService(ILegoConfigService.class);
        CertSwitchVo certSwitchVo = new CertSwitchVo();
        certSwitchVo.setCertAuthSwitch(certConfigService.getSwitch("cert.auth.switch", Boolean.FALSE));
        return certSwitchVo;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_modify_machine_firstLogin_switch_operateName", operationModule="security_policy", level=4)
    @Permission(name={"lego.sys.machineFirstLoginSwitch.modify"})
    public Response modifyMachineAccountFirstLoginSwitch(MachineAccountFirstLoginSwitchVo firstLoginSwitchVo) {
        if (!"admin".equals(this.getCurrentUser().getUserName())) {
            LOGGER.error((Object)"Only admin user can modify machine account first login switch.");
            throw new LegoCheckedException(1073947400L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)"securityPolicy_objectName");
        if (firstLoginSwitchVo == null || firstLoginSwitchVo.getFistLoginSwitch() == null) {
            LOGGER.error((Object)"ModifyMachineAccountFirstLoginSwitch failed cause param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (firstLoginSwitchVo.getFistLoginSwitch().booleanValue()) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_enable_machine_firstLogin_switch_operateName");
        } else {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_disable_machine_firstLogin_switch_operateName");
        }
        ILegoConfigService certConfigService = this.getBundleService(ILegoConfigService.class);
        certConfigService.modifySwitch("machine.first.login.switch", firstLoginSwitchVo.getFistLoginSwitch());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.sys.machineFirstLoginSwitch.scan"})
    public MachineAccountFirstLoginSwitchVo getMachineAccountFirstLoginSwitch() {
        ILegoConfigService certConfigService = this.getBundleService(ILegoConfigService.class);
        MachineAccountFirstLoginSwitchVo firstLoginSwitchVo = new MachineAccountFirstLoginSwitchVo();
        firstLoginSwitchVo.setFistLoginSwitch(certConfigService.getSwitch("machine.first.login.switch", Boolean.TRUE));
        return firstLoginSwitchVo;
    }

    @Override
    @Permission(name={"lego.sys.httpsConnect.scan"})
    public List<String> getConnectFailedServices() {
        ILegoConfigService certConfigService = this.getBundleService(ILegoConfigService.class);
        return certConfigService.getConnectFailedServices();
    }

    private void doModifySecurityPolicy(SecurityPolicyVo vo) {
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        UserLoginPolicy usrLogPolicytemp = mgr.getLoginPolicy();
        Integer sessionTime = vo.getSessionTime();
        if (LegoProperties.isInstalledIntegrated()) {
            sessionTime = SESSION_OUT_TIME;
        }
        usrLogPolicytemp.setSessionTimeOut(sessionTime.intValue());
        usrLogPolicytemp.setLgoinCount(vo.getPassErrNum().intValue());
        usrLogPolicytemp.setLockTime(vo.getPassLockTime().intValue());
        mgr.updateLoginPolicy(usrLogPolicytemp);
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        usrPolicy.setPswLenth(vo.getPassLenVal());
        usrPolicy.setComplex(String.valueOf(vo.getPassComplexVal()));
        Boolean passCtrl = vo.getPassCtrl();
        if (!VerifyUtil.isEmpty((Object)passCtrl) && passCtrl.booleanValue()) {
            usrPolicy.setUnseal(Integer.valueOf(1));
            usrPolicy.setUsefulLife(vo.getUsefulLife());
            usrPolicy.setMinlifetime(vo.getMinlifetime());
        } else {
            usrPolicy.setUnseal(Integer.valueOf(0));
        }
        mgr.updateUserSecPolicy(usrPolicy);
    }

    private void checkPara(SecurityPolicyVo vo) {
        if (VerifyUtil.isEmpty((Object)vo)) {
            LOGGER.error((Object)"The param vo is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkNumContains(vo.getPassLenVal(), Arrays.asList(8, 10));
        this.checkNumContains(vo.getPassComplexVal(), Arrays.asList(2, 4));
        this.checkNumArea(vo.getSessionTime(), 1, 100);
        this.checkNumArea(vo.getPassErrNum(), 1, 9);
        this.checkNumArea(vo.getPassLockTime(), 3, 2000);
        this.checkPassCtrl(vo);
    }

    private void checkNumArea(Integer num, int min, int max) {
        if (VerifyUtil.isEmpty((Object)num) || num < min || num > max) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkNumContains(Integer num, List<Integer> list) {
        if (VerifyUtil.isEmpty((Object)num) || !list.contains(num)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPassCtrl(SecurityPolicyVo vo) {
        Boolean passCtrl = vo.getPassCtrl();
        if (!VerifyUtil.isEmpty((Object)passCtrl) && passCtrl.booleanValue()) {
            Integer usefulLife = vo.getUsefulLife();
            Integer minLifeTime = vo.getMinlifetime();
            if (VerifyUtil.isEmpty((Object)usefulLife) || usefulLife < 60 || usefulLife > 360) {
                throw new LegoCheckedException(250L);
            }
            if (VerifyUtil.isEmpty((Object)minLifeTime) || minLifeTime < 1 || minLifeTime > 9999) {
                throw new LegoCheckedException(250L);
            }
        }
    }
}

