/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.user.service;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.user.service.IUserRestService;
import com.huawei.ism.drm.rest.service.framework.user.service.UserCustomSettingOperateLogger;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.rest.service.framework.user.service.model.AdminPasswordModifyVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.PasswordModifyVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.RuleNameEnum;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UnLockUsersVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserVo;
import com.huawei.ism.drm.rest.service.framework.user.util.UserUtil;
import com.huawei.ism.drm.rest.util.OperationLog;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.rest.util.ParamValidator;
import com.huawei.ism.drm.rest.util.RandCodeCheck;
import com.huawei.ism.drm.rest.util.WeakPasswordCheckUtil;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.IThirdPartResourcesService;
import com.huawei.lego.cbb.user.sdk.constant.AccountTypeEnum;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserCustomSetting;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.service.IProductsCustomizeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.StringUtils;

public class UserRestServiceImpl
extends AbstractRestService
implements IUserRestService {
    public static final long OC_ADMIN_ROLE = -1L;
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static final String ASG = "asg";
    private static final Long ADMIN_ID = 1L;
    private static final int MINUTE_MS = 60000;
    private static final String ADMIN_NAME = "admin";
    private static final String BIZ_OBJECT_TREE_ROOT_ID = "0";
    private static final String SITE_TREE_ROOT_ID = "1";
    private static final String PROTECTGROUP_TREE_ROOT_ID = "2";
    private static final String LOCAL_RECOVERYPLAN_TREE_ROOT_ID = "4";
    private static final String REMOTE_RECOVERYPLAN_TREE_ROOT_ID = "3";
    private static final Integer USER_MODIFY = 0;
    private static final Integer USER_ADD = 1;
    private static final String[] USER_CUSTOM_SETTING_WHITELIST = new String[]{"showQuickStart"};
    private static final Set<Long> LOGOUT_ERROR_CODE_SET = Sets.newHashSet((Object[])new Long[]{2602L, 2606L, 284L});

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.onlineUserMgr.scan"})
    public String getAllOnlineUserInfo(String orderBy, String orderType, int startPage, int pageSize) {
        if (startPage < 0 || pageSize < 0) {
            LOGGER.error((Object)"startPage or pageSize < 0", 653110169894912L);
            throw new LegoCheckedException(1073947393L);
        }
        User user = this.getCurrentUser();
        IUserMgrBaseService mgr = this.getUserService();
        Paging page = null;
        int start = startPage * pageSize;
        if (orderBy == null || 0 == orderBy.length()) {
            page = mgr.getAllOnlineUser(user, "stayTime", "DESC", start, pageSize);
        } else {
            try {
                Validator.canOrderBy(orderBy);
                page = mgr.getAllOnlineUser(user, orderBy, orderType, start, pageSize);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("OrderBy is error! OrderBy=" + orderBy), 653110169894912L);
                throw e;
            }
        }
        List usersList = page.getData();
        int total = page.getiCount();
        this.setLoginDate(usersList);
        if (start >= total) {
            int lastrec = total % pageSize;
            start = lastrec == 0 ? total - start : total - lastrec;
            page = orderBy == null || 0 == orderBy.length() ? mgr.getAllOnlineUser(user, "stayTime", "DESC", start, pageSize) : mgr.getAllOnlineUser(user, orderBy, orderType, start, pageSize);
            usersList = page.getData();
            total = page.getiCount();
        }
        this.addAdminFlag(usersList);
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"totalCount", (Object)total);
        returnObject.put((Object)"records", (Object)usersList);
        return returnObject.toString();
    }

    private void setLoginDate(List<User> usersList) {
        for (User u : usersList) {
            Date loginDate = CommUtils.parseDate(u.getLoginDate());
            if (null == loginDate) {
                u.setLoginDate("");
                continue;
            }
            u.setLoginDate(CommUtils.formatDate(loginDate));
        }
    }

    private void addAdminFlag(List<User> usersList) {
        LOGGER.debug((Object)"enter addAdminFlag");
        for (int i = 0; i < usersList.size(); ++i) {
            long userId = usersList.get(i).getUserId();
            boolean isAdministrator = userId > 0L ? this.checkIsAdministrator(userId) : true;
            usersList.get(i).setIsAdministrator(Boolean.valueOf(isAdministrator).toString());
        }
    }

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.operatorMgr.operator.scan"})
    public String getAllUserInfo(String orderBy, String orderType, int start, int pageSize) {
        if (!Validator.checkPageQueryParams(orderType, pageSize, start)) {
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgrBaseService mgr = this.getUserService();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        try {
            if (orderBy != null) {
                Validator.canOrderBy(orderBy);
                if (orderType.equalsIgnoreCase("desc")) {
                    queryMap.put("DESC", orderBy);
                } else {
                    queryMap.put("ASC", orderBy);
                }
            } else {
                queryMap.put("DESC", "id");
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("OrderBy is error! OrderBy=" + orderBy), 653110169894912L);
            throw e;
        }
        Paging page = mgr.getAllUser(queryMap, start * pageSize, pageSize);
        int total = page.getiCount();
        List userList = page.getData();
        for (User usr : userList) {
            if (UserRestServiceValidator.checkIsAdministrator(usr.getUserId())) {
                usr.setIsAdministrator("true");
            }
            usr.setMoAuthIdsSet(null);
            usr.setMoAutSeth(null);
            usr.setMoGroupIdsSet(null);
            usr.setRolesSet(null);
            usr.setRolesIdsSet(null);
            usr.setUserAclSet(null);
            usr.setUserPassword("");
            usr.setUserPasswordSalt("");
            if (usr.getDescription() == null || !"null".equals(usr.getDescription())) continue;
            usr.setDescription("null ");
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"total", (Object)total);
        returnObject.put((Object)"userList", (Object)userList);
        return returnObject.toString();
    }

    @Override
    @ParamValidator
    public UserVo getUserInfoById(String userId) throws ClassNotFoundException {
        long uId;
        LOGGER.debug((Object)"enter getUserInfoById");
        if (VerifyUtil.isEmpty((String)userId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!userId.equals(String.valueOf(this.getCurrentUserId()))) {
            this.checkUserOperationAuthority("user_queryUser_operateName", 2, "lego.sys.operatorMgr.operator.scan");
        }
        try {
            uId = Long.parseLong(userId);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        IUserMgrBaseService mgr = this.getUserService();
        User queryUsr = mgr.getUserInfo(uId);
        String isAdministrator = "false";
        if (this.checkIsAdministrator(queryUsr.getUserId())) {
            isAdministrator = "true";
        }
        queryUsr.setIsAdministrator(isAdministrator);
        queryUsr.setUserPassword("");
        queryUsr.setUserPasswordSalt("");
        for (UserAcl userAcl : queryUsr.getUserAclSet()) {
            if (userAcl.getStartIpStr().contains(".") || userAcl.getStartIpStr().contains(":")) continue;
            userAcl.setStartIpStr(Ipv4AddressUtil.longToIPv4((long)NumberUtil.convertToLong((Object)userAcl.getStartIpStr())));
            userAcl.setEndIpStr(Ipv4AddressUtil.longToIPv4((long)NumberUtil.convertToLong((Object)userAcl.getEndIpStr())));
        }
        return UserUtil.convertUser2UserVo(queryUsr, this.loadUserGrantedObjects(queryUsr.getUserId()));
    }

    private String[] loadUserGrantedObjects(Long userId) {
        LOGGER.debug((Object)"enter loadUserGrantedObjects");
        String[] bizObjs = null;
        IBizScopeManager manager = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
        List objList = manager.getUserGrantObject(userId);
        if (!VerifyUtil.isEmpty((Collection)objList)) {
            int size = objList.size();
            bizObjs = new String[size];
            for (int i = 0; i < size; ++i) {
                bizObjs[i] = ((DRMObject)objList.get(i)).getUuid();
            }
        }
        return bizObjs;
    }

    private IUserMgrBaseService getUserService() {
        LOGGER.debug((Object)"enter getUserService");
        return (IUserMgrBaseService)this.getBundleService("user", "usermgr");
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_createUser_operateName", operationModule="user", level=1)
    @Permission(name={"lego.sys.operatorMgr.operator.add"})
    public Response createUser(UserVo user, int byType) {
        if (user == null) {
            throw new LegoCheckedException(250L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)user.getUserName());
        if (byType != 0 && byType != 1) {
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        user.setPasswordModel(UserAuthorityType.LOCAL.getValue());
        boolean isValidate = this.validateSaveUser(user, mgr, true);
        this.checkUserPwd(user, isValidate);
        Set roleSet = user.getRolesIdsSet();
        User currentuser = this.getCurrentUser();
        this.machineUserOperateCheck(user, currentuser);
        UserRestServiceValidator.checkCreateUserParam(user, mgr, roleSet, currentuser);
        if (roleSet.contains(-1L)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAcl(user, mgr);
        String projectName = "";
        IProductsCustomizeService pcs = (IProductsCustomizeService)this.getBundleService("discover", "ProductsCustomizeServiceImpl");
        if (null != pcs && pcs.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            projectName = (String)pcs.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        Set<Long> resIds = user.getResIds();
        List<Long> resourcesIds = this.dealResourceIds(user, currentuser, resIds, USER_ADD);
        try {
            this.doCreateUser(user, resIds, resourcesIds, projectName);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("create role error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("create role error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void machineUserOperateCheck(UserVo user, User currentuser) {
        if (AccountTypeEnum.MACHINE.equals((Object)user.getUserType()) && !ADMIN_NAME.equals(currentuser.getUserName())) {
            LOGGER.error((Object)"Only admin user can create machine user.");
            throw new LegoCheckedException(1073947400L);
        }
    }

    private void checkUserPwd(UserVo user, boolean isValidate) {
        if (!isValidate) {
            throw new LegoCheckedException(250L);
        }
        if (WeakPasswordCheckUtil.getInstance().checkWeakPassword(user.getConfirmPassword())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_WEAK.intValue());
        }
        if (UserRestServiceValidator.checkComman(user.getUserName(), user.getConfirmPassword()).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
    }

    private void doCreateUser(UserVo user, Set<Long> resIds, List<Long> resourcesIds, String projectName) {
        LOGGER.debug((Object)"enter doCreateUser");
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        if (UserAuthorityType.LOCAL.getValue() == user.getPasswordModel()) {
            user.setMustModifyPwd(true);
        }
        long userId = mgr.addUserInfo(UserRestServiceValidator.convertUserVoToUser(user));
        if (null != projectName && projectName.equalsIgnoreCase(ASG) && resIds != null && !resIds.isEmpty()) {
            IThirdPartResourcesService tprService = (IThirdPartResourcesService)this.getBundleService("asgResource", "thirdPartResources");
            tprService.grandResourcesToUser(userId, resourcesIds);
        }
        this.forceLogout(user, mgr, this.getCurrentUser(), userId);
        this.dealScopeManager(user, mgr);
    }

    private void checkResourceExist(Collection<Long> resIds, boolean newUser) {
        LOGGER.debug((Object)"enter checkResourceExist");
        if (VerifyUtil.isEmpty(resIds)) {
            return;
        }
        HashMap<String, Object[]> query = new HashMap<String, Object[]>();
        query.put("moId", resIds.toArray());
        List moList = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (VerifyUtil.isEmpty((Collection)moList) || moList.size() < resIds.size()) {
            ArrayList<Long> wrongResource = new ArrayList<Long>(resIds);
            for (ManagedObject mo : moList) {
                wrongResource.remove(mo.getMoId());
            }
            StringBuilder sb = new StringBuilder();
            for (Long id : wrongResource) {
                if (sb.length() != 0) {
                    sb.append("; ");
                }
                sb.append(id);
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)sb.toString());
            if (newUser) {
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_createUser_operateName");
            } else {
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_NAME, (Object)"user_modifyUser_operateName");
            }
            throw new LegoCheckedException(1073947394L);
        }
    }

    private List<Long> dealResourceIds(UserVo user, User currentuser, Set<Long> resIds, Integer modifyOrCreate) {
        LOGGER.debug((Object)"enter dealResourceIds");
        ArrayList<Long> resourcesIds = new ArrayList<Long>();
        Set<Long> checkResIds = this.filterResources(resIds, user, currentuser, modifyOrCreate);
        this.checkMoAndAdministrator(checkResIds, modifyOrCreate);
        user.setMoAuthIdsSet(resIds);
        if (resIds != null) {
            resourcesIds.addAll(resIds);
        }
        if (!VerifyUtil.isEmpty(resIds)) {
            HashSet<Long> resIdset = new HashSet<Long>(resIds);
            resIdset.remove(0L);
            resIdset.remove(1L);
            this.checkResourceExist(resIdset, USER_ADD.equals(modifyOrCreate));
        }
        return resourcesIds;
    }

    private Set<Long> filterResources(Set<Long> resIds, UserVo user, User currentuser, Integer modifyOrCreate) {
        LOGGER.debug((Object)"enter filterResources");
        if (resIds == null) {
            resIds = new HashSet<Long>();
        }
        if (resIds.size() > 10000) {
            LOGGER.error((Object)"Too many resIds in request.");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Long> newResIds = new HashSet<Long>();
        if (USER_ADD.equals(modifyOrCreate)) {
            newResIds.addAll(resIds);
            newResIds.remove(0L);
            newResIds.remove(1L);
            return newResIds;
        }
        if (!"true".equals(currentuser.getIsAdmin())) {
            IUserMgrBaseService mgr = this.getUserService();
            User userInfo = mgr.getUserInfo(user.getUserId().longValue());
            Set moIdSet = userInfo.getMoAuthIdsSet();
            if (VerifyUtil.isEmpty((Collection)moIdSet)) {
                newResIds.addAll(resIds);
            } else {
                for (Long resId : resIds) {
                    if (moIdSet.contains(resId)) continue;
                    newResIds.add(resId);
                }
                for (Long moId : moIdSet) {
                    if (resIds.contains(moId)) continue;
                    newResIds.add(moId);
                }
            }
        }
        newResIds.remove(0L);
        newResIds.remove(1L);
        return newResIds;
    }

    private void dealScopeManager(UserVo user, IUserMgrBaseService mgr) {
        User oUser = mgr.getUserByName(user.getUserName());
        String[] bizObjArray = user.getBizObjs();
        String bizObjs = UserUtil.bizObjsArrayToStr(bizObjArray);
        if (null != oUser) {
            Long oUserId = oUser.getUserId();
            IBizScopeManager scope = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
            try {
                scope.saveOrUpdateObject(bizObjs, oUserId);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"save user business object error", (Throwable)e, 90160758784001L);
                throw e;
            }
        }
    }

    private void forceLogout(UserVo user, IUserMgrBaseService mgr, User currentuser, Long userId) {
        if (String.valueOf(currentuser.getUserId()).equals(String.valueOf(userId))) {
            LOGGER.info((Object)"Force logout end, cause can't logout itself");
            return;
        }
        List users = mgr.getAllOnlineUser(null);
        if (VerifyUtil.isEmpty((Collection)users)) {
            LOGGER.info((Object)"Force logout end, cause no online user");
            return;
        }
        for (User u : users) {
            if (!user.getUserName().equals(u.getUserName())) continue;
            LOGGER.info((Object)("Force logout. User: " + user.getUserName()), 653110169894912L);
            try {
                mgr.forceLogout(u.getSession());
                this.writeSucOperationLog("user_forceOffline_operateName", 2, user.getUserName(), null, null);
            }
            catch (Exception e) {
                this.writeFailedOperationLogNoException("user_forceOffline_operateName", 2, user.getUserName(), e);
            }
        }
    }

    private void checkUserAcl(UserVo user, IUserMgrBaseService mgr) {
        User aclusr;
        LOGGER.debug((Object)"enter checkUserAcl");
        int selectType = 0;
        Iterator iteracl = null;
        Long userId = user.getUserId();
        if (null != userId && userId != 0L && null != (aclusr = mgr.getUserInfo(user.getUserId().longValue()))) {
            iteracl = aclusr.getUserAclSet().iterator();
        }
        UserRestServiceValidator.subCheckUserAcl(user, iteracl);
        user.setSelectType(selectType);
    }

    private Boolean validateSaveUser(UserVo user, IUserMgrBaseService mgr, Boolean isNewUser) {
        LOGGER.debug((Object)"enter validateSaveUser");
        if (this.getCurrentUserId().equals(user.getUserId()) && !ADMIN_ID.equals(this.getCurrentUserId())) {
            return false;
        }
        this.checkBizObjAuth(user, isNewUser);
        User currentUser = this.getCurrentUser();
        if (ADMIN_ID.equals(user.getUserId()) && !ADMIN_ID.equals(currentUser.getUserId())) {
            return false;
        }
        if ("true".equalsIgnoreCase(user.getIsAdmin().trim()) && !ADMIN_ID.equals(user.getUserId()) && !user.isSyncAdmin()) {
            return false;
        }
        if (user.isSyncAdmin() && !ADMIN_ID.equals(this.getCurrentUserId())) {
            return false;
        }
        UserRestServiceValidator.checkUserLenth(user);
        UserRestServiceValidator.checkPwdModel(user, mgr, isNewUser);
        this.vailidSessionControl(user);
        return true;
    }

    private void vailidSessionControl(UserVo user) {
        LOGGER.debug((Object)"enter vailidSessionControl");
        if (null == user.getSessionControl() || !user.getSessionControl().booleanValue()) {
            return;
        }
        int sessionLimit = NumberUtil.getIntValue((Integer)user.getSessionLimit());
        if (0 >= sessionLimit || 8 < sessionLimit) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkBizObjAuth(UserVo user, Boolean isNewUser) {
        Object[] bizObjs = user.getBizObjs();
        if (!ParamChecker.checkList((Object[])bizObjs, ParamChecker::checkGeneralId, (int)4096)) {
            LOGGER.error((Object)"Too many bizObjs in request.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            if (isNewUser.booleanValue()) {
                if (VerifyUtil.isEmpty((Object[])bizObjs)) {
                    return;
                }
                for (Object id : bizObjs) {
                    this.checkUserBizObjAuthority("user_createUser_operateName", 1, (String)id);
                }
            } else {
                List<String> checkBizObjs = this.filterCheckBizObjs(user);
                for (String id : checkBizObjs) {
                    this.checkUserBizObjAuthority("user_modifyUser_operateName", 3, id);
                }
            }
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"check bizObj error!", (Throwable)ex, ex.getErrorCode());
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"check bizObj error!", (long)-1L, null, (Log)LOGGER);
        }
    }

    private List<String> filterCheckBizObjs(UserVo user) {
        LOGGER.debug((Object)"enter filterCheckBizObjs");
        ArrayList<String> checkBizObjs = new ArrayList<String>();
        Object[] bizObjsArray = user.getBizObjs();
        IBizScopeManager manager = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
        List objList = manager.getUserGrantObject(user.getUserId());
        ArrayList<String> bizObjs = null;
        if (!VerifyUtil.isEmpty((Collection)objList)) {
            bizObjs = new ArrayList<String>();
            int size = objList.size();
            for (int i = 0; i < size; ++i) {
                bizObjs.add(((DRMObject)objList.get(i)).getUuid());
            }
        }
        if (!VerifyUtil.isEmpty(bizObjs)) {
            if (VerifyUtil.isEmpty((Object[])bizObjsArray)) {
                return bizObjs;
            }
            for (Object id : bizObjsArray) {
                if (bizObjs.contains(id)) continue;
                checkBizObjs.add((String)id);
            }
            List<Object> newBizObjs = Arrays.asList(bizObjsArray);
            for (String id : bizObjs) {
                if (newBizObjs.contains(id)) continue;
                checkBizObjs.add(id);
            }
            return checkBizObjs;
        }
        if (VerifyUtil.isEmpty((Object[])bizObjsArray)) {
            return checkBizObjs;
        }
        return Arrays.asList(bizObjsArray);
    }

    private void checkMoAndAdministrator(Set<Long> devSet, Integer modifyOrCreate) {
        LOGGER.debug((Object)"enter checkMoAndAdministrator");
        if (VerifyUtil.isEmpty(devSet)) {
            return;
        }
        for (Long moid : devSet) {
            if (-1L == moid) continue;
            String operateName = "user_createUser_operateName";
            if (modifyOrCreate.equals(USER_MODIFY)) {
                operateName = "user_modifyUser_operateName";
            }
            this.checkUserMoAuthority(operateName, 1, moid);
        }
    }

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.operatorMgr.operator.resetpassword"})
    public Response modifyPasswordByAdmin(AdminPasswordModifyVo pwdModifyVo) {
        LOGGER.info((Object)"Enter modifyPasswordByAdmin");
        UserVo userVo = this.buildUserVo(pwdModifyVo);
        userVo.setPasswordModel(UserAuthorityType.LOCAL.getValue());
        int passwordModel = userVo.getPasswordModel();
        String password = userVo.getUserPassword();
        String confirmPassword = userVo.getConfirmPassword();
        IUserMgrBaseService mgr = null;
        long userId = userVo.getUserId();
        String userName = String.valueOf(userId);
        try {
            mgr = this.getIUserMgrBaseService();
            this.checkPasswordModel(passwordModel, password, confirmPassword);
            if (WeakPasswordCheckUtil.getInstance().checkWeakPassword(password)) {
                throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_WEAK.intValue());
            }
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_resetPWD_operateName", 2, userName, e);
        }
        try {
            User currentUser = this.getCurrentUser();
            User editedUser = this.checkUserInfo(userId, mgr, currentUser);
            userName = editedUser.getUserName();
            userVo.setUserName(userName);
            this.checkAdminPassword(pwdModifyVo.getAdminUserName(), pwdModifyVo.getAdminPassword(), mgr);
            this.doModifyPasswordByAdmin(userVo, confirmPassword, mgr, editedUser);
            this.writeSucOperationLog("user_resetPWD_operateName", 2, editedUser.getUserName(), null, null);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Admin modify users password error", (Throwable)e);
            this.writeFailedOperationLogNoException("user_resetPWD_operateName", 2, userName, (Exception)((Object)e));
            this.logoutForSpecifyError((Exception)((Object)e), mgr);
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_resetPWD_operateName", 2, userName, e);
        }
        this.forceLogout(userVo, mgr, this.getCurrentUser(), pwdModifyVo.getUserId());
        return Response.ok().build();
    }

    private void logoutForSpecifyError(Exception exception, IUserMgrBaseService mgr) {
        long errorCode;
        if (exception instanceof LegoCheckedException && LOGOUT_ERROR_CODE_SET.contains(errorCode = ((LegoCheckedException)((Object)exception)).getErrorCode())) {
            User currentUser = this.getCurrentUser();
            LOGGER.info((Object)"Logout user:%s,ip:%s", new Object[]{currentUser.getUserId(), currentUser.getIpAdr()});
            HttpSession session = this.getSession();
            mgr.logout(session.getId());
            session.invalidate();
        }
    }

    private UserVo buildUserVo(AdminPasswordModifyVo pwdModifyVo) {
        UserVo userVo = new UserVo();
        userVo.setUserId(pwdModifyVo.getUserId());
        userVo.setUserPassword(pwdModifyVo.getUserNewPassword());
        userVo.setConfirmPassword(pwdModifyVo.getUserConfirmPassword());
        return userVo;
    }

    private void checkAdminPassword(String userName, String password, IUserMgrBaseService mgr) {
        int maxPwdLength = 64;
        if (!ADMIN_NAME.equals(userName) || Validator.stringNullTrim(password) || !Validator.checkStringLength(password, maxPwdLength)) {
            LOGGER.error((Object)"CheckOldPassword failed cause param format error!");
            throw new LegoCheckedException(256L);
        }
        try {
            mgr.adminAuth(userName, password);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"CheckOldPassword failed cause User or secret error!");
            throw e;
        }
    }

    private void doModifyPasswordByAdmin(UserVo userVo, String confirmPassword, IUserMgrBaseService mgr, User editedUser) {
        LOGGER.debug((Object)"enter doModifyPasswordByAdmin");
        long userId = userVo.getUserId();
        int passwordModel = userVo.getPasswordModel();
        String password = userVo.getUserPassword();
        if (passwordModel == 0) {
            this.checkComfirmPassword(password, confirmPassword, editedUser);
            this.checkPasswordComplex(password, mgr);
            mgr.updateUserPwdPModel(userId, password, 0, true);
        } else if (passwordModel == 1) {
            mgr.updateUserPwdPModel(userId, "", 1);
        } else {
            int i = 4;
            if (passwordModel == 4) {
                mgr.updateUserPwdPModel(userId, "", 4);
            } else {
                int paramInt = 2;
                mgr.updateUserPwdPModel(userId, "", 2);
            }
        }
    }

    private void checkPasswordComplex(String password, IUserMgrBaseService mgr) {
        LOGGER.debug((Object)"enter checkPasswordComplex");
        if (!Validator.checkMinStringLength(password, mgr.getSystemSecPolicy().getUserSecPolicy().getPswLenth())) {
            throw new LegoCheckedException(1073947393L);
        }
        int length = 64;
        if (!Validator.checkStringLength(password, 64)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!UserRestServiceValidator.isPwdMatchComplex(password, mgr.getSystemSecPolicy().getUserSecPolicy().getComplex())) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkComfirmPassword(String password, String confirmPassword, User editedUser) {
        LOGGER.debug((Object)"enter checkComfirmPassword");
        if (!password.equals(confirmPassword)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if (UserRestServiceValidator.checkComman(editedUser.getUserName(), password).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
        if (KmcCompatible.isDataSame((String)password, (String)editedUser.getUserPasswordSalt(), (String)editedUser.getUserPassword())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMEERROR.intValue());
        }
    }

    private User checkUserInfo(long userId, IUserMgrBaseService mgr, User currentUser) {
        LOGGER.debug((Object)"enter checkUserInfo");
        User editedUser = mgr.getUserInfo(userId);
        if (null == editedUser) {
            throw new LegoCheckedException(250L);
        }
        if ("true".equals(editedUser.getIsAdmin()) && !editedUser.isSyncAdmin()) {
            throw new LegoCheckedException(250L);
        }
        if ("true".equals(currentUser.getIsAdmin())) {
            return editedUser;
        }
        throw new LegoCheckedException(1073947400L);
    }

    private void checkPasswordModel(int passwordModel, String password, String confirmPassword) {
        LOGGER.debug((Object)"enter checkPasswordModel");
        if (passwordModel == 0) {
            CommUtils.checkParamEmpty(password, confirmPassword);
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_modifyPWD_operateName", operationModule="user", level=3)
    public Response modifyPassword(PasswordModifyVo pwdModifyVo) {
        if ("sso".equals(this.getSession().getAttribute("user.login.mode"))) {
            LOGGER.error((Object)"modifyPassword error . sso user can't modifyPassword");
            throw new LegoCheckedException(1073947400L);
        }
        String password = pwdModifyVo.getNewPassword();
        String confirmPassword = pwdModifyVo.getConfirmPassword();
        String oldPassword = pwdModifyVo.getOldPassword();
        User currentUser = this.getCurrentUser();
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        User nowUser = mgr.getUserInfo(currentUser.getUserId().longValue());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)nowUser.getUserName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME, (Object)nowUser.getUserName());
        CommUtils.checkParamEmpty(oldPassword, password, confirmPassword);
        this.checkPwd(password, confirmPassword, oldPassword);
        try {
            this.doModifyPassword(password, oldPassword, currentUser, mgr, nowUser);
            HttpSession currentSession = this.getSession();
            if (currentSession != null) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Logout after modify password. User: %s", currentUser.getUserName()), 653110169894912L);
                mgr.logout(currentUser.getSession());
                currentSession.invalidate();
            }
        }
        catch (LegoCheckedException e) {
            this.logoutForSpecifyError((Exception)((Object)e), mgr);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkPwd(String password, String confirmPassword, String oldPassword) {
        if (!ParamChecker.checkGeneralText((String)oldPassword)) {
            LOGGER.error((Object)"old password is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!password.equals(confirmPassword)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if (WeakPasswordCheckUtil.getInstance().checkWeakPassword(password)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_WEAK.intValue());
        }
    }

    private void doModifyPassword(String password, String oldPassword, User currentUser, IUserMgrBaseService mgr, User nowUser) {
        LOGGER.debug((Object)"enter doModifyPassword");
        if (UserRestServiceValidator.checkComman(nowUser.getUserName(), password).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
        this.checkPasswordComplex(password, mgr);
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        Date currentDate = new Date();
        User userInDB = mgr.getUserInfo(currentUser.getUserId().longValue());
        Date passChangeDate = new Date(userInDB.getSetTime());
        int three = 3;
        int defaultMinlifetime = 3;
        if (null != usrPolicy.getMinlifetime()) {
            defaultMinlifetime = usrPolicy.getMinlifetime();
        }
        long betweenDate = (currentDate.getTime() - passChangeDate.getTime()) / 60000L - (long)defaultMinlifetime;
        if (currentDate.getTime() - passChangeDate.getTime() > 0L && usrPolicy.getUnseal() == 1 && !nowUser.isMustModifyPwd() && betweenDate < 0L) {
            throw new LegoCheckedException(253L);
        }
        mgr.modifyPassword(oldPassword, password, nowUser.getUserId().longValue());
        currentUser.setMustModifyPwd(false);
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_modifyUser_operateName", operationModule="user", level=3)
    @Permission(name={"lego.sys.operatorMgr.operator.edit"})
    public Response modifyUser(UserVo user, Long userId) {
        IProductsCustomizeService pcs;
        LOGGER.debug((Object)"enter modifyUser");
        if (user == null) {
            throw new LegoCheckedException(250L);
        }
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)user.getUserName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_USER_NAME, (Object)this.getCurrentUser().getUserName());
        Object obj = this.getBundleService("user", "usermgr");
        IUserMgrBaseService mgr = (IUserMgrBaseService)obj;
        User oldUser = mgr.getUserInfo(userId.longValue());
        if (oldUser == null) {
            throw new LegoCheckedException(250L);
        }
        UserRestServiceValidator.restoreUserCommonData(user, oldUser, userId);
        boolean isValidate = this.validateSaveUser(user, mgr, false);
        if (!isValidate) {
            throw new LegoCheckedException(250L);
        }
        IBizScopeManager scope = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
        UserRestServiceValidator.restoreUserData(user, oldUser, scope);
        Set roleSet = user.getRolesIdsSet();
        User currentuser = this.getCurrentUser();
        UserRestServiceValidator.checkUserParam(user, userId, mgr, roleSet, currentuser);
        this.machineUserOperateCheck(user, currentuser);
        if (roleSet.contains(-1L)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAcl(user, mgr);
        String projectName = "";
        Object object = this.getBundleService("discover", "ProductsCustomizeServiceImpl");
        if (null != object && (pcs = (IProductsCustomizeService)object).getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            projectName = (String)pcs.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        Set<Long> resIds = user.getResIds();
        List<Long> resourcesIds = this.dealResourceIds(user, currentuser, resIds, USER_MODIFY);
        try {
            this.doModifyUser(projectName, resourcesIds, oldUser, user, userId);
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void doModifyUser(String projectName, List<Long> resourcesIds, User oldUser, UserVo user, Long userId) {
        LOGGER.debug((Object)"enter doModifyUser");
        Set<Long> resIds = user.getResIds();
        User currentuser = this.getCurrentUser();
        Object obj = this.getBundleService("user", "usermgr");
        IUserMgrBaseService mgr = (IUserMgrBaseService)obj;
        this.updateUserInfo(user, mgr, oldUser);
        if (!user.isSyncAdmin()) {
            boolean flag;
            boolean bl = flag = null != projectName && projectName.equalsIgnoreCase(ASG);
            if (flag && !VerifyUtil.isEmpty(resIds)) {
                IThirdPartResourcesService tprService = (IThirdPartResourcesService)this.getBundleService("asgResource", "thirdPartResources");
                tprService.grandResourcesToUser(userId.longValue(), resourcesIds);
            }
            this.forceLogout(user, mgr, currentuser, userId);
            this.dealScopeManager(user, mgr);
        }
    }

    private void updateUserInfo(UserVo user, IUserMgrBaseService mgr, User oldUser) {
        if (!user.getUserName().equals(oldUser.getUserName()) || !user.getUserPassword().equals(oldUser.getUserPassword())) {
            throw new LegoCheckedException(250L);
        }
        if (0 == oldUser.getPasswordModel()) {
            user.setMustModifyPwd(oldUser.isMustModifyPwd());
        }
        try {
            User newUser = UserRestServiceValidator.convertUserVoToUser(user);
            mgr.updateUser(newUser);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"update User error!", (Throwable)e, e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            int paramLong = -1;
            ExceptionUtil.rethrowException((Throwable)e, (String)"update User error!", (long)-1L, null, (Log)LOGGER);
        }
    }

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.operatorMgr.operator.delete"})
    public BatchOperationResult deleteUsers(Set<Long> ids) {
        User currentUser = this.getCurrentUser();
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        CommUtils.isNullCollection(ids);
        if (ids.size() > UserUtil.getUserLimitSize()) {
            LOGGER.error((Object)"Too many users to delete at once.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        StringBuffer sbf = new StringBuffer();
        ArrayList<BatchOperation> errorList = new ArrayList<BatchOperation>();
        this.addIdToBatchOper(ids, mgr, bathOprLst, sbf, errorList);
        LOGGER.warn((Object)("delete users:" + sbf.toString()), 653110169894912L);
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.batchDeleteUser(bathOprLst, currentUser.getUserId().longValue());
            }
            this.dealBatchOperation(errorList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOGGER.error((Object)"delete users error!", (Throwable)e, errorCode);
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, errorCode);
            throw e;
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOGGER.error((Object)("delete users error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, -1L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            this.batchOptLog(batchOperationResult, "user_deleteUser_operateName", 2);
            UserRestServiceImpl.dealWithRandCode(batchOperationResult);
            this.delBizObjs(batchOperationResult);
        }
        return batchOperationResult;
    }

    private void addIdToBatchOper(Set<Long> ids, IUserMgrBaseService mgr, List<BatchOperation> bathOprLst, StringBuffer sbf, List<BatchOperation> errorList) {
        for (Long id : ids) {
            User oldUser;
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id.longValue());
            try {
                String userName = "";
                oldUser = mgr.getUserInfo(id.longValue());
                if (oldUser != null) {
                    userName = oldUser.getUserName();
                }
                tempBatch.setTargetName(userName);
            }
            catch (LegoCheckedException e) {
                errorList.add(tempBatch);
                tempBatch.setErrorCode(e.getErrorCode());
                tempBatch.setDetailParam(e.getParameters());
                continue;
            }
            if (!this.checkAdminFobidden(tempBatch, id, errorList, oldUser).booleanValue()) continue;
            bathOprLst.add(tempBatch);
            sbf.append(id).append(',');
        }
    }

    private static void dealWithRandCode(BatchOperationResult batchOperationResult) {
        LOGGER.debug((Object)"enter dealWithRandCode");
        List result = batchOperationResult.getResult();
        for (BatchOperation operation : result) {
            if (operation.getErrorCode() != 0L) continue;
            RandCodeCheck.removeUserName(operation.getTargetName());
        }
    }

    private Boolean checkAdminFobidden(BatchOperation tempBatch, Long id, List<BatchOperation> errorList, User oldUser) {
        if (UserRestServiceValidator.checkIsAdministrator(id) && UserRestServiceValidator.checkIsAdministrator(this.getCurrentUserId())) {
            LOGGER.error((Object)"can not delete the user of administrator.", 653110169894912L);
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        if (null != oldUser && "true".equals(oldUser.getIsAdmin())) {
            LOGGER.error((Object)"can not delete the user:admin.", 653110169894912L);
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        if (null != oldUser && SITE_TREE_ROOT_ID.equals(oldUser.getDefaultUser())) {
            LOGGER.error((Object)"can not delete the default user.", 653110169894912L);
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        return true;
    }

    private void dealBatchOperation(List<BatchOperation> errorList, BatchOperationResult batchOperationResult) {
        LOGGER.debug((Object)"enter dealBatchOperation");
        List resultList = batchOperationResult.getResult();
        if (resultList == null) {
            batchOperationResult.setResult(errorList);
            batchOperationResult.setFailCount(errorList.size());
            batchOperationResult.setTotalCount(errorList.size());
        } else {
            resultList.addAll(errorList);
            batchOperationResult.setFailCount(batchOperationResult.getFailCount() + errorList.size());
            batchOperationResult.setTotalCount(batchOperationResult.getTotalCount() + errorList.size());
        }
    }

    private void dealBatchOperationForException(List<BatchOperation> bathOprLst, List<BatchOperation> errorList, BatchOperationResult batchOperationResult, long errorCode) {
        LOGGER.debug((Object)"enter dealBatchOperationForException");
        for (BatchOperation batchOperation : bathOprLst) {
            batchOperation.setErrorCode(errorCode);
        }
        errorList.addAll(bathOprLst);
        batchOperationResult.setResult(errorList);
        batchOperationResult.setFailCount(errorList.size());
        batchOperationResult.setTotalCount(errorList.size());
    }

    private void delBizObjs(BatchOperationResult batchOperationResult) {
        if (batchOperationResult != null) {
            List batchResult = batchOperationResult.getResult();
            IBizScopeManager scope = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
            for (BatchOperation bop : batchResult) {
                long userId = bop.getTargetId();
                long errorCode = bop.getErrorCode();
                if (0L != errorCode) continue;
                try {
                    scope.deleteUserGrantedObject(Long.valueOf(userId));
                }
                catch (LegoCheckedException e) {
                    LOGGER.warn((Object)"save user business object error", 90160758784001L);
                }
            }
        }
    }

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.operatorMgr.operator.lock"})
    public BatchOperationResult lockUsers(Set<Long> ids) {
        IUserMgrBaseService mgr = null;
        ArrayList<BatchOperation> errList = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            mgr = this.getBundleService("user", "usermgr", IUserMgrBaseService.class);
            this.generateBatchOperList(ids, mgr, bathOprLst, errList);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_lockUser_operateName", 2, this.buildTargetsName(ids), e);
        }
        try {
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.lockUser(bathOprLst);
            }
            this.dealBatchOperation(errList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOGGER.error((Object)"Lock users error!", (Throwable)e, errorCode);
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, errorCode);
            this.writeFailedOperationLog("user_lockUser_operateName", 2, this.buildTargetsName(bathOprLst), (Exception)((Object)e));
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOGGER.error((Object)("Lock users error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, -1L);
            this.writeFailedOperationLog("user_lockUser_operateName", 2, this.buildTargetsName(bathOprLst), (Exception)((Object)new LegoCheckedException(-1L, (Throwable)e)));
        }
        this.batchOptLog(batchOperationResult, "user_lockUser_operateName", 2);
        return batchOperationResult;
    }

    private void checkIsAdmin() {
        User user = this.getCurrentUser();
        if ("true".equals(user.getIsAdmin())) {
            return;
        }
        throw new LegoCheckedException(1073947400L);
    }

    private void generateBatchOperList(Set<Long> ids, IUserMgrBaseService mgr, List<BatchOperation> bathOprLst, List<BatchOperation> errList) {
        CommUtils.isNullCollection(ids);
        if (ids.size() > UserUtil.getUserLimitSize()) {
            LOGGER.error((Object)"Too many users to lock at once.");
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder sbf = new StringBuilder();
        for (long strTemp : ids) {
            sbf.append(strTemp).append(',');
        }
        LOGGER.warn((Object)("Lock users:" + sbf.toString()), 653110169894912L);
        User currentUser = this.getCurrentUser();
        this.addIdToBatchOper(ids, bathOprLst, currentUser, mgr, errList);
    }

    private void addIdToBatchOper(Set<Long> ids, List<BatchOperation> bathOprLst, User currentUser, IUserMgrBaseService mgr, List<BatchOperation> errList) {
        for (Long id : ids) {
            BatchOperation tempBatch = this.buildBatchOperation(currentUser, mgr, errList, id);
            if (tempBatch == null) continue;
            bathOprLst.add(tempBatch);
        }
    }

    private BatchOperation buildBatchOperation(User currentUser, IUserMgrBaseService mgr, List<BatchOperation> errList, Long id) {
        User oldUser;
        BatchOperation tempBatch = new BatchOperation();
        tempBatch.setTargetId(id.longValue());
        try {
            oldUser = mgr.getUserInfo(id.longValue());
            String userName = "";
            if (oldUser != null) {
                userName = oldUser.getUserName();
            }
            tempBatch.setTargetName(userName);
        }
        catch (LegoCheckedException e) {
            errList.add(tempBatch);
            tempBatch.setErrorCode(e.getErrorCode());
            tempBatch.setDetailParam(e.getParameters());
            return null;
        }
        if (UserRestServiceValidator.checkIsAdministrator(id) && UserRestServiceValidator.checkIsAdministrator(currentUser.getUserId())) {
            LOGGER.error((Object)"can not lock the user of administrator.", 653110169894912L);
            errList.add(tempBatch);
            tempBatch.setErrorCode(250L);
            return null;
        }
        if (null != oldUser && "true".equals(oldUser.getIsAdmin()) && !oldUser.isSyncAdmin()) {
            LOGGER.error((Object)"can not lock the user:admin.", 653110169894912L);
            errList.add(tempBatch);
            tempBatch.setErrorCode(250L);
            return null;
        }
        return tempBatch;
    }

    @Override
    @ParamValidator
    @Permission(name={"lego.sys.operatorMgr.operator.lock"})
    public BatchOperationResult unlockUsers(UnLockUsersVo vo) {
        IUserMgrBaseService mgr = null;
        Set<Long> ids = vo.getIds();
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> errList = new ArrayList<BatchOperation>();
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
            this.generateBatchOperList(ids, mgr, bathOprLst, errList);
            this.checkIsAdmin();
        }
        catch (Exception e) {
            this.writeFailedOperationLog("user_unlockUser_operateName", 3, this.buildTargetsName(ids), e);
        }
        try {
            this.checkAdminPassword(vo.getAdminUserName(), vo.getAdminPassword(), mgr);
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.unLockUser(bathOprLst);
            }
            this.dealBatchOperation(errList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOGGER.error((Object)"Unlock users error,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, errorCode);
            this.writeFailedOperationLogNoException("user_unlockUser_operateName", 3, this.buildTargetsName(bathOprLst), (Exception)((Object)new LegoCheckedException(errorCode, (Throwable)e)));
            this.logoutForSpecifyError((Exception)((Object)e), mgr);
            throw e;
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOGGER.error((Object)"Unlock users error,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, -1L);
            this.writeFailedOperationLog("user_unlockUser_operateName", 3, this.buildTargetsName(bathOprLst), (Exception)((Object)new LegoCheckedException(-1L, (Throwable)e)));
        }
        this.batchOptLog(batchOperationResult, "user_unlockUser_operateName", 3);
        return batchOperationResult;
    }

    private String buildTargetsName(Set<Long> ids) {
        if (VerifyUtil.isEmpty(ids)) {
            return "";
        }
        List targetNames = ids.stream().map(String::valueOf).filter(name -> !VerifyUtil.isEmpty((String)name)).collect(Collectors.toList());
        return String.join((CharSequence)",", targetNames);
    }

    private String buildTargetsName(List<BatchOperation> batchOperations) {
        if (VerifyUtil.isEmpty(batchOperations)) {
            return "";
        }
        List targetNames = batchOperations.stream().map(BatchOperation::getTargetName).filter(name -> !VerifyUtil.isEmpty((String)name)).collect(Collectors.toList());
        return String.join((CharSequence)",", targetNames);
    }

    @Override
    public List<TreeNodeVo> getUserBizObjectTree() {
        LOGGER.debug((Object)"enter getUserBizObjectTree");
        TreeNodeVo rootNode = new TreeNodeVo(BIZ_OBJECT_TREE_ROOT_ID, "-1", "ism.drm.user.security.bizobj.tree.root", true);
        ArrayList<TreeNodeVo> treeNodes = new ArrayList<TreeNodeVo>();
        treeNodes.add(rootNode);
        Long newUserId = this.getCurrentUserId();
        this.createSiteTree(treeNodes, newUserId);
        this.createProtectGroupTree(treeNodes, newUserId);
        this.createDrpTree(treeNodes, newUserId);
        if (treeNodes.size() == 1) {
            treeNodes = new ArrayList();
        } else {
            Collections.sort(treeNodes, new CommonComparator("name", true));
        }
        return treeNodes;
    }

    private void createSiteTree(List<TreeNodeVo> treeNodes, Long userId) {
        LOGGER.debug((Object)"enter createSiteTree");
        ISiteBaseService siteService = (ISiteBaseService)this.getBundleService("DRM_Base", ISiteBaseService.class.getName());
        String eleName = "ism.drm.protect.element.site";
        TreeNodeVo siteRootNode = new TreeNodeVo(SITE_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        List siteList = siteService.getAllSites(userId);
        if (null == siteList || siteList.isEmpty()) {
            return;
        }
        treeNodes.add(siteRootNode);
        for (Site site : siteList) {
            String name = site.getName();
            String sitId = site.getSiteId();
            TreeNodeVo childNode = new TreeNodeVo(sitId, SITE_TREE_ROOT_ID, name, true);
            treeNodes.add(childNode);
        }
    }

    private void createProtectGroupTree(List<TreeNodeVo> treeNodes, Long userId) {
        LOGGER.debug((Object)"enter createProtectGroupTree");
        String serviceName = IProtectGroupBaseService.class.getName();
        IProtectGroupBaseService service = (IProtectGroupBaseService)this.getBundleService("DRM_Base", serviceName);
        String eleName = "ism.drm.protect.group";
        TreeNodeVo pgRootNode = new TreeNodeVo(PROTECTGROUP_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        List pgList = service.getAllProtectGroupBasicInfo(userId, false, false, false);
        if (null == pgList || pgList.isEmpty()) {
            return;
        }
        treeNodes.add(pgRootNode);
        for (ProtectGroup pg : pgList) {
            String name = pg.getName();
            String id = pg.getUuid();
            TreeNodeVo childNode = new TreeNodeVo(id, PROTECTGROUP_TREE_ROOT_ID, name, true);
            treeNodes.add(childNode);
        }
    }

    private void createDrpTree(List<TreeNodeVo> treeNodes, Long userId) {
        LOGGER.debug((Object)"enter createDrpTree.");
        if (userId == null) {
            LOGGER.error((Object)"Param userId is null.");
            return;
        }
        String serviceName = IRecoveryPlanBaseService.class.getName();
        IRecoveryPlanBaseService service = (IRecoveryPlanBaseService)this.getBundleService("DRM_Base", serviceName);
        String eleName = "ism.drm.drp.menuname";
        TreeNodeVo remoteRpRootNode = new TreeNodeVo(REMOTE_RECOVERYPLAN_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        eleName = "ism.drm.drp.local.recovery.menuname";
        TreeNodeVo localRpRootNode = new TreeNodeVo(LOCAL_RECOVERYPLAN_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        List drpList = service.getAllRecoveryPlan(userId.longValue());
        if (VerifyUtil.isEmpty((Collection)drpList)) {
            return;
        }
        Boolean isRemoteRpExisted = false;
        Boolean isLocalRpExisted = false;
        for (RecoveryPlan plan : drpList) {
            TreeNodeVo childNode;
            String name = plan.getName();
            String id = plan.getPlanId();
            if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == plan.getPlanType()) {
                childNode = new TreeNodeVo(id, REMOTE_RECOVERYPLAN_TREE_ROOT_ID, name, true);
                isRemoteRpExisted = true;
            } else {
                childNode = new TreeNodeVo(id, LOCAL_RECOVERYPLAN_TREE_ROOT_ID, name, true);
                isLocalRpExisted = true;
            }
            treeNodes.add(childNode);
        }
        if (isRemoteRpExisted.booleanValue()) {
            treeNodes.add(remoteRpRootNode);
        }
        if (isLocalRpExisted.booleanValue()) {
            treeNodes.add(localRpRootNode);
        }
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="user_forceOffline_operateName", operationModule="user", level=2)
    @Permission(name={"lego.sys.onlineUserMgr.down"})
    public Response forceLogout(Map<String, String> jsonMap) {
        String userid = jsonMap.get("userId");
        String sessionid = jsonMap.get("sessionId");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)userid);
        this.checkUserIdAndSession(sessionid, userid);
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        User downUser = null;
        try {
            Validator.isIntergral(userid);
            downUser = mgr.getUserInfo(Long.parseLong(userid));
            if (SITE_TREE_ROOT_ID.equals(userid)) {
                throw new LegoCheckedException(250L);
            }
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            if (UserRestServiceValidator.checkIsAdministrator(Long.parseLong(userid)) && UserRestServiceValidator.checkIsAdministrator(currentUser.getUserId())) {
                throw new LegoCheckedException(250L);
            }
            CommUtils.checkObjectExists(downUser);
            String tarName = downUser != null ? downUser.getUserName() : "";
            LOGGER.warn((Object)("down user:" + tarName), 653110169894912L);
            mgr.forceLogout(sessionid);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(downUser == null ? userid : downUser.getUserName()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("down user error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            if (downUser != null) {
                this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)downUser.getUserName());
            }
            throw new LegoCheckedException(-1L);
        }
        return Response.ok().build();
    }

    private void checkUserIdAndSession(String sessionid, String userid) {
        if (VerifyUtil.isEmpty((String)userid) || VerifyUtil.isEmpty((String)sessionid) || !ParamChecker.checkSessionId((String)sessionid)) {
            throw new LegoCheckedException(1073947393L);
        }
        String userIdInSession = StringUtils.substringBetween((String)sessionid, (String)"userId=", (String)",");
        if (!userid.equals(userIdInSession)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response getAllPrivilegeOfCurrentUser() {
        LOGGER.debug((Object)"enter getAllPrivilegeOfCurrentUser");
        if (this.getCurrentUserId() <= 0L) {
            return this.getAllPrivilegeOfCurrentSSOUser();
        }
        IUserMgrBaseService userService = this.getUserService();
        User user = userService.getUserInfo(this.getCurrentUserId().longValue());
        Set roleSet = user.getRolesSet();
        HashSet privilegeIdSet = new HashSet();
        if (roleSet != null && !roleSet.isEmpty()) {
            for (Role role : roleSet) {
                if ((role = userService.getRoleInf(role.getRoleId().longValue())) == null) continue;
                privilegeIdSet.addAll(role.getOptIdsSet());
            }
        }
        return Response.ok(privilegeIdSet).build();
    }

    private Response getAllPrivilegeOfCurrentSSOUser() {
        IUserMgrBaseService userService = this.getUserService();
        Role role = userService.getRoleInf(-1L);
        HashSet privileges = new HashSet();
        if (role != null && role.getOptIdsSet() != null) {
            privileges.addAll(role.getOptIdsSet());
        }
        return Response.ok(privileges).build();
    }

    private boolean checkIsAdministrator(long currentuserid) {
        LOGGER.debug((Object)"enter checkIsAdministrator");
        IUserMgrBaseService mgr = this.getUserService();
        Set curroleset = mgr.getUserInfo(currentuserid).getRolesSet();
        if (null != curroleset) {
            for (Role temprole : curroleset) {
                if (!SITE_TREE_ROOT_ID.equals(String.valueOf(temprole.getRoleId())) && !RuleNameEnum.ADMINISTRATOR.getRuleName().equals(temprole.getRoleName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @ParamValidator
    @OperationLog(operationName="quickStart_open_operateName", operationModule="user", level=1)
    public void updateUserCustomSettings(Map<String, String> settings) {
        LOGGER.debug((Object)"enter updateUserCustomSettings");
        long userId = this.getCurrentUserId();
        IUserMgrBaseService mgr = this.getUserService();
        HashSet<UserCustomSetting> settingsFiltered = new HashSet<UserCustomSetting>();
        UserCustomSettingOperateLogger optLogger = new UserCustomSettingOperateLogger();
        String userName = this.getCurrentUser().getUserName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)userName);
        String ipAddress = UserRestServiceImpl.getRemoteAddr(this.getRequest());
        boolean result = true;
        try {
            mgr.updateUserCustomSettings(userId, settingsFiltered);
        }
        catch (Exception e) {
            result = false;
        }
        VerifyUtil.generalCheckLength(settings.entrySet());
        for (String key : USER_CUSTOM_SETTING_WHITELIST) {
            String value = settings.get(key);
            if (null == value) continue;
            if (!ParamChecker.checkLongText((String)value)) {
                LOGGER.error((Object)"setting value is incorrect.");
                throw new LegoCheckedException(1073947393L);
            }
            UserCustomSetting setting = new UserCustomSetting();
            setting.setItemName(key);
            setting.setItemValue(value);
            settingsFiltered.add(setting);
            if (result) {
                optLogger.log(setting, userName, ipAddress);
                continue;
            }
            optLogger.log(setting, userName, ipAddress, false);
        }
    }

    @Override
    public Map<String, String> getUserCustomSettings() {
        LOGGER.debug((Object)"enter getUserCustomSettings");
        long userId = this.getCurrentUserId();
        HashMap<String, String> result = new HashMap<String, String>();
        IUserMgrBaseService mgr = this.getUserService();
        Set settings = mgr.getUserCustomSettings(userId);
        if (null != settings) {
            for (UserCustomSetting setting : settings) {
                result.put(setting.getItemName(), setting.getItemValue());
            }
        }
        return result;
    }

    private IUserMgrBaseService getIUserMgrBaseService() {
        Object bundleService = ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (bundleService instanceof IUserMgrBaseService) {
            return (IUserMgrBaseService)bundleService;
        }
        LOGGER.error((Object)"Get bundleService of usermgr failed cause not cast to IUserMgrBaseService");
        throw new LegoCheckedException(-1L);
    }
}

