/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.report.util;

import com.huawei.ism.drm.rest.service.platform.report.BaseReportRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.report.TestStatisticInfoVo;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class ExportDrpReportUtilExcel
extends FileExcelUtil {
    private static final int COL_WIDTH = 5000;

    @Override
    protected List<List<String>> constructDataRows() {
        List voDatas = (List)this.getDataList();
        if (voDatas == null) {
            return null;
        }
        ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
        for (TestStatisticInfoVo data : voDatas) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(data.getPlanName());
            rowData.add(data.getProduceSiteName());
            rowData.add(data.getRecoverSiteName());
            rowData.add(data.getPoTypeStr());
            rowData.add(data.getSuccessNum() + "");
            rowData.add(data.getTotalNum() - data.getSuccessNum() + "");
            rowData.add(new BaseReportRestServiceImpl().formatTime(data.getMaximumTime()));
            rowData.add(new BaseReportRestServiceImpl().formatTime(data.getMinimumTime()));
            rowData.add(new BaseReportRestServiceImpl().formatTime(data.getAverageTime()));
            rowDataList.add(rowData);
        }
        return rowDataList;
    }

    @Override
    protected void setColumnWidth(Sheet sheetTab) {
        sheetTab.setColumnWidth(0, 5000);
        sheetTab.setColumnWidth(1, 5000);
        sheetTab.setColumnWidth(2, 5000);
        sheetTab.setColumnWidth(3, 5000);
        sheetTab.setColumnWidth(6, 5000);
        sheetTab.setColumnWidth(7, 5000);
        sheetTab.setColumnWidth(8, 5000);
    }
}

