/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.report.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.report.sdk.ReportUtil;
import com.huawei.ism.drm.rest.service.platform.report.ProtectGroupStatisticInfoVo;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class ExportProtectGroupReportUtilExcel
extends FileExcelUtil {
    private static final int COL_WIDTH = 5000;
    private static final String RPO_ITEM_KEY = "RPO_ITEM_KEY";
    private static final String RTO_ITEM_KEY = "RTO_ITEM_KEY";
    private Locale locale;

    @Override
    protected List<List<String>> constructDataRows() {
        this.locale = this.getAbstractRestService().getLocale();
        List voList = (List)this.getDataList();
        if (VerifyUtil.isEmpty((Collection)voList)) {
            return null;
        }
        ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
        for (ProtectGroupStatisticInfoVo data : voList) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(data.getPgName());
            rowData.add(data.getPpTypeStr());
            rowData.add(data.getProduceSiteName());
            rowData.add(data.getRecoverSiteName());
            rowData.add(data.getPoTypeStr());
            this.addRPOAndRTO(rowData, data.getProps());
            rowData.add(data.getSuccessNum() + "");
            rowData.add(data.getTotalNum() - data.getSuccessNum() + "");
            rowDataList.add(rowData);
        }
        return rowDataList;
    }

    private void addRPOAndRTO(List<String> rowData, Map<String, String> props) {
        if (VerifyUtil.isEmpty(props)) {
            rowData.add("--");
            rowData.add("--");
            rowData.add("--");
            return;
        }
        this.addColumValueRPO(rowData, props);
        this.addColumnValueRTO(rowData, props);
    }

    private void addColumnValueRTO(List<String> rowData, Map<String, String> props) {
        String rtoStr = props.get(RTO_ITEM_KEY);
        if (VerifyUtil.isEmpty((String)rtoStr)) {
            rowData.add("--");
        } else {
            JSONArray jsonArray = JSONArray.fromObject((Object)rtoStr);
            StringBuilder sbRto = new StringBuilder();
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                String estimateRTO = obj.getString("estimateRTO");
                sbRto.append(ReportUtil.formatTime((String)estimateRTO, (Locale)this.locale)).append(",");
            }
            if (sbRto.length() > 0) {
                rowData.add(sbRto.substring(0, sbRto.length() - 1));
            } else {
                rowData.add("--");
            }
        }
    }

    private void addColumValueRPO(List<String> rowData, Map<String, String> props) {
        String rpoStr = props.get(RPO_ITEM_KEY);
        if (VerifyUtil.isEmpty((String)rpoStr)) {
            rowData.add("--");
            rowData.add("--");
        } else {
            JSONArray jsonArray = JSONArray.fromObject((Object)rpoStr);
            StringBuilder sbCfgRpo = new StringBuilder();
            StringBuilder sbActualRpo = new StringBuilder();
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject obj = JSONObject.fromObject(iterator.next());
                String configuredRPO = obj.getString("configuredRPO");
                String actualRPO = obj.getString("actualRPO");
                sbCfgRpo.append(ReportUtil.formatTime((String)configuredRPO, (Locale)this.locale)).append(",");
                sbActualRpo.append(ReportUtil.formatTime((String)actualRPO, (Locale)this.locale)).append(",");
            }
            if (sbCfgRpo.length() > 0) {
                rowData.add(sbCfgRpo.substring(0, sbCfgRpo.length() - 1));
            } else {
                rowData.add("--");
            }
            if (sbActualRpo.length() > 0) {
                rowData.add(sbActualRpo.substring(0, sbActualRpo.length() - 1));
            } else {
                rowData.add("--");
            }
        }
    }

    @Override
    protected void setColumnWidth(Sheet sheetTab) {
        super.setColumnWidth(sheetTab);
        sheetTab.setColumnWidth(0, 5000);
        sheetTab.setColumnWidth(1, 5000);
        sheetTab.setColumnWidth(2, 5000);
        sheetTab.setColumnWidth(3, 5000);
        sheetTab.setColumnWidth(6, 5000);
        sheetTab.setColumnWidth(7, 5000);
        sheetTab.setColumnWidth(8, 5000);
    }
}

