/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.software;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.user.util.TreeNodeUtil;
import com.huawei.ism.drm.rest.service.platform.software.ISoftwareRestService;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpSession;

public class SoftwareRestServiceImpl
extends AbstractRestService
implements ISoftwareRestService {
    @Override
    public String getSoftwareInformation() {
        SoftwareInfo softwareInfo = ((ISoftwareInfoService)ServiceContext.getInstance().lookup("DRM_Base/" + ISoftwareInfoService.class.getName())).getSoftwareInfo();
        if (VerifyUtil.isEmpty((Object)softwareInfo)) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"version", (Object)"8.5.1.SPC200");
        result.put((Object)"sn", (Object)softwareInfo.getSn());
        result.put((Object)"productModel", (Object)softwareInfo.getProductModel());
        result.put((Object)"ipAddress", (Object)softwareInfo.getIpAddress());
        result.put((Object)"hostOs", (Object)softwareInfo.getHostOS());
        return result.toString();
    }

    @Override
    public List<TreeNodeVo> getSystemPrivileges() {
        IUserMgrBaseService mgr = (IUserMgrBaseService)this.getBundleService("user", "usermgr");
        RootDataElement optRetree = mgr.getOptTree(Long.valueOf(-2L));
        ArrayList<TreeNodeVo> treeNodes = new ArrayList<TreeNodeVo>();
        optRetree.setDisName("lego.lab.usr.operations");
        TreeNodeUtil.constructNodeList(optRetree, treeNodes);
        Collections.sort(treeNodes, new CommonComparator("sortId", true));
        return treeNodes;
    }

    @Override
    public String querySystemTime() {
        Date now = new Date();
        TimeZone defaultTimezone = TimeZone.getDefault();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(now);
        String defaultTimeZoneStr = TimeUtil.getDefaultTimeZone();
        JSONObject systemTimeObj = new JSONObject();
        systemTimeObj.put((Object)"time", (Object)timeContent);
        systemTimeObj.put((Object)"id", (Object)defaultTimezone.getID());
        systemTimeObj.put((Object)"offset", (Object)defaultTimezone.getRawOffset());
        systemTimeObj.put((Object)"dstSavings", (Object)defaultTimezone.getDSTSavings());
        systemTimeObj.put((Object)"useDaylight", (Object)defaultTimezone.useDaylightTime());
        systemTimeObj.put((Object)"displayName", (Object)defaultTimeZoneStr);
        return systemTimeObj.toString();
    }

    @Override
    public String queryUserLoginInfo() {
        HttpSession sesison = this.getRequest().getSession();
        Locale remoteLocale = this.getRequest().getLocale();
        if (!"en".equalsIgnoreCase(remoteLocale.getLanguage())) {
            sesison.setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.SIMPLIFIED_CHINESE);
        } else {
            sesison.setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.ENGLISH);
        }
        User currentUser = (User)sesison.getAttribute("currentUser");
        if (currentUser.isMustModifyPwd()) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"isFirstLogin", (Object)1);
            return obj.toString();
        }
        ISoftwareInfoService service = (ISoftwareInfoService)ServiceContext.getInstance().lookup("DRM_Base/" + ISoftwareInfoService.class.getName());
        Map userLoginInfo = service.queryUserLoginInfo(currentUser.getUserName());
        if (!VerifyUtil.isEmpty((Map)userLoginInfo)) {
            userLoginInfo.put("userId", currentUser.getUserId());
        }
        return JSONObject.fromObject((Object)userLoginInfo).toString();
    }
}

