/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.text.StringEscapeUtils;

public final class ManualRefreshManager {
    private static final long DEFAULT_REFRESH_INTERVAL = 120000L;
    private static final Log LOGGER = LogFactory.getInstance(ManualRefreshManager.class);
    private static ManualRefreshManager instance = new ManualRefreshManager();
    private Map<Long, Long> refreshMoIdAndTimeMap = new HashMap<Long, Long>();

    private ManualRefreshManager() {
        StringEscapeUtils.escapeHtml4((String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanRefreshMoIdAndTimeMap() {
        Map<Long, Long> map = this.refreshMoIdAndTimeMap;
        synchronized (map) {
            ArrayList<Long> keys = new ArrayList<Long>();
            for (Map.Entry<Long, Long> entry : this.refreshMoIdAndTimeMap.entrySet()) {
                Long previousTime = entry.getValue();
                long currentTime = System.currentTimeMillis();
                if (currentTime - previousTime <= 120000L) continue;
                keys.add(entry.getKey());
            }
            if (!VerifyUtil.isEmpty(keys)) {
                for (Long key : keys) {
                    this.refreshMoIdAndTimeMap.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(NetworkEntity networkEntity, Callable<Boolean> callable) {
        block12: {
            if (null == networkEntity || null == callable) {
                LOGGER.error((Object)"Invalid parameter", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            String name = networkEntity.getName();
            name = StringEscapeUtils.escapeHtml4((String)name);
            long currentTime = System.currentTimeMillis();
            Long previousTime = null;
            Map<Long, Long> map = this.refreshMoIdAndTimeMap;
            synchronized (map) {
                previousTime = this.refreshMoIdAndTimeMap.get(networkEntity.getMoId());
            }
            if (null != previousTime && 120000L > currentTime - previousTime) {
                throw new LegoCheckedException(1073947428L, new String[]{name});
            }
            try {
                boolean result = callable.call();
                if (result) {
                    Map<Long, Long> map2 = this.refreshMoIdAndTimeMap;
                    synchronized (map2) {
                        this.refreshMoIdAndTimeMap.put(networkEntity.getMoId(), System.currentTimeMillis());
                        break block12;
                    }
                }
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("Refresh NetworkEntity error, sn=" + networkEntity.getSn()), (Throwable)e, 90160758784001L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"refresh NetworkEntity error.", (long)-1L, null, (Log)LOGGER);
            }
        }
        this.cleanRefreshMoIdAndTimeMap();
    }

    public static ManualRefreshManager getInstance() {
        return instance;
    }
}

