/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ProxyResponse
extends HttpServletResponseWrapper {
    private static final int NUM_32 = 32;
    private static final int NUM_127 = 127;
    private static final int NUM_255 = 255;
    private static final char[] HEADERNAME_TSPECIALS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}'};
    private CharArrayWriter charArrWriter;
    private PrintWriter pWriter;
    private HttpServletResponse response = null;

    public ProxyResponse(HttpServletResponse response) throws IOException {
        super(response);
        this.response = response;
        this.charArrWriter = new CharArrayWriter();
    }

    public void addHeader(String name, String value) {
        super.addHeader(ProxyResponse.filterHeaderName(name), ProxyResponse.filterHeaderValue(value));
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, ProxyResponse.filterHeaderValue(msg));
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(ProxyResponse.filterHeaderValue(location));
    }

    public void setHeader(String name, String value) {
        super.setHeader(ProxyResponse.filterHeaderName(name), ProxyResponse.filterHeaderValue(value));
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(ProxyResponse.filterHeaderName(name), date);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(ProxyResponse.filterHeaderName(name), value);
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(ProxyResponse.filterHeaderName(name), date);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(ProxyResponse.filterHeaderName(name), value);
    }

    public void setContentType(String contentType) {
        super.setContentType(ProxyResponse.filterHeaderValue(contentType));
    }

    private static String filterHeaderName(String name) {
        if (name == null || name.length() < 1) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || Arrays.binarySearch(HEADERNAME_TSPECIALS, c) >= 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String filterHeaderValue(String value) {
        if (value == null || value.length() < 1) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < ' ' || c > '\u00ff') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.pWriter = super.getWriter();
        return this.pWriter;
    }

    public String toString() {
        String result = null;
        if (this.pWriter != null) {
            result = this.charArrWriter.toString();
        }
        return result;
    }

    public char[] toCharArray() {
        return this.charArrWriter.toCharArray();
    }

    public CharArrayWriter getCharArrWriter() {
        return this.charArrWriter;
    }

    public void setCharArrWriter(CharArrayWriter charArrWriter) {
        this.charArrWriter = charArrWriter;
    }

    public PrintWriter getpWriter() {
        return this.pWriter;
    }

    public void setpWriter(PrintWriter writer) {
        this.pWriter = writer;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    static {
        Arrays.sort(HEADERNAME_TSPECIALS);
    }
}

