/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ResponseHeaderFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getInstance(ResponseHeaderFilter.class);
    private FilterConfig filterConfig;

    public void destroy() {
        if (this.filterConfig != null) {
            this.filterConfig = null;
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (null == this.filterConfig) {
            LOGGER.warn((Object)"Cannot add secure http response, the config file is error.", 653110170615808L);
            filterChain.doFilter(request, (ServletResponse)httpResponse);
            return;
        }
        Enumeration initParameterNames = this.filterConfig.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String headerName = (String)initParameterNames.nextElement();
            String headerValue = this.filterConfig.getInitParameter(headerName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("ResponseHeaderFilter headerName:" + headerName), 653110170615808L);
            }
            httpResponse.setHeader(headerName, headerValue);
        }
        filterChain.doFilter(request, (ServletResponse)httpResponse);
    }
}

