/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.listener;

import com.huawei.ism.drm.web.util.Log4jListenerAdaptor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class Log4jConfigurationListener
implements ServletContextListener {
    private static final Log LOG = FELogFactory.getInstance((String)"Log4jConfigMonitor");
    private static final String CONFIG_LOCATION_PARAM = "log4jConfiguration";
    private static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";

    public void contextInitialized(ServletContextEvent event) {
        this.start(event.getServletContext());
    }

    private void start(ServletContext servletContext) {
        String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (!StringUtils.hasText((String)location) || ResourceUtils.isUrl((String)location)) {
            String msg = "Invalid 'log4jConfigLocation' in File 'log4j.xml'.";
            this.handleException(msg);
        }
        location = SystemPropertyUtils.resolvePlaceholders((String)location);
        location = this.getRealPath(servletContext, location);
        FileAlterationObserver observer = new FileAlterationObserver(new File(location).getParentFile());
        observer.addListener((FileAlterationListener)new Log4jListenerAdaptor());
        String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
        if (StringUtils.hasText((String)intervalString)) {
            try {
                long refreshInterval = Long.parseLong(intervalString);
                FileAlterationMonitor monitor = new FileAlterationMonitor(refreshInterval);
                monitor.addObserver(observer);
                monitor.start();
                LOG.info((Object)"File 'log4j.xml' monitor is started.");
            }
            catch (NumberFormatException ex) {
                String errorMsg = String.format(Locale.ROOT, "Invalid '%s' parameter: %s .", REFRESH_INTERVAL_PARAM, ExceptionUtil.getErrorMessage((Throwable)ex));
                this.handleException(errorMsg);
            }
            catch (Exception ex) {
                String errorMsg = String.format(Locale.ROOT, "Log4jConfigMonitor is error: %s .", ExceptionUtil.getErrorMessage((Throwable)ex));
                this.handleException(errorMsg);
            }
        } else {
            String msg = "Invalid 'log4jRefreshInterval' parameter is null .";
            this.handleException(msg);
        }
    }

    private void handleException(String errorMsg) {
        LOG.error((Object)errorMsg);
        throw new LegoCheckedException(errorMsg);
    }

    private String getRealPath(ServletContext servletContext, String path) {
        if (servletContext == null) {
            LOG.error((Object)"Servlet context is null.");
            throw new LegoCheckedException("Servlet context is null.");
        }
        String newPath = !path.startsWith("/") ? "/" + path : path;
        String realPath = servletContext.getRealPath(newPath);
        if (realPath == null) {
            String msg = String.format(Locale.ROOT, "ServletContext resource [%s] cannot be resolved to absolute file path ,web application archive not expanded?", newPath);
            this.handleException(msg);
        }
        return realPath;
    }
}

