/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.service.session;

import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.security.sdk.service.ISecurityService;
import com.huawei.ism.drm.web.service.tunnel.BundleService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SessionService {
    private static final Log LOGGER = LogFactory.getInstance(SessionService.class);
    private final BundleService bundleService;

    public SessionService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes servletRequestAttributes = this.getServletRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        ServletRequestAttributes servletRequestAttributes = this.getServletRequestAttributes();
        return servletRequestAttributes.getResponse();
    }

    public ServletRequestAttributes getServletRequestAttributes() {
        RequestAttributes requestAttributes = Objects.requireNonNull(RequestContextHolder.getRequestAttributes());
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new LegoCheckedException(102L, "requestAttributes is not instance of ServletRequestAttributes");
        }
        return (ServletRequestAttributes)requestAttributes;
    }

    public HttpSession getCurrentSession() {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        return httpServletRequest.getSession(false);
    }

    public User getCurrentUser() {
        Object iamObj;
        HttpServletRequest request = this.getHttpServletRequest();
        User user = this.get(arg_0 -> ((HttpServletRequest)request).getAttribute(arg_0), "currentUser", User.class);
        if (user != null) {
            return user;
        }
        String userName = request.getHeader("x-auth-user");
        if (VerifyUtil.isEmpty((String)userName) && !VerifyUtil.isEmpty((Object)(iamObj = request.getAttribute("iam-x-auth-user")))) {
            User iamUser = new User();
            iamUser.setUserName(String.valueOf(iamObj));
            return iamUser;
        }
        try {
            user = this.get(arg_0 -> ((HttpSession)request.getSession()).getAttribute(arg_0), "currentUser", User.class);
            if (user != null) {
                request.setAttribute("currentUser", (Object)user);
                return user;
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.error((Object)"Session already invalidated, retry to login for user, ex:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        if (!UserRestServiceValidator.checkUserName(userName).booleanValue()) {
            LOGGER.error((Object)"parameter[x-auth-user] is illegal!");
            throw new LegoCheckedException(1073947659L);
        }
        String userPwd = request.getHeader("x-auth-key");
        ISecurityService service = this.getSecurityService();
        if (service == null) {
            LOGGER.error((Object)"Can not find security service.");
            throw new LegoCheckedException(1073947659L);
        }
        if (!service.isValidUser(userName, userPwd)) {
            throw new LegoCheckedException(1073947659L);
        }
        IUserMgrBaseService mgr = this.bundleService.getUserMgr();
        user = mgr.getUserBaseInfoByName(userName);
        if (user == null) {
            throw new LegoCheckedException(1073947659L);
        }
        request.setAttribute("currentUser", (Object)user);
        return user;
    }

    private ISecurityService getSecurityService() {
        Object object = ServiceContext.getInstance().lookup("DRM_Base/ISecurityService");
        return Optional.ofNullable(object).filter(ISecurityService.class::isInstance).map(ISecurityService.class::cast).orElse(null);
    }

    private <K, V> V get(Function<K, Object> function, K key, Class<V> type) {
        Object result = function.apply(key);
        return Optional.ofNullable(result).filter(type::isInstance).map(type::cast).orElse(null);
    }
}

