/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public final class CheckCodeUtil {
    private static final Logger LOGGER = Logger.getLogger((String)CheckCodeUtil.class.getName());
    private static final String NUMBERS = "123456789";
    private static final String LOWERS = "abcdefghjkmnpqrstuvwxyz";
    private static final String UPPERS = "ABCDEFGHIJKLMNPQRSTUVWXYZ";
    private static final char[][] VALIDATE_CODES = new char[][]{"123456789".toCharArray(), "abcdefghjkmnpqrstuvwxyz".toCharArray(), "ABCDEFGHIJKLMNPQRSTUVWXYZ".toCharArray()};
    private static SecureRandom sRand;
    private static final int TEN = 10;
    private static final int TWENTY = 20;
    private static final int TWEELVE = 12;
    private static final int TWOHANDRED = 200;
    private static final int TWOFOURHANDRED = 240;
    private static final int SIXTY = 60;
    private static final int TWOTWOFIVE = 225;
    private static final int IMGWIDTH = 68;
    private static final double NUMBER_6_2831853071795862D = Math.PI * 2;
    private static final int THIRTEEN = 13;
    private static final int SEVEN = 7;

    private CheckCodeUtil() {
    }

    public static BufferedImage createImage(String sCode) throws NoSuchAlgorithmException {
        int codeLength = sCode.length();
        int width = 68;
        int height = 23;
        int charWidth = (width - 12) / codeLength;
        int charHeight = 17;
        BufferedImage image = new BufferedImage(width, height, 1);
        SecureRandom rand = SecureRandomFactory.getInstanceStrongWithDRBG();
        Graphics graphics = image.getGraphics();
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(CheckCodeUtil.getRandColor(200, 240));
        g2.fillRect(0, 0, width, height);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        for (int i = 0; i < 8; ++i) {
            g2.setColor(new Color(225 - rand.nextInt(160), 225 - rand.nextInt(160), 225 - rand.nextInt(160)));
            g2.drawLine(rand.nextInt(width), rand.nextInt(height), rand.nextInt(width), rand.nextInt(height));
        }
        for (int i = 0; i < codeLength; ++i) {
            int fontsize = 20 + rand.nextInt(3);
            int fontstyle = rand.nextInt(6);
            g2.setFont(new Font("Arial Italic", fontstyle, fontsize));
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.4487989505128276 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), charWidth * i + 10, charHeight);
            g2.setTransform(affine);
            String temp = sCode.substring(i, i + 1);
            g2.setColor(new Color(10 + rand.nextInt(60), 10 + rand.nextInt(60), 10 + rand.nextInt(60)));
            g2.drawString(temp, charWidth * i + 7, charHeight);
        }
        g2.dispose();
        return image;
    }

    public static boolean checkCodeIsEqual(String userEncode, String servEncode) {
        return userEncode.equals(servEncode);
    }

    private static Color getRandColor(int fc, int bc) {
        SecureRandom random = new SecureRandom();
        if (bc > 225) {
            bc = 225;
        }
        int cr = fc + random.nextInt(bc - fc);
        int cg = fc + random.nextInt(bc - fc);
        int cb = fc + random.nextInt(bc - fc);
        return new Color(cr, cg, cb);
    }

    public static String runVerifyCode(int i) {
        return new String(CheckCodeUtil.rand(i));
    }

    private static char[] rand(int length) {
        int i;
        int[] bits = new int[VALIDATE_CODES.length];
        int count = 0;
        int flags = 0;
        int bound = bits.length + 1;
        char[] codes = new char[length];
        bits[0] = 1;
        for (i = 1; i < VALIDATE_CODES.length; ++i) {
            bits[i] = bits[i - 1] << 1;
        }
        for (i = 0; i < length; ++i) {
            boolean run = true;
            while (run) {
                int flag = sRand.nextInt(bound);
                if (flag < VALIDATE_CODES.length) {
                    int bit = bits[flag];
                    if ((flags & bit) != 0) {
                        if (length - i <= bits.length - count) {
                            continue;
                        }
                    } else {
                        ++count;
                    }
                    flags |= bit;
                    codes[i] = (char)flag;
                    run = false;
                    continue;
                }
                if (length - i <= bits.length - count) continue;
                codes[i] = (char)VALIDATE_CODES.length;
                run = false;
            }
        }
        for (i = 0; i < length; ++i) {
            int code = codes[i];
            if (code >= VALIDATE_CODES.length) {
                code = sRand.nextInt(VALIDATE_CODES.length);
            }
            char[] range = VALIDATE_CODES[code];
            codes[i] = range[sRand.nextInt(range.length)];
        }
        return codes;
    }

    public static void shear(Graphics g, int w1, int h1, Color color) {
        CheckCodeUtil.shearX(g, w1, h1, color);
        CheckCodeUtil.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color) {
        int period = 1;
        boolean frames = true;
        boolean phase = true;
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    public static void shearY(Graphics g, int w1, int h1, Color color) {
        int period = 13;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    static {
        try {
            sRand = SecureRandomFactory.getInstanceStrongWithDRBG();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"sRand create Failed.");
            throw new ExceptionInInitializerError("CheckCodeUtil initialization Failed.");
        }
    }
}

