/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;

public abstract class FilterUtil {
    private static final Log logger = LogFactory.getInstance(FilterUtil.class);
    private static final int METHOD_INDEX = 0;
    private static final int URI_INDEX = 1;

    private FilterUtil() {
    }

    public static String getInitParameter(FilterConfig filterConfig, Class<? extends Filter> filter, String name) {
        if (filterConfig == null || filter == null || name == null) {
            return null;
        }
        Map registrations = filterConfig.getServletContext().getFilterRegistrations();
        if (registrations == null || registrations.isEmpty()) {
            return null;
        }
        String type = filter.getName();
        for (Map.Entry entry : registrations.entrySet()) {
            logger.info((Object)"key: %s", new Object[]{entry.getKey()});
        }
        for (Map.Entry entry : registrations.entrySet()) {
            FilterRegistration registration = (FilterRegistration)entry.getValue();
            if (!type.equals(registration.getClassName())) continue;
            return registration.getInitParameter(name);
        }
        return null;
    }

    public static Map<String, String> initSpecialUriMap(String params, Map<String, String> map) {
        if (null == params || params.isEmpty() || map == null) {
            logger.debug((Object)"param is null.");
            return map;
        }
        for (String param : params.split(",")) {
            String[] methodAndUri = param.split(":");
            if (methodAndUri == null || methodAndUri.length < 2) {
                logger.warn((Object)"methodAndUri length error", 653110170615808L);
                continue;
            }
            map.put(methodAndUri[1].trim(), methodAndUri[0].trim());
        }
        return map;
    }
}

