/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.message.Message;

public class RequestUtil {
    private static final Log LOGGER = LogFactory.getInstance(RequestUtil.class);
    private static final int MAX_TERMINAL_IP_LENGTH = 255;

    public static String getClientIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (VerifyUtil.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return RequestUtil.getQualifiedIp(ip);
    }

    private static String getQualifiedIp(String remoteAddr) {
        String terminalIp = RequestUtil.getLastIPFromIPStr(remoteAddr);
        if (terminalIp.length() > 255) {
            terminalIp = terminalIp.substring(0, 255);
            LOGGER.error((Object)"Failed to get terminal ip: %s, cause the ip exceed the limit(255).", new Object[]{terminalIp});
            return terminalIp;
        }
        return terminalIp;
    }

    public static String getClientIpAddress(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (VerifyUtil.isEmpty((Object)request)) {
            return "unknown";
        }
        String ip = RequestUtil.getClientIpAddress(request);
        if (!VerifyUtil.isEmpty((String)ip) && ip.indexOf(",") != -1) {
            String[] arr = ip.split(",");
            ip = arr[arr.length - 1].trim();
        }
        return ip;
    }

    public static Locale getLocale(HttpServletRequest request) {
        Object obj;
        if (request == null) {
            return Locale.ENGLISH;
        }
        Locale locale = null;
        HttpSession session = request.getSession(false);
        if (session != null && (obj = session.getAttribute("WW_TRANS_I18N_LOCALE")) instanceof Locale) {
            locale = (Locale)obj;
        }
        if (locale == null) {
            locale = RequestUtil.requestHasZhInfo(request) ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
        }
        return locale;
    }

    private static boolean requestHasZhInfo(HttpServletRequest request) {
        return "zh_CN".equalsIgnoreCase(request.getParameter("rd_language")) || "zh".equalsIgnoreCase(request.getHeader("Accept-Language"));
    }

    public static String getFirstIPFromIPStr(String ipStr) {
        if (!VerifyUtil.isEmpty((String)ipStr) && ipStr.contains(",")) {
            String[] arr = ipStr.split(",");
            ipStr = arr[0].trim();
        }
        return ipStr;
    }

    public static String getLastIPFromIPStr(String ipStr) {
        if (!VerifyUtil.isEmpty((String)ipStr) && ipStr.contains(",")) {
            String[] arr = ipStr.split(",");
            ipStr = arr[arr.length - 1].trim();
        }
        return ipStr;
    }
}

