/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.web.util.ClassLoaderUtil;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class StaticResourceUtil {
    private static final int NUM_4096 = 4096;
    private static final Log LOGGER = FELogFactory.getInstance((String)"ui");
    private static StaticResourceUtil instance = null;
    private static String encoding = "UTF-8";
    private static String contentSecurityPolicy = "connect-src 'self';object-src 'self';frame-src 'self';media-src 'self';font-src 'self'";
    private final Calendar lastModifiedCal = Calendar.getInstance();
    private final Map<String, String> contentMapper = new HashMap<String, String>();

    private StaticResourceUtil() {
        this.contentMapper.put(".css", "text/css");
        this.contentMapper.put(".html", "text/html");
        this.contentMapper.put(".txt", "text/plain");
        this.contentMapper.put(".gif", "image/gif");
        this.contentMapper.put(".jpg", "image/jpeg");
        this.contentMapper.put(".jpeg", "image/jpeg");
        this.contentMapper.put(".png", "image/png");
        this.contentMapper.put(".ico", "image/ico");
        this.contentMapper.put(".swf", "application/x-shockwave-flash");
        this.contentMapper.put(".exe", "application/x-msdownload");
        this.contentMapper.put(".csv", "application/vnd.ms-excel");
        this.contentMapper.put(".js", "application/javascript");
        this.contentMapper.put(".svg", "image/svg+xml");
        this.contentMapper.put(".mp3", "audio/mpeg");
    }

    public static synchronized StaticResourceUtil getInstance() {
        if (instance == null) {
            instance = new StaticResourceUtil();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findStaticResource(String name, String pathPrefix, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean flag;
        boolean bl = flag = name != null && !name.endsWith(".class") && !"/".equals(name);
        if (!flag) {
            return false;
        }
        InputStream inputStream = this.getResourceStream(name, pathPrefix);
        if (null == inputStream) {
            return false;
        }
        try {
            this.addResponseHeaders(name, request, response);
            if (response.getStatus() == 304) {
                boolean bl2 = true;
                return bl2;
            }
            try {
                this.copy(inputStream, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                LOGGER.error((Object)("copy function:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            CommUtils.closeInputStream(inputStream);
        }
    }

    private void addResponseHeaders(String name, HttpServletRequest request, HttpServletResponse response) {
        long ifModifiedSince;
        Calendar cal = Calendar.getInstance();
        try {
            ifModifiedSince = request.getDateHeader("If-Modified-Since");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Invalid If-Modified-Since header value." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            ifModifiedSince = 0L;
        }
        long lastModifiedMillis = this.lastModifiedCal.getTimeInMillis();
        long now = cal.getTimeInMillis();
        cal.add(5, 1);
        long expires = cal.getTimeInMillis();
        String contentType = this.getContentType(name);
        boolean needCache = false;
        if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
            response.setDateHeader("Expires", expires);
            response.setStatus(304);
            return;
        }
        if (contentType != null) {
            response.setContentType(contentType);
            needCache = true;
        }
        if (needCache) {
            response.setDateHeader("Date", now);
            response.setDateHeader("Expires", expires);
            response.setDateHeader("Retry-After", expires);
            response.setHeader("Cache-Control", "no-store, must-revalidate");
            response.setDateHeader("Last-Modified", lastModifiedMillis);
        } else {
            response.setHeader("Cache-Control", "no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "-1");
        }
        response.setHeader("Strict-Transport-Security", "max-age=14400");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("X-XSS-Protection", "1;mode=block");
        response.setHeader("Content-Security-Policy", contentSecurityPolicy);
        response.setHeader("Content-Security-Policy-Report-Only", "''");
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
    }

    private InputStream getResourceStream(String name, String pathPrefix) throws UnsupportedEncodingException {
        String resourcePath = pathPrefix + name;
        if (pathPrefix.endsWith("/") && name.startsWith("/")) {
            resourcePath = pathPrefix + name.substring(1);
        }
        resourcePath = URLDecoder.decode(resourcePath, encoding);
        return ClassLoaderUtil.getResourceAsStream(resourcePath, this.getClass());
    }

    private String getStrSuffix(String str) {
        if (null == str || str.isEmpty()) {
            return null;
        }
        int dotIndex = str.lastIndexOf(".");
        if (dotIndex <= 0) {
            return null;
        }
        return str.substring(dotIndex);
    }

    protected String getContentType(String name) {
        String suffix = this.getStrSuffix(name);
        if (null == suffix || suffix.isEmpty()) {
            return null;
        }
        return this.contentMapper.get(suffix);
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }
}

