/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.ShutdownDBSubProcessor;
import com.huawei.ism.drm.db.recovery.process.StartupDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShutdownDBProcessor
extends BaseRecoveryProcessor {
    protected static final Log LOGGER = LogFactory.getInstance(ShutdownDBProcessor.class);
    private static final long serialVersionUID = 7653079266164252666L;
    private static final int DEFAULT_START_PRI = 10;

    public ShutdownDBProcessor() {
    }

    public ShutdownDBProcessor(RecoveryProcessor parentProcess) {
        this();
        if (null == parentProcess) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        boolean createResult;
        Set shutdownDBSubProcessors = this.getChildProc();
        if ((null == shutdownDBSubProcessors || shutdownDBSubProcessors.isEmpty()) && !(createResult = this.createSubProcessors(context))) {
            LOGGER.info((Object)"create subprocessors error.", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> processors = this.getSubProcessByPriority(context);
        LOGGER.info((Object)("there are " + processors.entrySet().size() + " Priorities."), 90160758786988L);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithSerialSubExecutor(processors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)false);
        if (null == recoveryTemplate) {
            LOGGER.error((Object)"recoveryTemplate is not exist!");
            throw new LegoCheckedException(1073947393L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor process : childProcessor) {
            ShutdownDBSubProcessor subProcess = (ShutdownDBSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    private int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = NumberUtil.convertToInteger((Object)setting.getValue());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("parseInt error : " + setting.getValue()), (Throwable)e, -1L);
            }
            break;
        }
        return priValue;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<ShutdownDBSubProcessor> shutdownDBSubProcessors = new HashSet<ShutdownDBSubProcessor>();
        RecoveryPlan plan = context.getRecoveryPlan();
        List startProcessors = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, StartupDBSubProcessor.class);
        if (null == startProcessors || startProcessors.isEmpty()) {
            startProcessors = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, StartupDBSubProcessor.class);
        }
        if (VerifyUtil.isEmpty((Collection)startProcessors)) {
            LOGGER.info((Object)"startBdSubProcessor is empty", 90160758786988L);
        }
        this.filterStartSubProc(startProcessors);
        for (RecoveryProcessor p : startProcessors) {
            StartupDBSubProcessor startup = (StartupDBSubProcessor)p;
            ShutdownDBSubProcessor processor = new ShutdownDBSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(startup.getPoId());
            processor.setDbName(startup.getDbName());
            shutdownDBSubProcessors.add(processor);
        }
        this.setChildProc(shutdownDBSubProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected void filterStartSubProc(List<RecoveryProcessor> startProcessors) {
    }
}

