/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.db.recovery.process.ShutdownDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.Set;

public class ShutdownProDBSubProcessor
extends ShutdownDBSubProcessor {
    private static final long serialVersionUID = -3574298598817568701L;

    @Override
    protected String getShutDownResourceSn(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        return protectGroup.getPoProviderSN();
    }

    @Override
    protected ProtectObject getPoForStop(RecoveryProcessorContext context) {
        Set currentPos = context.getProtectGroup().getPolist();
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)currentPos, (String)this.getPoId());
        return po;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownDBApp(ProtectObject po, String providerSn, ProtectGroup protectGroup) {
        try {
            po.getProps().put("APP_PROC_TYPE", String.valueOf(this.getProcType()));
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).suspend(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("ShutdownDBSubProcessor po(" + po.getUuid() + ")'s shutdownDBApp LegoCheckedException"), (Throwable)e, -1L);
            long errorCode = e.getErrorCode();
            if (errorCode == 1L) {
                throw new LegoCheckedException(2002L, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "ShutdownDBSubProcessor po(" + po.getUuid() + ")'s shutdownDBApp Exception";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)LOGGER);
        }
        finally {
            po.setProviderSN(providerSn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getDBTestRunning(ProtectObject po, ProtectGroup protectGroup) {
        long code = 0L;
        Map props = po.getProps();
        props.put("OPER_TYPE", String.valueOf(1));
        try {
            props.put("APP_PROC_TYPE", String.valueOf(this.getProcType()));
            props.put("PROP_KEY_APP_RECOVERY_ACTION", "RECOVERY_ACTION_STOP_PROAPP");
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).testConnecting(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("getDBTestRunning po(" + po.getUuid() + ") LegoCheckedException"), (Throwable)e, -1L);
            code = e.getErrorCode();
        }
        catch (Exception e) {
            LOGGER.error((Object)("getDBTestRunning po(" + po.getUuid() + ")'s isDBAppRunning Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            code = -1L;
        }
        finally {
            props.remove("PROP_KEY_APP_RECOVERY_ACTION");
        }
        code = code == 1L ? 2002L : code;
        return code;
    }
}

