/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class StartupDBSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -757242243050943073L;
    private static final long SCRIPT_FAILED = 2002L;
    private static final String TEMPLATE = "ism.drm.recovery.database.startup.partsucc";
    private static final String FAILED = "ism.drm.rac.node.startup.detail.";
    private static final Set<Integer> UNCHECK_MOUNT_PO_TYPE = ImmutableSet.of((Object)1, (Object)16);
    private static Log logger = LogFactory.getInstance(StartupDBSubProcessor.class);
    private String poId;
    private String dbName;
    private String startAppResults;
    private boolean isDBReadyToStart = false;
    private int dbStartStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue();
    private long startErrorCode = 0L;

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getStartAppResults() {
        return this.startAppResults;
    }

    public void setStartAppResults(String startAppResults) {
        this.startAppResults = startAppResults;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDbName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.database.already.started", new String[]{this.getDbName()});
            logger.info((Object)("database instance has been started succ, dbName=" + this.getDbName()), 90160758786988L);
            return true;
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)context.getRecoveryProtectObjects(), (String)this.poId);
        if (null == po) {
            logger.error((Object)("ProtectObject(" + this.poId + ") is not existed."), 90160758786989L);
            this.updateProcessDetail("lego.err.1073947394", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        JSONArray appStartResult = this.generateStartAppResult(context.getRecoveryPlan(), po);
        if (null == appStartResult) {
            logger.error((Object)("appStartResult is null. dbName:" + this.getDbName()));
            this.updateProcessDetail("lego.err.-1", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setDisasterIsClusterOrSingle(context, po);
        String providerSn = po.getProviderSN();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSn);
        if (drResource instanceof DrHostGroup) {
            po.getProps().put("PRO_PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()));
        } else {
            po.getProps().put("PRO_PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
        }
        JSONObject wwnRelationJson = JSONObject.fromObject((Object)context.getAttribute("WWN_RELATION"));
        po.getProps().put("WWN_RELATION", wwnRelationJson.toString());
        logger.info((Object)("wwnRelationJson:" + wwnRelationJson), 90160758786988L);
        ProtectObject parm = this.getPoForStartDB(po);
        for (int i = 0; i < appStartResult.size(); ++i) {
            JSONObject obj = appStartResult.getJSONObject(i);
            this.doStart(context, parm, obj);
        }
        if (!this.isDBReadyToStart) {
            this.updateResults(appStartResult);
            this.updateProcessDetail("ism.drm.recovery.database.mount.failed", new String[]{this.getDbName()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)("can't start this database instance, some mount operations failed, dbName=" + this.getDbName()), 90160758784001L);
            return true;
        }
        this.updateProcStatus(appStartResult);
        this.updateResults(appStartResult);
        return true;
    }

    private void setDisasterIsClusterOrSingle(RecoveryProcessorContext context, ProtectObject protectObject) {
        try {
            String resourceSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)context.getRecoveryPlan(), (String)context.getProtectGroup().getUuid(), (int)this.getProcType());
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceSn);
            if (!(resource instanceof DrHostGroup)) {
                return;
            }
            DrHostGroup drhostGroup = (DrHostGroup)resource;
            if (VerifyUtil.isEmpty((Collection)resource.getChildResources())) {
                logger.error((Object)("hostgroup(" + resource.getDeviceSn() + ")'s hosts is empty."), 90160758784001L);
                return;
            }
            if (protectObject.getPoType() == 1 && drhostGroup.getClusterType() == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
                protectObject.getProps().put("DISASTER_IS_CLUSTER", "1");
            }
        }
        catch (Exception e) {
            logger.error((Object)("setDIsasterIsClusterOrSingle error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private void updateProcStatus(JSONArray appStartResult) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == this.dbStartStatus) {
            this.updateDetails(appStartResult);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.dbStartStatus) {
            this.updateDetails(appStartResult);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
    }

    private void updateDetails(JSONArray results) {
        int size = results.size();
        JSONObject details = new JSONObject();
        for (int i = 0; i < size; ++i) {
            JSONObject result = results.getJSONObject(i);
            if (result.getBoolean("result")) continue;
            String ip = result.getString("ip");
            JSONObject detail = result.getJSONObject("detail");
            detail = detail != null ? detail : new JSONObject();
            details.put((Object)(FAILED + ip), (Object)detail);
        }
        this.updateProcessDetail(TEMPLATE, new String[]{details.toString()});
    }

    private void updateResults(JSONArray results) {
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            JSONObject result = results.getJSONObject(i);
            result.remove((Object)"detail");
            results.add(i, (Object)result);
        }
        this.startAppResults = results.toString();
    }

    private void doStart(RecoveryProcessorContext context, ProtectObject po, JSONObject obj) {
        if (!obj.getBoolean("result")) {
            String sn = obj.getString("sn");
            String ip = obj.getString("ip");
            if (this.checkMountPassed(po, sn, context)) {
                this.isDBReadyToStart = true;
                po.setProviderSN(sn);
                this.startErrorCode = 0L;
                String[] params = null;
                try {
                    this.startupDBApp(po);
                }
                catch (LegoCheckedException e) {
                    this.startErrorCode = e.getErrorCode();
                    this.startErrorCode = this.startErrorCode == 1L ? 2002L : this.startErrorCode;
                    params = e.getParameters();
                }
                boolean success = this.startErrorCode == 0L;
                obj.put((Object)"result", (Object)success);
                obj.put((Object)"errcode", (Object)this.startErrorCode);
                if (!success) {
                    logger.error((Object)("start db on " + ip + " error.errorcode is " + this.startErrorCode), 90160758784001L);
                    JSONObject detail = new JSONObject();
                    params = params != null ? params : new String[]{};
                    detail.put((Object)ip, (Object)ip);
                    detail.put((Object)("lego.err." + this.startErrorCode), (Object)params);
                    obj.put((Object)"detail", (Object)detail);
                }
                this.setDbStartStatus(success);
            } else {
                obj.put((Object)"result", (Object)false);
                obj.put((Object)"errcode", (Object)1073947403L);
                JSONObject detail = new JSONObject();
                detail.put((Object)ip, (Object)ip);
                detail.put((Object)"lego.err.1073947403", (Object)new String[]{ip});
                obj.put((Object)"detail", (Object)detail);
            }
        } else {
            logger.info((Object)("database has already started, dbName=" + this.getDbName()), 90160758786988L);
            this.isDBReadyToStart = true;
            this.setDbStartStatus(true);
        }
    }

    private void setDbStartStatus(boolean currentStartStatus) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() == this.dbStartStatus) {
            this.dbStartStatus = currentStartStatus ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        } else if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == this.dbStartStatus && currentStartStatus || DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.dbStartStatus && !currentStartStatus) {
            this.dbStartStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue();
        }
    }

    protected void startupDBApp(ProtectObject po) {
        try {
            po.getProps().put("APP_PROC_TYPE", String.valueOf(this.getProcType()));
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).launch(po);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("StartupDBSubProcessor po(" + po.getUuid() + ")'s startupDBApp LegoCheckedException"), (Throwable)e, -1L);
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "StartupDBSubProcessor po(" + po.getUuid() + ")'s startupDBApp Exception";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
    }

    private JSONArray generateStartAppResult(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        JSONArray appStartResult;
        try {
            if (VerifyUtil.isEmpty((String)this.startAppResults)) {
                JSONArray appStartResult2 = this.generateStartupResultJson(recoveryPlan, protectObject);
                return appStartResult2;
            }
            appStartResult = JSONArray.fromObject((Object)this.startAppResults);
        }
        catch (Exception e) {
            appStartResult = null;
            logger.error((Object)("generateStartAppResult error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return appStartResult;
    }

    protected JSONArray generateStartupResultJson(RecoveryPlan recoveryPlan, ProtectObject protectObject) {
        JSONArray appStartResult = new JSONArray();
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String resourceSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)recoveryPlan, (String)protectGroup.getUuid(), (int)this.getProcType());
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(resourceSn);
        if (resource instanceof DrHostGroup) {
            DrHostGroup drhostGroup = (DrHostGroup)resource;
            if (VerifyUtil.isEmpty((Collection)resource.getChildResources())) {
                logger.error((Object)("hostgroup(" + resource.getDeviceSn() + ")'s hosts is empty."), 90160758784001L);
                return null;
            }
            if ((protectObject.getPoType() != 1 || drhostGroup.getClusterType() != DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) && protectObject.getPoType() != 16) {
                ArrayList<String> ipList = new ArrayList<String>();
                for (DrResource childResource : resource.getChildResources()) {
                    ipList.add(childResource.getIpAddress());
                }
                Collections.sort(ipList);
                JSONObject obj = new JSONObject();
                obj.put((Object)"sn", (Object)resource.getDeviceSn());
                obj.put((Object)"ip", ipList.get(0));
                obj.put((Object)"result", (Object)false);
                appStartResult.add((Object)obj);
            } else {
                for (DrResource host : resource.getChildResources()) {
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"sn", (Object)host.getDeviceSn());
                    obj.put((Object)"ip", (Object)host.getIpAddress());
                    obj.put((Object)"result", (Object)false);
                    appStartResult.add((Object)obj);
                }
            }
        } else if (resource instanceof DrHost) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"sn", (Object)resource.getDeviceSn());
            obj.put((Object)"ip", (Object)resource.getIpAddress());
            obj.put((Object)"result", (Object)false);
            appStartResult.add((Object)obj);
        }
        return appStartResult;
    }

    public String generateResultKey() {
        String resultKey = RecoveryProcessResult.getStartupDBProcResultKey((String)this.getPoId());
        return resultKey;
    }

    protected final boolean checkMountPassed(ProtectObject po, String hostSN, RecoveryProcessorContext context) {
        boolean isUnCheckPg;
        ProtectGroup protectGroup = context.getProtectGroup();
        boolean bl = isUnCheckPg = UNCHECK_MOUNT_PO_TYPE.contains(protectGroup.getPoType()) && protectGroup.getTemplate().getType() == PolicyTemplateType.PolicyTemplateE.NAS_SNAPSHOT.getValue();
        if (isUnCheckPg) {
            return true;
        }
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSN);
        ArrayList<DrResource> hosts = new ArrayList<DrResource>();
        if (resource instanceof DrHostGroup) {
            hosts.addAll(resource.getChildResources());
        } else {
            hosts.add(resource);
        }
        for (DrResource host : hosts) {
            String mountKey;
            RecoveryProcessResult processResult = context.getProcessResult();
            boolean isMountSucc = processResult.getProcessResult(mountKey = DBRecoveryTools.getMountHostProcResultKey((String)host.getDeviceSn()));
            if (!isMountSucc) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected ProtectObject getPoForStartDB(ProtectObject po) {
        return po;
    }
}

