/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.TestConnDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TestConnDBProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7250346799213813519L;
    private static final Log LOGGER = LogFactory.getInstance(TestConnDBProcessor.class);
    private String hostOrGroupId;

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public abstract String getName();

    public abstract TestConnDBSubProcessor createNewTestConnDBSubProccessor(RecoveryProcessorContext var1);

    private boolean hasTheSameInstance(List<String> instancesNames, String instanceName) {
        boolean isInstanceExist = false;
        for (String name : instancesNames) {
            if (!name.equals(instanceName)) continue;
            LOGGER.info((Object)(instanceName + "hasTheSameInstance"), -1L);
            isInstanceExist = true;
            break;
        }
        return isInstanceExist;
    }

    private String getInstanceName(ProtectObject po) {
        return (String)po.getProps().get("INSTANCENAME");
    }

    protected List<String> getAllInstanceNames(List<ProtectObject> allPOs) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (ProtectObject po : allPOs) {
            String instanceName = this.getInstanceName(po);
            if (this.hasTheSameInstance(instanceNames, instanceName)) continue;
            instanceNames.add(instanceName);
        }
        return instanceNames;
    }

    protected boolean updateChildSubProcessors(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin to updateSubProcessors in TestConnDBProcessor", -1L);
        Set<RecoveryProcessor> startupDBSubProcessors = this.getStartupDBSubProcessors(context);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(startupDBSubProcessors);
        } else {
            this.setChildProc(startupDBSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected Set<RecoveryProcessor> getStartupDBSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> startupDBSubProcessors = new HashSet<RecoveryProcessor>();
        List allPOs = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        for (ProtectObject po : allPOs) {
            if (!this.needStartApp(recoverySettings, po)) {
                LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + ":" + po.getPoType() + " need not startup app"), -1L);
                continue;
            }
            LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + ":" + po.getPoType() + " need startup app"), -1L);
            TestConnDBSubProcessor processor = this.createNewTestConnDBSubProccessor(context);
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            String instanceName = (String)po.getProps().get("INSTANCENAME");
            if (instanceName != null) {
                processor.setInstanceName("" + instanceName.hashCode());
                processor.setInstances(instanceName);
            }
            processor.setPoId(po.getUuid());
            processor.setDbName(po.getName());
            startupDBSubProcessors.add((RecoveryProcessor)processor);
        }
        return startupDBSubProcessors;
    }

    protected boolean needStartApp(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        boolean isStartApp = true;
        for (RecoverySetting rs : recoverySettings) {
            if (!rs.getName().equals("isStart") || !rs.getOwnerId().equals(po.getUuid())) continue;
            isStartApp = Boolean.parseBoolean(rs.getValue());
            break;
        }
        return isStartApp;
    }

    protected void initInstanceNames(RecoveryProcessorContext context) {
        Set processors = this.getChildProc();
        Set protectObjects = context.getRecoveryProtectObjects();
        block0: for (RecoveryProcessor processor : processors) {
            TestConnDBSubProcessor proc = (TestConnDBSubProcessor)processor;
            String hashCode = proc.getInstanceName();
            if (hashCode == null) continue;
            for (ProtectObject protectObject : protectObjects) {
                String instanceName = (String)protectObject.getProps().get("INSTANCENAME");
                if (instanceName == null || !hashCode.equals("" + instanceName.hashCode())) continue;
                proc.setInstances(instanceName);
                continue block0;
            }
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin to execute in TestConnDBProcessor ", -1L);
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost((RecoveryPlan)context.getRecoveryPlan(), (int)this.getProcType());
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) || !currentHostOrGroupId.equals(this.getHostOrGroupId())) {
            this.updateChildSubProcessors(context);
        } else {
            this.initInstanceNames(context);
        }
        this.setHostOrGroupId(currentHostOrGroupId);
        if (null == this.getChildProc() || this.getChildProc().size() == 0) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority(context);
        LOGGER.info((Object)("there are " + processorsWithPriority.entrySet().size() + " Priorities."), 90160758786988L);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithSerialSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        if (!VerifyUtil.isEmpty((Object)recoveryTemplate)) {
            recoveryTemplate.process(context);
        }
        LOGGER.info((Object)"End to execute in TestConnDBProcessor ", -1L);
        return this.calcProcessResultBySubProc();
    }

    protected int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = NumberUtil.convertToInteger((Object)setting.getValue());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("parseInt error : " + setting.getValue()), (Throwable)e, -1L);
            }
            break;
        }
        return priValue;
    }

    protected Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor process : childProcessor) {
            TestConnDBSubProcessor subProcess = (TestConnDBSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        return oldProcess.getProcId().equals(newProcess.getProcId());
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.db.recovery.process.TestConnDBProcessor.des");
    }
}

