/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.topology;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.topology.AbstractHostTopoBuilder;
import com.huawei.ism.drm.host.topology.element.DBElement;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.skin.LinkSkin;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.skin.LinkGraySkin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DataBaseTopoBuilder
extends AbstractHostTopoBuilder {
    protected static final String ISHOSTGROUP = "isHostGroup";
    protected static final String ISORACLE = "isOracle";
    private static Log logger = LogFactory.getInstance(DataBaseTopoBuilder.class);

    protected List<Integer> getSanActiveTemplateTypes() {
        ArrayList<Integer> sanActiveTemplateTypes = new ArrayList<Integer>();
        sanActiveTemplateTypes.add(15);
        sanActiveTemplateTypes.add(18);
        sanActiveTemplateTypes.add(19);
        sanActiveTemplateTypes.add(23);
        sanActiveTemplateTypes.add(26);
        sanActiveTemplateTypes.add(2);
        sanActiveTemplateTypes.add(31);
        return sanActiveTemplateTypes;
    }

    protected void buildHostTopo(TopoBaseContext context, DrHost resource, Node root, String type, Map<String, Object> dataMap) {
        this.buildHostTopo(context, resource, root, type, false, dataMap);
    }

    protected void buildHostTopo(TopoBaseContext context, DrHost resource, Node root, String type, boolean isOracle, Map<String, Object> dataMap) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSN = resource.getDeviceSn();
        Node hostNode = (Node)context.addChild((IData)root, (IData)new HostElement(resource));
        Node poStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)type, (String)(hostSN + context.getType()));
        context.addChild((IData)hostNode, (IData)poStyleNode);
        Set poSet = protectGroup.getPolist();
        if (isOracle && this.checkAsm(protectGroup)) {
            Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSN);
            context.addChild((IData)hostNode, (IData)asmStyleNode);
        }
        for (ProtectObject po : poSet) {
            if (!context.getType().equals("ProtectGroup-" + po.getPoType())) continue;
            boolean dbStatus = this.getDatabaseStatus(resource.getDeviceSn(), po, dataMap);
            Node poNode = (Node)context.addChild((IData)poStyleNode, (IData)new DBElement(null, po.getName(), dbStatus));
            Set storages = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storage : storages) {
                String id = this.buildHostStorageTopo(context, hostSN, hostNode, storage, null);
                context.linkTo(poNode, (Object)id, new Skin[0]);
            }
        }
    }

    protected void buildDoubleActiveTopo(TopoBaseContext context, DrResource resource, String type, Map<String, Object> dataMap) {
        Iterator poIter = context.getProtectGroup().getPolist().iterator();
        if (!poIter.hasNext()) {
            logger.error((Object)"ProtectObject iterator is null");
            return;
        }
        Iterator storageIter = ((ProtectObject)poIter.next()).getUsedStorageResourceSet().iterator();
        if (!storageIter.hasNext()) {
            logger.error((Object)"ProtectObjectStorageInfo iterator is null");
            return;
        }
        ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)storageIter.next();
        List siteIdList = this.getHyperMetroSiteIds(context, poStorageInfo);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (2 == protectGroup.getTemplate().getType() && !siteIdList.contains(protectGroup.getProductSiteId())) {
            siteIdList.clear();
            siteIdList.add(protectGroup.getProductSiteId());
        }
        if (resource instanceof DrHostGroup) {
            DrHostGroup hostGroupInfo = (DrHostGroup)resource;
            Set drHosts = hostGroupInfo.getChildResources();
            dataMap.put(ISHOSTGROUP, true);
            for (DrResource eHost : drHosts) {
                String hostGroupId = hostGroupInfo.getDeviceSn() + "---" + ":hostGroup";
                Node hostGroupStyleNode = (Node)context.getElementByID((Object)hostGroupId);
                if (hostGroupStyleNode == null) {
                    Node hostStyleNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(hostGroupInfo.getDeviceSn() + "---" + ":hostStyleNode"));
                    context.addChild((IData)context.getRootNode(), (IData)hostStyleNode);
                    hostGroupStyleNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(hostGroupInfo.getDeviceSn() + "---" + ":hostGroup"));
                    context.addChild((IData)hostStyleNode, (IData)hostGroupStyleNode);
                }
                dataMap.put(ISORACLE, true);
                this.buildHostTopo(context, (DrHost)eHost, hostGroupStyleNode, type, siteIdList, dataMap);
            }
        } else if (resource instanceof DrHost) {
            Node hostStyleNode = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(resource.getDeviceSn() + "---" + ":hostStyleNode"));
            context.addChild((IData)context.getRootNode(), (IData)hostStyleNode);
            dataMap.put(ISHOSTGROUP, false);
            dataMap.put(ISORACLE, true);
            this.buildHostTopo(context, (DrHost)resource, hostStyleNode, type, siteIdList, dataMap);
        }
    }

    protected Node getPoNode(TopoBaseContext context, Node poStyleNode, ProtectObject po, Node hostNode, boolean dbStatus, Map<String, Object> dataMap) {
        DBElement poChildNode;
        if (context.getProtectGroup().getPoType() == 9) {
            poChildNode = new DBElement(null, po.getName(), "ism.drm.topo.ntfs.app.name");
            poChildNode.setImage("/theme/recoverydirector/images/topo/windows.png");
        } else {
            poChildNode = new DBElement(null, po.getName(), dbStatus);
        }
        return (Node)context.addChild((IData)poStyleNode, (IData)poChildNode);
    }

    protected void buildHostTopo(TopoBaseContext context, DrHost resource, Node root, String type, List<String> siteIds, Map<String, Object> dataMap) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSN = resource.getDeviceSn();
        Node hostNode = (Node)context.addChild((IData)root, (IData)new HostElement(resource));
        Node poStyleNode = TopoServiceUtil.createProtectObjStyleNode((TopoBaseContext)context, (String)type, (String)(hostSN + context.getType()));
        context.addChild((IData)hostNode, (IData)poStyleNode);
        Set poSet = protectGroup.getPolist();
        boolean isOracle = (Boolean)dataMap.get(ISORACLE);
        if (isOracle && this.checkAsm(protectGroup)) {
            Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSN);
            context.addChild((IData)hostNode, (IData)asmStyleNode);
        }
        this.updateStorageInfoDeviceName(context, resource);
        for (ProtectObject po : poSet) {
            if (!context.getType().equals("ProtectGroup-" + po.getPoType())) continue;
            boolean dbStatus = this.getDatabaseStatus(resource.getDeviceSn(), po, dataMap);
            Skin linkSkin = this.getLinkSkin(dbStatus);
            Node poNode = this.getPoNode(context, poStyleNode, po, hostNode, dbStatus, dataMap);
            Set storages = po.getUsedStorageResourceSet();
            List<Object> listStorage = new ArrayList();
            listStorage.addAll(storages);
            try {
                listStorage = listStorage.stream().sorted((storage1, storage2) -> {
                    if (null != storage1.getLunWWN() && null != storage2.getLunWWN()) {
                        return storage1.getLunWWN().compareTo(storage2.getLunWWN());
                    }
                    return storage1.getResourceId().compareTo(storage2.getResourceId());
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                logger.error((Object)("sort ProtectObjectStorageInfo failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
            }
            for (ProtectObjectStorageInfo protectObjectStorageInfo : listStorage) {
                if (this.needBuildStorageByDrHost(resource, protectObjectStorageInfo)) continue;
                String id = this.buildHostStorageTopo(context, hostSN, hostNode, protectObjectStorageInfo, siteIds);
                context.linkTo(poNode, (Object)id, new Skin[]{linkSkin});
            }
        }
    }

    private boolean needBuildStorageByDrHost(DrHost resource, ProtectObjectStorageInfo storage) {
        boolean isRac = false;
        if (null != resource.getParentDrResource()) {
            DrHostGroup hostGroup = (DrHostGroup)resource.getParentDrResource();
            isRac = hostGroup.getClusterType() == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue();
        }
        return isRac && Integer.valueOf(1).equals(storage.getArchiveLog()) && !resource.getDeviceSn().equals(storage.getAppName());
    }

    protected boolean getDatabaseStatus(String hostSN, ProtectObject po, Map<String, Object> dataMap) {
        return false;
    }

    protected Skin getLinkSkin(boolean isOnline) {
        if (isOnline) {
            return new LinkSkin();
        }
        return new LinkGraySkin();
    }

    protected boolean getLocalDataBaseStatus(String hostSN, String databaseName, int dbType) {
        Database localDb = this.getLocalDatabase(hostSN, databaseName, dbType);
        if (null == localDb) {
            return false;
        }
        int dbStatus = NumberUtil.convertToInteger((Object)localDb.getDbStatus());
        return dbStatus == 0;
    }

    protected Database getLocalDatabase(String hostSN, String databaseName, int dbType) {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("topMoUuid", hostSN);
            props.put("name", databaseName);
            IMoDao moDao = CommonDAOLocator.getMoDao();
            List databases = moDao.findMoBy(Database.class, props);
            if (VerifyUtil.isEmpty((Collection)databases)) {
                return null;
            }
            for (Database db : databases) {
                DatabaseInstance dbInstance;
                if (!(db.getParentMo() instanceof DatabaseInstance) || (dbInstance = (DatabaseInstance)db.getParentMo()).getDbType() != dbType) continue;
                return db;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("database is not online." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return null;
        }
    }

    protected boolean checkAsm(ProtectGroup protectGroup) {
        Set poSet = protectGroup.getPolist();
        for (ProtectObject po : poSet) {
            Set storages = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storage : storages) {
                int storageType = storage.getStorageType();
                if (!TopoServiceUtil.checkIsASM((int)storageType)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateStorageInfoDeviceName(TopoBaseContext context, DrHost drHost) {
        int osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        if (this.validateOsType(osType)) {
            logger.info((Object)"current os type is windows, hp ux, aix.", 90160758786989L);
            return;
        }
        List<Disk> disks = this.getHostDisksInfo(context, drHost);
        if (VerifyUtil.isEmpty(disks)) {
            logger.info((Object)("The disks is empty, device sn:" + drHost.getDeviceSn()), 90160758786989L);
            return;
        }
        Map diskMap = DrHostDeviceUtil.buildDiskInfoMap(disks);
        ProtectGroup protectGroup = context.getProtectGroup();
        Set poSet = protectGroup.getPolist();
        for (ProtectObject po : poSet) {
            Set poStorages = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo poStorage : poStorages) {
                if (!DrHostDeviceUtil.isNeedUpdateDeviceName((String)poStorage.getDeviceName(), (int)poStorage.getStorageSubType(), (String)poStorage.getUdevFlag())) continue;
                List tmpDisks = DrHostDeviceUtil.getDiskByPoStorageInfo((ProtectObjectStorageInfo)poStorage, (Map)diskMap);
                if (VerifyUtil.isEmpty((Collection)tmpDisks)) {
                    String key = poStorage.getResourceProviderSN() + "_" + poStorage.getResourceId();
                    logger.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + poStorage.getLunWWN() + ")"), 90160758786989L);
                    continue;
                }
                String newDeviceName = ((Disk)tmpDisks.get(0)).getDiskName();
                String deviceName = poStorage.getDeviceName();
                String partitionNumber = DrHostDeviceUtil.getPartitionNumber((String)deviceName);
                newDeviceName = newDeviceName + partitionNumber;
                poStorage.setDeviceName(newDeviceName);
            }
        }
    }

    private boolean validateOsType(int osType) {
        return !DrmAppEnumDefine.OS_TYPE_E.isLinux((int)osType);
    }

    private List<Disk> getHostDisksInfo(TopoBaseContext context, DrHost drHost) {
        List disks;
        try {
            if (!context.getProtectGroup().isPrimary()) {
                RestClient restClient = SiteUtil.initClient((String)drHost.getSiteId());
                HashMap<String, String> urlParams = new HashMap<String, String>();
                urlParams.put("hostSn", drHost.getDeviceSn());
                String result = restClient.get("/ws/hosts/{hostSn}/disks", urlParams);
                JSONArray jsonResults = JSONArray.fromObject((Object)result);
                disks = JSONArray.toCollection((JSONArray)jsonResults, Disk.class);
            } else {
                disks = ((IHostService)ServiceLocator.getInstance().getService(IHostService.class)).queryDisks(drHost.getDeviceSn());
            }
        }
        catch (Exception e) {
            disks = null;
            logger.error((Object)("get host disks information error. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return disks;
    }

    protected void linkDiskNodeToLun(TopoBaseContext context, Node diskNode, String target, String prefix) {
        int templateType = context.getProtectGroup().getTemplate().getType();
        if (templateType != 26) {
            super.linkDiskNodeToLun(context, diskNode, target, prefix);
        } else {
            this.addDiskNodeEnding(context, diskNode, target, prefix);
        }
    }

    protected void addDiskNodeEnding(TopoBaseContext context, Node diskNode, String target, String prefix) {
        HashMap<String[], Node> endings = (HashMap<String[], Node>)context.find((Object)"endings");
        if (endings == null) {
            endings = new HashMap<String[], Node>();
            context.bind((Object)"endings", endings);
        }
        endings.put(new String[]{target, prefix}, diskNode);
        super.linkDiskNodeToLun(context, diskNode, target, prefix);
    }
}

