/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.cloudservice.sdk.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.huawei.lego.cbb.cloudservice.sdk.model.MultiCloudProjectIdMapping;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class MultiCloudUtil {
    private static final Log LOGGER = LogFactory.getInstance(MultiCloudUtil.class);
    private static final String SEPARATOR = ";";
    private static final LoadingCache<String, Optional<MultiCloudProjectIdMapping>> CONVERT_TO_CENTER_CACHE = MultiCloudUtil.buildLoadingCache(dataArr -> MultiCloudUtil.getMappingByRegionCloudProjectId(dataArr[0]));
    private static final LoadingCache<String, Optional<MultiCloudProjectIdMapping>> CONVERT_TO_TARGET_REGION_CACHE = MultiCloudUtil.buildLoadingCache(dataArr -> {
        if (((String[])dataArr).length != 2) {
            LOGGER.debug("The dataKey is invalid.");
            return Optional.empty();
        }
        return MultiCloudUtil.getMappingByCenterCloudProjectId(dataArr[0], dataArr[1]);
    });
    private static final LoadingCache<String, Optional<MultiCloudProjectIdMapping>> SAVE_AND_GET_MAPPING_CACHE = MultiCloudUtil.buildLoadingCache(dataArr -> {
        if (((String[])dataArr).length != 3) {
            LOGGER.debug("The dataKey is invalid.");
            return Optional.empty();
        }
        return MultiCloudUtil.saveOrUpdateMapping(dataArr[0], dataArr[1], dataArr[2]);
    });

    private static LoadingCache<String, Optional<MultiCloudProjectIdMapping>> buildLoadingCache(final Function<String[], Optional<MultiCloudProjectIdMapping>> loadFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(50L).build((CacheLoader)new CacheLoader<String, Optional<MultiCloudProjectIdMapping>>(){

            public Optional<MultiCloudProjectIdMapping> load(String dataKey) {
                if (VerifyUtil.isEmpty(dataKey)) {
                    LOGGER.debug("The dataKey is empty.");
                    return Optional.empty();
                }
                String[] dataArr = dataKey.split(MultiCloudUtil.SEPARATOR);
                return (Optional)loadFunction.apply(dataArr);
            }
        });
    }

    private static Optional<MultiCloudProjectIdMapping> saveOrUpdateMapping(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        IResourceService resourceService = MultiCloudUtil.getResourceService();
        MultiCloudProjectIdMapping dataInDb = resourceService.getMultiCloudProjectIdMapping(centerCloudProjectId, regionCloudProjectId, regionId);
        if (!VerifyUtil.isEmpty(dataInDb)) {
            LOGGER.debug("The mapping is already exist.");
            return Optional.of(dataInDb);
        }
        MultiCloudProjectIdMapping multiCloudProjectIdMapping = new MultiCloudProjectIdMapping();
        multiCloudProjectIdMapping.setCenterCloudProjectId(centerCloudProjectId);
        multiCloudProjectIdMapping.setRegionCloudProjectId(regionCloudProjectId);
        multiCloudProjectIdMapping.setRegionId(regionId);
        resourceService.saveMultiCloudProjectIdMapping(multiCloudProjectIdMapping);
        return Optional.of(multiCloudProjectIdMapping);
    }

    private static Optional<MultiCloudProjectIdMapping> getMappingByRegionCloudProjectId(String regionCloudProjectId) {
        IResourceService resourceService = MultiCloudUtil.getResourceService();
        List<MultiCloudProjectIdMapping> dataList = resourceService.getMultiCloudProjectIdMapping(regionCloudProjectId);
        if (VerifyUtil.isEmpty(dataList)) {
            LOGGER.debug("The dataList is empty.");
            return Optional.empty();
        }
        return dataList.stream().filter(item -> regionCloudProjectId.equals(item.getRegionCloudProjectId())).findFirst();
    }

    private static Optional<MultiCloudProjectIdMapping> getMappingByCenterCloudProjectId(String centerCloudProjectId, String regionId) {
        IResourceService resourceService = MultiCloudUtil.getResourceService();
        List<MultiCloudProjectIdMapping> dataList = resourceService.getMultiCloudProjectIdMapping(centerCloudProjectId);
        if (VerifyUtil.isEmpty(dataList)) {
            LOGGER.debug("The dataList is empty.");
            return Optional.empty();
        }
        return dataList.stream().filter(item -> centerCloudProjectId.equals(item.getCenterCloudProjectId()) && regionId.equals(item.getRegionId())).findFirst();
    }

    private static IResourceService getResourceService() {
        Object service = ServiceLocator.getBundleService("ResourceApplication", "ResourceServiceImpl");
        if (VerifyUtil.isEmpty(service) || !(service instanceof IResourceService)) {
            LOGGER.error("Get resourceService failed!");
            throw new LegoCheckedException(1073947393L);
        }
        return (IResourceService)service;
    }

    public static Optional<MultiCloudProjectIdMapping> refreshCacheAndGet(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        if (VerifyUtil.isEmpty(centerCloudProjectId) || VerifyUtil.isEmpty(regionCloudProjectId) || VerifyUtil.isEmpty(regionId)) {
            LOGGER.warn("Mapping data is invalid.");
            return Optional.empty();
        }
        String dataKey = MultiCloudUtil.generateKey(centerCloudProjectId, regionCloudProjectId, regionId);
        try {
            Optional result = (Optional)SAVE_AND_GET_MAPPING_CACHE.get((Object)dataKey);
            MultiCloudUtil.checkConvertToTargetRegionCache(centerCloudProjectId, regionCloudProjectId, regionId);
            MultiCloudUtil.checkConvertToCenterCache(centerCloudProjectId, regionCloudProjectId);
            return result;
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Get data from cache error %s", ExceptionUtil.getErrorMessage(e));
            return Optional.empty();
        }
    }

    private static void checkConvertToTargetRegionCache(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        String convertToTargetRegionResult = MultiCloudUtil.convertToTargetRegion(centerCloudProjectId, regionId);
        String cacheKey = MultiCloudUtil.generateKey(centerCloudProjectId, regionId);
        if (convertToTargetRegionResult.equals(regionCloudProjectId)) {
            LOGGER.debug((Object)"The key %s in CONVERT_TO_TARGET_REGION_CACHE is valid.", cacheKey);
        } else {
            LOGGER.debug((Object)"The key %s in CONVERT_TO_TARGET_REGION_CACHE is invalid.", cacheKey);
            CONVERT_TO_TARGET_REGION_CACHE.invalidate((Object)cacheKey);
        }
    }

    private static void checkConvertToCenterCache(String centerCloudProjectId, String regionCloudProjectId) {
        String convertToCenterResult = MultiCloudUtil.convertToCenter(regionCloudProjectId);
        String cacheKey = MultiCloudUtil.generateKey(regionCloudProjectId);
        if (convertToCenterResult.equals(centerCloudProjectId)) {
            LOGGER.debug((Object)"The key %s in CONVERT_TO_CENTER_CACHE is valid.", cacheKey);
            return;
        }
        LOGGER.debug((Object)"The key %s in CONVERT_TO_CENTER_CACHE is invalid.", cacheKey);
        CONVERT_TO_CENTER_CACHE.invalidate((Object)cacheKey);
    }

    public static String convertToTargetRegion(String centerCloudProjectId, String regionId) {
        String dataKey = MultiCloudUtil.generateKey(centerCloudProjectId, regionId);
        try {
            return ((Optional)CONVERT_TO_TARGET_REGION_CACHE.get((Object)dataKey)).map(MultiCloudProjectIdMapping::getRegionCloudProjectId).orElse(centerCloudProjectId);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Get data from cache error %s", ExceptionUtil.getErrorMessage(e));
            return centerCloudProjectId;
        }
    }

    public static String convertToCenter(String regionCloudProjectId) {
        String dataKey = MultiCloudUtil.generateKey(regionCloudProjectId);
        try {
            return ((Optional)CONVERT_TO_CENTER_CACHE.get((Object)dataKey)).map(MultiCloudProjectIdMapping::getCenterCloudProjectId).orElse(regionCloudProjectId);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Get data from cache error %s", ExceptionUtil.getErrorMessage(e));
            return regionCloudProjectId;
        }
    }

    private static String generateKey(String ... args) {
        return String.join((CharSequence)SEPARATOR, args);
    }

    public static boolean isSupportMultiCloud() {
        return LegoBaseConfig.getInstance(PathUtil.getInstallPath() + "/LegoRuntime/conf/lego.properties").getBoolean("multi.cloud.adapter.switch", false);
    }
}

