/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.api;

import com.huawei.lego.com.south.snmp.abs.ISnmpTableResponse;
import com.huawei.lego.com.south.snmp.abs.Interpreter;
import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.com.south.snmp.abs.Response;
import com.huawei.lego.com.south.snmp.api.InterpreterSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snmp4j.smi.OID;

public class TableResponse
extends Response
implements ISnmpTableResponse {
    private List<String> columns = new ArrayList<String>();
    private List<List<String>> data = new ArrayList<List<String>>();
    private List<List<Property>> rawdata = new ArrayList<List<Property>>();
    private List<OID> oids = new ArrayList<OID>();
    private Map<Integer, Interpreter> interpreterMap = new HashMap<Integer, Interpreter>();

    public void addOid(String oid) {
        this.getOidList().add(oid);
        OID loid = new OID(oid);
        this.oids.add(loid);
        int idx = this.oids.indexOf(loid);
        if (InterpreterSystem.getInstance().contains(loid)) {
            this.interpreterMap.put(idx, InterpreterSystem.getInstance().get(loid));
        }
    }

    public OID[] getOIDs() {
        return this.oids.toArray(new OID[this.oids.size()]);
    }

    protected void addRow(List<String> rowData) {
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < rowData.size(); ++i) {
            if (this.interpreterMap.get(i) != null) {
                String v = this.interpreterMap.get(i).get(rowData.get(i));
                row.add(v);
                continue;
            }
            row.add(rowData.get(i));
        }
        this.data.add(row);
    }

    public void addRawRow(List<Property> rowData) {
        ArrayList<Property> row = new ArrayList<Property>();
        for (int i = 0; i < rowData.size(); ++i) {
            row.add(rowData.get(i));
        }
        this.rawdata.add(row);
    }

    @Override
    public String getCellData(int row, int col) {
        try {
            return this.data.get(row).get(col);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.columns.indexOf(columnName);
    }

    @Override
    public List<String> getColumnNames() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public List<String> getRowData(int rowIdx) {
        return this.data.get(rowIdx);
    }

    @Override
    public List<String> getRowData(String colName, String colValue) {
        try {
            return this.data.get(this.getRowIndex(colName, colValue));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getRowIndex(String colName, String colValue) {
        int ci = this.getColumnIndex(colName);
        List<List<String>> tds = this.getTableData();
        int tag = 0;
        for (List<String> td : tds) {
            if (td.size() > ci && td.get(ci).equals(colValue)) {
                return tag;
            }
            ++tag;
        }
        return -1;
    }

    @Override
    public List<List<String>> getTableData() {
        return this.data;
    }

    @Override
    public List<List<Property>> getRawData() {
        return this.rawdata;
    }

    @Override
    public void setTableData(List<List<String>> d) {
        this.data = d;
    }
}

