/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.DateFormatUtil;
import com.huawei.lego.core.sdk.log.DefaultLogConfigurator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LegoLogger
implements Log,
CodeLog {
    private static final long serialVersionUID = -4433977084486078131L;
    private Logger slfLogger;
    private String thisClassName = LegoLogger.class.getName();
    private boolean showLocSrc = true;
    private long logcode = 0L;
    private SimpleDateFormat df = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.SSS][]");

    public LegoLogger(String product) {
        this.slfLogger = product != null && product.length() > 0 ? LogManager.getLogger((String)product) : LogManager.getLogger((String)"com.huawei.lego");
    }

    public LegoLogger(String product, long logCode) {
        this(product);
        this.logcode = logCode;
    }

    @Override
    public void setShowLocSrc(boolean showLocSrc) {
        this.showLocSrc = showLocSrc;
    }

    @Override
    public void setLogCode(long logCode) {
        this.logcode = logCode;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slfLogger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slfLogger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slfLogger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slfLogger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slfLogger.isErrorEnabled();
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            if (this.showLocSrc) {
                this.log(10000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(10000, message, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            if (this.showLocSrc) {
                this.log(5000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(5000, message, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            if (this.showLocSrc) {
                this.log(20000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(20000, message, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            if (this.showLocSrc) {
                this.log(30000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(30000, message, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(40000, message, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void error(Object messagek, Throwable tk) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, messagek, tk, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
            } else {
                this.log(40000, messagek, Thread.currentThread().getName(), null, this.logcode);
            }
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.showLocSrc) {
            this.log(50000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null, this.logcode);
        }
    }

    @Override
    public void fatal(Object message, Throwable throwable) {
        if (this.showLocSrc) {
            this.log(50000, message, throwable, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), this.logcode);
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null, this.logcode);
        }
    }

    @Override
    public void trace(Object messagel, long logCodel) {
        if (this.isTraceEnabled()) {
            if (this.showLocSrc) {
                this.log(5000, messagel, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodel);
            } else {
                this.log(5000, messagel, Thread.currentThread().getName(), null, logCodel);
            }
        }
    }

    @Override
    public void debug(Object messageq, long logCodeq) {
        if (this.isDebugEnabled()) {
            if (this.showLocSrc) {
                this.log(10000, messageq, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodeq);
            } else {
                this.log(10000, messageq, Thread.currentThread().getName(), null, logCodeq);
            }
        }
    }

    @Override
    public void info(Object messagez, long logCodez) {
        if (this.isInfoEnabled()) {
            if (this.showLocSrc) {
                this.log(20000, messagez, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodez);
            } else {
                this.log(20000, messagez, Thread.currentThread().getName(), null, logCodez);
            }
        }
    }

    @Override
    public void warn(Object messageb, long logCodeb) {
        if (this.isWarnEnabled()) {
            if (this.showLocSrc) {
                this.log(30000, messageb, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodeb);
            } else {
                this.log(30000, messageb, Thread.currentThread().getName(), null, logCodeb);
            }
        }
    }

    @Override
    public void error(Object messageg, long logCodeg) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, messageg, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodeg);
            } else {
                this.log(40000, messageg, Thread.currentThread().getName(), null, logCodeg);
            }
        }
    }

    @Override
    public void error(Object messaget, Throwable tt, long logCodet) {
        if (this.isErrorEnabled()) {
            if (this.showLocSrc) {
                this.log(40000, messaget, tt, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCodet);
            } else {
                this.log(40000, messaget, Thread.currentThread().getName(), null, logCodet);
            }
        }
    }

    @Override
    public void fatal(Object message, long logCode) {
        if (this.showLocSrc) {
            this.log(50000, message, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCode);
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null, logCode);
        }
    }

    @Override
    public void fatal(Object message, Throwable throwable, long logCode) {
        if (this.showLocSrc) {
            this.log(50000, message, throwable, Thread.currentThread().getName(), Thread.currentThread().getStackTrace(), logCode);
        } else {
            this.log(50000, message, Thread.currentThread().getName(), null, logCode);
        }
    }

    private void log(int level, Object message, String threadName, StackTraceElement[] ste, long logCode) {
        String details = message != null ? message.toString() : "";
        String desensitizedDetails = SecurityUtil.desensitization(details);
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append('[').append(SecurityUtil.escapeControlChar(desensitizedDetails)).append(']').append(this.getStackMsg(threadName, ste));
        String format = this.getFormat(level);
        String logCodeStr = DefaultLogConfigurator.convertlogCode(logCode);
        switch (level) {
            case 5000: {
                this.slfLogger.trace(format, new Object[]{logCodeStr, msgBuf});
                break;
            }
            case 10000: {
                this.slfLogger.debug(format, new Object[]{logCodeStr, msgBuf});
                break;
            }
            case 20000: {
                this.slfLogger.info(format, new Object[]{logCodeStr, msgBuf});
                break;
            }
            case 30000: {
                this.slfLogger.warn(format, new Object[]{logCodeStr, msgBuf});
                break;
            }
            default: {
                this.slfLogger.error(format, new Object[]{logCodeStr, msgBuf});
            }
        }
    }

    private void log(int level, Object message, Throwable throwable, String threadName, StackTraceElement[] ste, long logCode) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append('[').append(message).append(']').append(this.getStackMsg(threadName, ste));
        String format = this.getFormat(level);
        StringBuffer errorMsg = null;
        try {
            errorMsg = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{DefaultLogConfigurator.convertlogCode(logCode), msgBuf});
        }
        catch (NoSuchMethodError e) {
            errorMsg = msgBuf;
        }
        if (errorMsg instanceof FormattingTuple) {
            this.slfLogger.error(((FormattingTuple)errorMsg).getMessage() + ExceptionUtil.getErrorMessage(throwable));
        } else {
            this.slfLogger.error(((Object)errorMsg).toString() + ExceptionUtil.getErrorMessage(throwable));
        }
    }

    private String getStackMsg(String threadName, StackTraceElement[] ste) {
        if (ste == null) {
            return "[][][,][]";
        }
        boolean srcFlag = false;
        for (StackTraceElement stackTraceElement : ste) {
            if (srcFlag) {
                List names = Arrays.stream(this.getClass().getInterfaces()).map(Class::getName).collect(Collectors.toList());
                names.add(this.thisClassName);
                names.add(LegoCheckedException.class.getName());
                if (stackTraceElement == null) {
                    return "";
                }
                if (!names.contains(stackTraceElement.getClassName())) {
                    return new StringBuffer().append("[").append(stackTraceElement.getClassName()).append("][").append(stackTraceElement.getMethodName()).append(",").append(stackTraceElement.getLineNumber()).append("][").append(threadName).append("]").toString();
                }
            }
            if (null == stackTraceElement || !this.thisClassName.equals(stackTraceElement.getClassName())) continue;
            srcFlag = true;
        }
        return null;
    }

    private String getFormat(int level) {
        String format = new StringBuffer().append(DateFormatUtil.format((DateFormat)this.df, new Date())).append("[{}]").append("[").append(Level.toLevel((int)level)).append("]{}").toString();
        return format;
    }
}

