/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import java.io.FileNotFoundException;
import java.net.BindException;
import java.security.GeneralSecurityException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import javax.naming.InsufficientResourcesException;

public final class ExceptionUtil {
    private static final String[] VALID_PACKAGE_PREFIX_NAMES = new String[]{"com.huawei"};
    private static final List<Class<? extends Throwable>> SPECIAL_EXCEPTION_CLASSES = Arrays.asList(SecurityException.class, GeneralSecurityException.class, ClassNotFoundException.class, FileNotFoundException.class, JarException.class, MissingResourceException.class, NotOwnerException.class, ConcurrentModificationException.class, InsufficientResourcesException.class, BindException.class, OutOfMemoryError.class, StackOverflowError.class, SQLException.class, JsonProcessingException.class);

    private ExceptionUtil() {
    }

    public static LegoCheckedException convertException(Throwable exception, String errorMsg, long errorCode, String[] params, Log logger) {
        if (!ExceptionUtil.isSpecialException(exception)) {
            logger.error((Object)errorMsg, exception, 0L);
        } else {
            logger.error((Object)ExceptionUtil.getErrorMessage(exception), 0L);
        }
        return new LegoCheckedException(errorCode, params, errorMsg);
    }

    public static void rethrowException(Throwable exception, String errorMsg, long errorCode, String[] params, Log logger) {
        throw ExceptionUtil.convertException(exception, errorMsg, errorCode, params, logger);
    }

    public static void rethrowException(Exception exception, String errorMsg, long errorCode, String[] params) {
        throw new LegoCheckedException(errorCode, params, errorMsg);
    }

    public static boolean isSpecialException(Throwable exception) {
        for (Class<? extends Throwable> clazz : SPECIAL_EXCEPTION_CLASSES) {
            if (!clazz.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    public static String getErrorMessage(Throwable exception) {
        StringBuilder strBuilder = new StringBuilder();
        if (null == exception) {
            return strBuilder.toString();
        }
        strBuilder.append(System.lineSeparator());
        Throwable throwable = exception;
        int index = 0;
        do {
            if (0 < index) {
                strBuilder.append("Caused by: ");
            }
            String message = throwable.getMessage();
            if (ExceptionUtil.isSpecialException(throwable)) {
                message = "***";
            }
            strBuilder.append(throwable.getClass().getName() + ": " + message + System.lineSeparator());
            StackTraceElement[] elements = throwable.getStackTrace();
            ExceptionUtil.retrieveStackTraces(elements, strBuilder);
            throwable = throwable.getCause();
            ++index;
        } while (null != throwable);
        return strBuilder.toString();
    }

    private static void retrieveStackTraces(StackTraceElement[] elements, StringBuilder strBuilder) {
        int index = 0;
        for (StackTraceElement element : elements) {
            String clsName = element.getClassName();
            if (1 != ++index && !ExceptionUtil.isValidClass(clsName)) continue;
            strBuilder.append("   at   " + element.toString() + System.lineSeparator());
        }
    }

    public static boolean isValidClass(String clsName) {
        for (String validClsName : VALID_PACKAGE_PREFIX_NAMES) {
            if (!clsName.startsWith(validClsName)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement[] getValidStackTraceElements(StackTraceElement[] elements) {
        if (elements == null) {
            return new StackTraceElement[0];
        }
        return (StackTraceElement[])Arrays.stream(elements).filter(element -> ExceptionUtil.isValidClass(element.getClassName())).toArray(StackTraceElement[]::new);
    }
}

