/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class LegoProperties {
    public static final String KEY_RUNTIME_PATH = "Runtime.path";
    protected static final Properties PROPS = new Properties();
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final Log LOG = LogFactory.getInstance(LegoProperties.class);
    private static final int MAX_PORT = 65535;

    /*
     * Unable to fully structure code
     */
    private static void getConfigFromFile() {
        is = null;
        try {
            clazzLoader = LegoProperties.class.getClassLoader();
            if (clazzLoader != null) {
                is = clazzLoader.getResourceAsStream("default.properties");
            }
            if (is != null) {
                LegoProperties.PROPS.load(is);
            }
            ** if (is == null) goto lbl-1000
        }
        catch (IOException e) {
            try {
                LegoProperties.LOG.error((Object)"Read default.properties fail.", e);
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var2_5) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LegoProperties.LOG.error((Object)"Close the input stream about: %s error is: %s", new Object[]{"default.properties", ExceptionUtil.getErrorMessage(e)});
                    }
                }
                throw var2_5;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LegoProperties.LOG.error((Object)"Close the input stream about: %s error is: %s", new Object[]{"default.properties", ExceptionUtil.getErrorMessage(e)});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                is.close();
            }
            catch (IOException e) {
                LegoProperties.LOG.error((Object)"Close the input stream about: %s error is: %s", new Object[]{"default.properties", ExceptionUtil.getErrorMessage(e)});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)LegoProperties.PROPS);
        System.setProperties(sysProps);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (value == null || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (value == null || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger(value);
    }

    public static int getPort() {
        return LegoProperties.checkPortRange(LegoProperties.getInt("base.rmi_port"));
    }

    public static int getTrapPort() {
        return LegoProperties.checkPortRange(LegoProperties.getInt("base.trap_port"));
    }

    public static int getTrapListenPort() {
        return LegoProperties.checkPortRange(LegoProperties.getInt("base.trap_listen_port"));
    }

    public static String getIPAddress() {
        String ipAddress = PROPS.getProperty("base.appmanager_server");
        if (!Ipv4AddressUtil.isIPv4Address(ipAddress) && !Ipv6AddressUtil.isIPv6Address(ipAddress)) {
            LOG.error("The base.appmanager_server ip value is error!");
            throw new LegoCheckedException("IpAddress is illegal: " + ipAddress);
        }
        return ipAddress;
    }

    public static int getRemoteNotifyTrapPort() {
        return LegoProperties.checkPortRange(LegoProperties.getInt("trapport.remoteNotify"));
    }

    public static boolean isInstalledIntegrated() {
        String isInIntegrated = LegoProperties.getProperty("is.integrated.in.iemp", "false");
        return Boolean.parseBoolean(isInIntegrated);
    }

    public static String getStorageFilePath() {
        File currentFile = new File(".");
        String path = "";
        try {
            path = currentFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error((Object)"getStorageFilePath getCanonicalPath() error!", 102L);
        }
        return path + File.separator;
    }

    private static int checkPortRange(int value) {
        if (value < 0 || value > 65535) {
            LOG.error((Object)"Port: %s out of range", String.valueOf(value));
            throw new LegoCheckedException("Port out of range: " + value);
        }
        return value;
    }

    static {
        LegoProperties.getConfigFromFile();
    }
}

