/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.sdk.model;

import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.io.Serializable;
import java.util.Date;

public class SysOptLog
implements Serializable {
    private static final long serialVersionUID = 7258724042181600627L;
    private static final Log LOGGER = LogFactory.getInstance(SysOptLog.class);
    private static final String MODULE_DEFAULT = "--";
    private long id = 0L;
    private String operation = "";
    private int level = 0;
    private String operator = "";
    private Date date;
    private String module = "--";
    private String terminalIp = "";
    private String logType = "administratorlog";
    private String target = "";
    private String[] targetPara = new String[0];
    private Boolean targetLocal = Boolean.FALSE;
    private int result = 0;
    private String detail = "";
    private String[] detailPara = new String[0];
    private int hasDetail = 0;
    private String gmt;
    private String tokenUser;
    private String projectId;
    private String serviceType;

    @Deprecated
    public SysOptLog() {
    }

    private SysOptLog(Builder builder) {
        this.id = builder.id;
        this.operation = builder.operation;
        this.level = builder.level;
        this.operator = builder.operator;
        this.date = builder.date;
        this.module = builder.module;
        this.terminalIp = builder.terminalIp;
        this.logType = builder.logType;
        this.target = builder.target;
        this.targetPara = builder.targetPara;
        this.targetLocal = builder.isTargetLocal;
        this.result = builder.result;
        this.detail = builder.detail;
        this.detailPara = builder.detailPara;
        this.hasDetail = builder.hasDetail;
        this.gmt = builder.gmt;
        this.tokenUser = builder.tokenUser;
        this.projectId = builder.projectId;
        this.serviceType = builder.serviceType;
    }

    public String getLogType() {
        return this.logType;
    }

    @Deprecated
    public void setLogType(String logType) {
        this.logType = logType;
    }

    @Deprecated
    public String getGmt() {
        return this.gmt;
    }

    @Deprecated
    public void setGmt(String gmt) {
        this.gmt = gmt;
    }

    public long getId() {
        return this.id;
    }

    @Deprecated
    public void setId(long id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    @Deprecated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public int getLevel() {
        return this.level;
    }

    @Deprecated
    public void setLevel(int level) {
        this.level = level;
    }

    public String getOperator() {
        return this.operator;
    }

    @Deprecated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Date getDate() {
        return this.date;
    }

    @Deprecated
    public void setDate(Date date) {
        this.date = date;
    }

    public String getModule() {
        return this.module;
    }

    @Deprecated
    public void setModule(String module) {
        this.module = module;
    }

    public String getTerminalIp() {
        return this.terminalIp;
    }

    @Deprecated
    public void setTerminalIp(String terminalIp) {
        this.terminalIp = terminalIp;
    }

    public String getTarget() {
        return this.target;
    }

    @Deprecated
    public void setTarget(String target) {
        this.target = target;
    }

    public int getResult() {
        return this.result;
    }

    @Deprecated
    public void setResult(int result) {
        this.result = result;
    }

    public String getDetail() {
        return this.detail;
    }

    @Deprecated
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String[] getDetailPara() {
        return this.detailPara;
    }

    @Deprecated
    public void setDetailPara(String[] detailPara) {
        this.detailPara = detailPara;
    }

    public Boolean getTargetLocal() {
        return this.targetLocal;
    }

    @Deprecated
    public void setTargetLocal(Boolean targetLocal) {
        this.targetLocal = targetLocal;
    }

    public String[] getTargetPara() {
        return this.targetPara;
    }

    @Deprecated
    public void setTargetPara(String[] targetPara) {
        this.targetPara = targetPara;
    }

    @Deprecated
    public void setHasDetail(int hasDetail) {
        this.hasDetail = hasDetail;
    }

    public int getHasDetail() {
        return this.hasDetail;
    }

    public String getTokenUser() {
        return this.tokenUser;
    }

    @Deprecated
    public void setTokenUser(String tokenUser) {
        this.tokenUser = tokenUser;
    }

    public String getProjectId() {
        return this.projectId;
    }

    @Deprecated
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    @Deprecated
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeOperateLog() {
        ServiceContext context = ServiceContext.getInstance();
        try {
            Object object = context.lookup("system/sysLogService");
            if (!(object instanceof ISysOptLog)) {
                LOGGER.error("The sysOptLog RMI service is not ISysOptLog.");
                return;
            }
            ISysOptLog sysOptLog = (ISysOptLog)object;
            sysOptLog.writeOptLog(this);
        }
        catch (Exception ex) {
            LOGGER.error(ExceptionUtil.getErrorMessage(ex));
        }
    }

    public static class Builder {
        private long id = 0L;
        private String operation;
        private int level = 0;
        private String operator;
        private Date date = new Date();
        private String module = "--";
        private String terminalIp;
        private String logType = "administratorlog";
        private String target;
        private String[] targetPara = new String[0];
        private boolean isTargetLocal = Boolean.FALSE;
        private int result = 0;
        private String detail;
        private String[] detailPara = new String[0];
        private int hasDetail = 0;
        private String gmt;
        private String tokenUser;
        private String projectId;
        private String serviceType;

        public long getId() {
            return this.id;
        }

        public String getOperation() {
            return this.operation;
        }

        public int getLevel() {
            return this.level;
        }

        public String getOperator() {
            return this.operator;
        }

        public Date getDate() {
            return this.date;
        }

        public String getModule() {
            return this.module;
        }

        public String getTerminalIp() {
            return this.terminalIp;
        }

        public String getLogType() {
            return this.logType;
        }

        public String getTarget() {
            return this.target;
        }

        public String[] getTargetPara() {
            return this.targetPara;
        }

        public Boolean getTargetLocal() {
            return this.isTargetLocal;
        }

        public int getResult() {
            return this.result;
        }

        public String getDetail() {
            return this.detail;
        }

        public String[] getDetailPara() {
            return this.detailPara;
        }

        public int getHasDetail() {
            return this.hasDetail;
        }

        public String getGmt() {
            return this.gmt;
        }

        public String getTokenUser() {
            return this.tokenUser;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public Builder date(Date currentData) {
            this.date = currentData;
            return this;
        }

        public Builder module(String module) {
            this.module = module;
            return this;
        }

        public Builder terminalIp(String terminalIp) {
            this.terminalIp = terminalIp;
            return this;
        }

        public Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder targetPara(String[] targetPara) {
            this.targetPara = targetPara;
            return this;
        }

        public Builder targetLocal(boolean isTargetLocal) {
            this.isTargetLocal = isTargetLocal;
            return this;
        }

        public Builder success() {
            this.result = 1;
            return this;
        }

        public Builder fail() {
            this.result = 0;
            return this;
        }

        public Builder result(int result) {
            this.result = result;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder detailPara(String[] detailPara) {
            this.detailPara = detailPara == null ? new String[0] : detailPara;
            return this;
        }

        public Builder hasDetail(boolean hasDetail) {
            this.hasDetail = hasDetail ? 1 : 0;
            return this;
        }

        public Builder gmt(String gmt) {
            this.gmt = gmt;
            return this;
        }

        public Builder tokenUser(String tokenUser) {
            this.tokenUser = tokenUser;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public SysOptLog build() {
            return new SysOptLog(this);
        }
    }
}

