/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sdk.model;

import com.huawei.lego.nem.fault.sdk.model.AlarmStatistic;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OverAllStatistic
implements Serializable {
    private static final long serialVersionUID = -9087609352320137684L;
    private Map<FaultEnum.AlarmSeverity, Integer> unClearedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
    private Map<FaultEnum.AlarmSeverity, Integer> unConfirmedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();

    public OverAllStatistic() {
        this.unClearedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unClearedMap.put(severity, 0);
        }
        this.unConfirmedMap = new HashMap<FaultEnum.AlarmSeverity, Integer>();
        for (FaultEnum.AlarmSeverity severity : FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.unConfirmedMap.put(severity, 0);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public synchronized int getUnClearedCount(FaultEnum.AlarmSeverity severity) {
        return this.unClearedMap.get((Object)severity);
    }

    public synchronized int getUnConfirmedCount(FaultEnum.AlarmSeverity severity) {
        return this.unConfirmedMap.get((Object)severity);
    }

    public synchronized void update(AlarmStatistic statistic) {
        FaultEnum.AlarmSeverity[] severities;
        for (FaultEnum.AlarmSeverity severity : severities = FaultEnum.AlarmSeverity.getAllSeverity()) {
            this.addUnCleared(severity, statistic.getAlarmCount(severity));
            this.addUnConfirmed(severity, statistic.getUnConfirmedCount(severity));
        }
    }

    private synchronized void addUnCleared(FaultEnum.AlarmSeverity severity, Integer count) {
        Integer oldCount = this.unClearedMap.get((Object)severity);
        if (oldCount < 0) {
            oldCount = 0;
        }
        this.unClearedMap.put(severity, oldCount + count);
    }

    private synchronized void addUnConfirmed(FaultEnum.AlarmSeverity severity, Integer count) {
        int oldCount = this.unConfirmedMap.get((Object)severity);
        if (oldCount < 0) {
            oldCount = 0;
        }
        this.unConfirmedMap.put(severity, oldCount + count);
    }
}

