/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sdk.model;

import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RemoteNotifyRule
implements Serializable {
    private static final long serialVersionUID = 4814939727722567457L;
    private long id;
    private int language;
    private String ruleName;
    private boolean clearEnable;
    private boolean criticalEnable;
    private boolean majorEnable;
    private boolean warningEnable;
    private boolean infoEnable;
    private String sendContent;
    private boolean useEnable;
    private long startTime;
    private String startTimeStr;
    private long endTime;
    private String endTimeStr;
    private String emailTo;
    private String smsPhone;
    private int smsMode;
    private String description;
    private Set<NotifyResItem> notifyResItems = new HashSet<NotifyResItem>();
    private Set<NotifyAlarmItem> notifyAlarmItems = new HashSet<NotifyAlarmItem>();
    private boolean validStatus;
    private boolean expiredStatus;
    private String moMainType;
    private String moSubType;
    private long createUserId;

    public boolean contains(String alarmId, String source, int clearStatus, long modTime, long clearTime) {
        boolean isContain = false;
        for (NotifyResItem notifyResItem : this.notifyResItems) {
            if (!notifyResItem.getAlarmSource().equalsIgnoreCase(source)) continue;
            isContain = true;
        }
        if (!isContain) {
            return false;
        }
        isContain = false;
        for (NotifyAlarmItem notifyAlarmItem : this.notifyAlarmItems) {
            if (!notifyAlarmItem.getAlarmId().equalsIgnoreCase(alarmId)) continue;
            isContain = true;
        }
        return this.containsExt(clearStatus, modTime, clearTime, isContain);
    }

    private boolean containsExt(int clearStatus, long modTime, long clearTime, boolean isContain) {
        if (!isContain) {
            return false;
        }
        if (this.check1(clearStatus, clearTime)) {
            return true;
        }
        return this.checkTimeIsOK(clearStatus, modTime);
    }

    private boolean checkTimeIsOK(int clearStatus, long modTime) {
        return clearStatus == FaultEnum.ClearState.UNCLEARED.getValue() && modTime >= this.startTime && modTime <= this.endTime;
    }

    private boolean check1(int clearStatus, long clearTime) {
        return clearStatus == FaultEnum.ClearState.CLEARED.getValue() && clearTime >= this.startTime && clearTime <= this.endTime;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public boolean isClearEnable() {
        return this.clearEnable;
    }

    public void setClearEnable(boolean isClearEnable) {
        this.clearEnable = isClearEnable;
    }

    public boolean isCriticalEnable() {
        return this.criticalEnable;
    }

    public void setCriticalEnable(boolean isCriticalEnable) {
        this.criticalEnable = isCriticalEnable;
    }

    public boolean isMajorEnable() {
        return this.majorEnable;
    }

    public void setMajorEnable(boolean isMajorEnable) {
        this.majorEnable = isMajorEnable;
    }

    public boolean isWarningEnable() {
        return this.warningEnable;
    }

    public void setWarningEnable(boolean isWarningEnable) {
        this.warningEnable = isWarningEnable;
    }

    public boolean isInfoEnable() {
        return this.infoEnable;
    }

    public void setInfoEnable(boolean isInfoEnable) {
        this.infoEnable = isInfoEnable;
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    public String getSmsPhone() {
        return this.smsPhone;
    }

    public void setSmsPhone(String smsPhone) {
        this.smsPhone = smsPhone;
    }

    public String getSendContent() {
        return this.sendContent;
    }

    public void setSendContent(String sendContent) {
        this.sendContent = sendContent;
    }

    public boolean isUseEnable() {
        return this.useEnable;
    }

    public void setUseEnable(boolean isUseEnable) {
        this.useEnable = isUseEnable;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTimef) {
        this.startTime = startTimef;
    }

    public String getStartTimeStr() {
        return this.startTimeStr;
    }

    public void setStartTimeStr(String startTimeStrf) {
        this.startTimeStr = startTimeStrf;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTimef) {
        this.endTime = endTimef;
    }

    public String getEndTimeStr() {
        return this.endTimeStr;
    }

    public void setEndTimeStr(String endTimeStr) {
        this.endTimeStr = endTimeStr;
    }

    public int getSmsMode() {
        return this.smsMode;
    }

    public void setSmsMode(int smsMode) {
        this.smsMode = smsMode;
    }

    public Set<NotifyResItem> getNotifyResItems() {
        return this.notifyResItems;
    }

    public void setNotifyResItems(Set<NotifyResItem> notifyResItems) {
        this.notifyResItems = notifyResItems;
    }

    public Set<NotifyAlarmItem> getNotifyAlarmItems() {
        return this.notifyAlarmItems;
    }

    public void setNotifyAlarmItems(Set<NotifyAlarmItem> notifyAlarmItems) {
        this.notifyAlarmItems = notifyAlarmItems;
    }

    public boolean isValidStatus() {
        long currentTime = System.currentTimeMillis();
        this.validStatus = this.isUseEnable() && currentTime >= this.getStartTime() && currentTime <= this.getEndTime();
        return this.validStatus;
    }

    public void setValidStatus(boolean validStatusx) {
        this.validStatus = validStatusx;
    }

    public boolean isExpiredStatus() {
        return this.expiredStatus;
    }

    public void setExpiredStatus(boolean expiredStatus) {
        this.expiredStatus = expiredStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public long getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(long createUserId) {
        this.createUserId = createUserId;
    }
}

