#!/bin/bash
set +x
SCRIPTDIR=$(cd "$(dirname "$0")" && pwd)
folder="$SCRIPTDIR/logs" 
if [ ! -d "$folder" ]; then
  mkdir "$folder"
fi
COMMAND_LOG_NAME=$folder/commandrun.log
source "$SCRIPTDIR/common.sh"
zipLog "$COMMAND_LOG_NAME"
echo "user:  [$(whoami)] time: [$(date "+%Y/%m/%d %H:%M:%S:%N")] command:[$1]">> "$COMMAND_LOG_NAME"
SYS_USER_GROUP=$(< "$SCRIPTDIR/config/conf/startInfo.properties" grep -v '^#' | grep 'custom.user.group' |awk -F = '{print $2}'| tr -d '\r\n')
chgrp -R "$SYS_USER_GROUP" "$folder" &>/dev/null
chmod 750  "$folder"
chmod 640  "$COMMAND_LOG_NAME"
