# -*- coding:utf-8 -*-
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.account_query import AccountQuery
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.param_util import ParamUtil
from plugins.eBackup.common import constant


class ParamTool(object):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def get_account_info_from_unify_pwd(self, region_id, account_list,
                                       used_scene=None, component_dict=None, vm_ip=""):
        if not component_dict:
            component_dict = {"component": constant.EBACKUP_SERVICE_NAME, "sub_component": "eBackupServer"}
        account_query = AccountQuery(self.project_id, self.pod_id)
        return account_query.get_account_info(
            region_id, account_list, used_scene, component_dict.get("component"),
            component_dict.get("sub_component"), vm_ip
        )

    def get_ebackup_nodes_account_pwd(self, region_id):
        account_info_list = self.get_account_info_from_unify_pwd(region_id, [('hcp', 1), ('root', 1), ('admin', 6)])
        node_and_passwd = {}
        for account_info in account_info_list:
            node_ip = account_info.get('ip')
            passwd = account_info.get('newPasswd')
            account_name = account_info.get('accountName')
            if node_ip in node_and_passwd:
                node_and_passwd[node_ip].update({account_name: passwd})
            else:
                node_and_passwd[node_ip] = {account_name: passwd}
        # Extra verification for passwords of different nodes. The passwords have to be the same at this moment.
        # Delete this step once the passwords of different nodes are allowed to be different.
        admins, roots, hcps = [], [], []
        for node in node_and_passwd:
            admins.append(node_and_passwd.get(node).get('admin')) if node_and_passwd.get(node).get('admin') else ''
            roots.append(node_and_passwd.get(node).get('root')) if node_and_passwd.get(node).get('root') else ''
            hcps.append(node_and_passwd.get(node).get('hcp')) if node_and_passwd.get(node).get('hcp') else ''
        if len(set(admins)) != 1 or len(set(hcps)) != 1 or len(set(roots)) != 1:
            return {}

        return node_and_passwd

    def get_all_region_code(self):
        region_info_list = ManageOneCmdbUtil(self.project_id, self.pod_id).get_region_info()
        return [region_info.get('regionCode') for region_info in region_info_list if region_info.get('regionCode')]

    def get_region_id(self):
        region_id = ParamUtil().get_param_value(
            self.pod_id, "public", "region_id", "region0_id")
        if not region_id:
            raise Exception("Failed to obtain the current region_id.")
        return region_id

    def is_expand_az(self):
        return get_project_condition_boolean(self.project_id, "ExpansionAZ_KVM | ExpansionAZ_BMS")

    def is_expand_ebackup_server(self):
        return get_project_condition_boolean(self.project_id, "eBackup_ServerProxy_Driver | (eBackup & !eBackup_Proxy)")

    def is_expand_ebackup_proxy(self):
        return get_project_condition_boolean(self.project_id, "eBackup_Proxy")

    def is_csha_storage(self):
        return get_project_condition_boolean(self.project_id, "CSHAStorage")

    def is_install_csbs(self):
        return get_project_condition_boolean(self.project_id, "InstallCSBS-VBS-Server")

    def is_installed_csbs(self):
        return get_project_condition_boolean(self.project_id, "InstalledCSBS-VBS | BCInstalled")

    def is_ipv6_scene(self):
        return get_project_condition_boolean(self.project_id, "ManageIPV6")
