# -*- coding: utf-8 -*-
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from plugins.eBackup.common.params_check_tool import check_datamover_web_login, param_check_judge
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import init_params
from plugins.eBackup.common.model import SshInfo, SshParamsCheckInfo
from plugins.eBackup.common.util import Utils


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过HCCIException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    """
    ebackup_datamover_nodes = Utils.get_ebackup_datamover_nodes_from_cmdb(project_id)
    Utils.set_value_to_config_file("eBackup_Datamover_nodes", ebackup_datamover_nodes)
    db_opt = ParamUtil()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_data.update({"eBackup_Datamover_nodes": ebackup_datamover_nodes})
    check_result = HandleParamCheck()
    all_params = ["eBackup_Datamover_nodes",
                  "eBackup_hcp_pwd",
                  "eBackup_root_pwd", "eBackup_admin_pwd"]
    init_params(check_data, db_opt, project_id, check_result, all_params)
    abnormal_nodes_info = SshParamsCheckInfo()
    ip_list = check_data.get("eBackup_Datamover_nodes").replace(" ", "").replace("|", ";").split(";")
    ssh_info = SshInfo(ip_list, "hcp", check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"))
    check_ebackup_nodes(check_result, "eBackup_Datamover_nodes", ssh_info, abnormal_nodes_info)
    param_check_judge(check_result, abnormal_nodes_info)
    # check datamover web login
    result = check_datamover_web_login(check_data, check_result, all_params)
    return result
