# -*- coding:utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.business.param_util import ParamUtil
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg
from utils.business.project_condition_utils import get_project_condition_boolean

logger.init("eBackup Config Service Monitor")


class ConfigServiceMonitor(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        logger.init("eBackup connect to manageone")
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.__db_param_dict = \
            self.params.get_service_cloud_param(pod_id, "eBackup")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            if get_project_condition_boolean(project_id, 'eBackup_ServerProxy_Driver') or \
                    get_project_condition_boolean(project_id, 'eBackup_Proxy'):
                return Message(200)
        except Exception as err:
            logger.error("Failed to get project condition, the reason is %s" % err)
            return Message(500, err, err)

        try:
            self.config_service_monitor()
            return Message(200)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error(
                "Failed to connect ManageOne ,the reason is %s" % err)
            return Message(500, err, err)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def config_service_monitor(self):
        logger.info("begin to config service monitor.")
        externalom_ip_lower = \
            self.__db_param_dict['datamover_externalom_iplist'].lower()
        datamover_ip_list = externalom_ip_lower.split(',')
        hosts = []
        templates = [
            "eBackup_server_template_01",
            "eBackup_server_template_02",
            "os_template"]
        for datamover_ip in datamover_ip_list:
            for template_id in templates:
                ebackup_node = ServiceNodeCfg(datamover_ip, template_id, "eBackup_log")
                hosts.append(ebackup_node)
        logger.info("new service node cfg succ.")
        service_m_cfg = ServiceMonitorCfg(
            "eBackup",
            "eBackup",
            self.__db_param_dict["region_id"],
            "eBackup",
            "IAAS",
            hosts
        )
        if not set_service_m_cfg(self.pod_id, service_m_cfg):
            raise HCCIException(653040)
        logger.info("config service monitor succ.")

# the code has been updated to python3.7
