# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import set_service_m_cfg
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.common.util import Utils

logger.init("eBackup Config Service Monitor")


class RollbackServiceMonitor(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("eBackup connect to manageone")
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.__db_param_dict = self.params.get_service_cloud_param(pod_id, "eBackup")
        self.param_dict = Utils.init_system_params(project_id, regionid_list[0])
        self.region_id = regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.config_service_monitor()
            return Message(200)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error(
                "Failed to connect ManageOne ,the reason is %s" % err)
            return Message(500, err, err)

    def rollback(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def get_old_adaptation_package_version(self):
        adaptation_pkg_info_path = "".join(
            ['adaptation_pkg_info_',
             str(self.project_id), "_",
             self.region_id]
        )

        old_version = Utils.get_value_from_config_file(adaptation_pkg_info_path)
        return old_version

    def config_service_monitor(self):
        """
        标准调用接口：回滚工步，如果升级前版本是 “1.0” 或者 “8.1.0”，则需要去配置监控模板，还原升级前的监控模式
        :param project_id:
        :param pod_id:
        :return:
        """
        logger.info("begin to config service monitor.")
        old_version = self.get_old_adaptation_package_version()
        if old_version != '1.0' and old_version != '8.1.0':
            logger.info(f"old version is {old_version}, not config service monitor ")
            return

        datamover_ip_list = self.param_dict['eBackup_Datamover_nodes'].replace("|", ";").split(";")
        hosts = []
        templates = ["eBackup_server_template_01", "eBackup_server_template_02", "os_template"]
        for node_ip in datamover_ip_list:
            for template_id in templates:
                ebackup_node = ServiceNodeCfg(node_ip, template_id, "eBackup_log")
                hosts.append(ebackup_node)
        logger.info("new service node cfg succ.")
        service_m_cfg = ServiceMonitorCfg("eBackup", "eBackup", self.region_id, "eBackup", "IAAS", hosts)
        set_service_m_cfg(self.pod_id, service_m_cfg)
        logger.info("config service monitor succ.")

# the code has been updated to python3.7
