ROOTPATH=/opt/root_tool
HCP_ROOT=/opt/huawei-data-protection/ebackup
source ${ROOTPATH}/common/superlog.sh

KmcAlgMode=$1
# verify KmcAlgMode value
if [[ "${KmcAlgMode}" != 0 && "${KmcAlgMode}" != 1 ]]; then
    log_error "KmcAlgMode value is invalid"
    exit 1
fi

# 0. stop service
log_info "stop the ebackup service."
service hcp stop force>/dev/null 2>&1

# 1. change hcp config
log_info "start change AdminNode config file."
sed -i "s/ReAdminNodeEncrypt=.*/ReAdminNodeEncrypt=1/" ${HCP_ROOT}/conf/hcpconf.ini
sed -i "s/ReBackupNodeEncrypt=.*/ReBackupNodeEncrypt=1/" ${HCP_ROOT}/conf/hcpconf.ini
sed -i "s/KmcAlgMode=.*/KmcAlgMode=${KmcAlgMode}/" ${HCP_ROOT}/conf/hcpconf.ini
if [ $? -ne 0 ]; then
    log_error "change AdminNode hcpconf failed."
    exit 1
fi

# 2.change nginx conf
EBK_LB_NGINX_CONF=${HCP_ROOT}/microservice/ebk_lb/bin/nginx/conf/nginx.conf
if [ "${KmcAlgMode}" == "1" ]; then
    grep -q "server-sm" ${EBK_LB_NGINX_CONF}
    if [ $? -ne 0 ]; then
        line4=$(sed -n "/ssl_certificate_key server.key;/=" "${EBK_LB_NGINX_CONF}" | grep -m1 "" | tail -n1)
        if [ "$line4" = "" ]; then
            echo "can't find the cert file in nginx.conf "
            log_error "can't find the cert file in nginx.conf "
            return 1
        fi
        sed -i "${line4}c         ssl_certificate_key server.key;\n        ssl_certificate server-sm-sig.crt;\n        ssl_certificate_key server-sm-sig.key;\n        ssl_certificate server-sm-enc.crt;\n        ssl_certificate_key server-sm-enc.key;" ${EBK_LB_NGINX_CONF}
    else
        log_info "ebk_lb nginx conf no need to add sm cert."
    fi
else
    sed -i "/server-sm/d" ${EBK_LB_NGINX_CONF}
fi

if [ $? -ne 0 ]; then
    log_error "change ebk_lb nginx conf failed."
    exit 1
fi

# 3. change microservice config
log_info "start change microservice config file."
for service_name in $(ls ${HCP_ROOT}/microservice | grep -v 'ebk_openstack_vmware'); do
    if [ "${service_name}" != "ebk_lb" ]; then
        sed -i "s/ReEncrypt=.*/ReEncrypt=1/" ${HCP_ROOT}/microservice/${service_name}/conf/hcpconf.ini
    fi
    sed -i "s/KmcAlgMode=.*/KmcAlgMode=${KmcAlgMode}/" ${HCP_ROOT}/microservice/${service_name}/conf/hcpconf.ini
    if [ $? -ne 0 ]; then
        log_error "change microservice ${service_name} cipher failed."
        exit 1
    fi
done

# 4. change OS cipher
if [ -f "${ROOTPATH}/common/changeOsCipher.sh" ]; then
    if [ "${KmcAlgMode}" == "1" ]; then
        cipher_name="SMCompatible"
    elif [ "${KmcAlgMode}" == "0" ]; then
        cipher_name="generalCipher"
    fi
    sh ${ROOTPATH}/common/changeOsCipher.sh "${cipher_name}"
fi

log_info "change cipher alg mode successfully."
exit 0