# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.check_utils import check_value_null
from utils.business.iam_util import IamApi
from utils.common.exception import HCCIException

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.params import Params


class API(object):

    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.condition = Condition(self.project_id)
        self.iam_api = IamApi()

    def create_iam_account(self, service_type):
        logger.info(f"Create {service_type} iam account start.")
        iam_account_password = \
            Params(self.project_id, self.pod_id).iam_account_preset_pwd
        if self.condition.is_sub:
            query_data = [(f"{service_type}_service", 5)]
            account_info = MO_API(
                self.project_id, self.pod_id).get_unify_password_info(
                query_data)
            if account_info:
                iam_account_password = \
                    account_info[0].get("newPasswd", None)
        if check_value_null(iam_account_password):
            logger.error(
                "Create iam account failed, get iam account password failed.")
            raise HCCIException('663500', "iam_pwd")
        # 创建预置帐号
        account_msg = {
            "user": {
                "name": f"{service_type}_service",
                "mobile": "",
                "email": "",
                "password": iam_account_password,
                "domain_name": "op_service",
                "bind_group": "services,cred,auth,bss"
            }
        }
        self.iam_api.create_account(account_msg, self.pod_id)
        logger.info(f"Create {service_type} iam account success.")

    def create_op_svc_iam_account(self):
        logger.info("Start to create op_svc_eReplication.")
        iam_account_password = \
            Params(self.project_id, self.pod_id).iam_account_preset_pwd
        if check_value_null(iam_account_password):
            logger.error(
                "Create op_svc_eReplication account failed,"
                " get param iam_pwd failed.")
            raise HCCIException('663500', "iam_pwd")
        # 创建预置帐号
        account_list = [
            {
                'domain_name': 'op_svc_eReplication',
                'password': iam_account_password,
                'acl': {}
            }
        ]
        self.iam_api.create_op_svc_account(account_list, self.pod_id)
        logger.info("Create op_svc_eReplication success.")

    def create_iam_role(self, service_type):
        logger.info(f"Create {service_type} iam role start.")
        role_msg = {
            "name": f"{service_type}_adm",
            "display_name": f"{service_type.upper()} Administrator",
            "description": f"{service_type.upper()} Administrator",
            "catalog": f"{service_type.upper()}",
            "policy": {
                "Version": "1.0",
                "Statement": [
                    {
                        "Effect": "Allow",
                        "Action": [
                            f"{service_type.upper()}:"
                            f"{service_type.upper()}:*"
                        ]
                    }
                ],
                "Depends": [
                    {
                        "catalog": "BASE",
                        "display_name": "Server Administrator"
                    },
                    {
                        "catalog": "BASE",
                        "display_name": "Tenant Guest"
                    }
                ]
            }
        }
        self.iam_api.create_role(role_msg, self.pod_id)
        logger.info(f"Create {service_type} iam role success.")

    def get_token(self, account_info, account_pwd):
        return self.iam_api.get_token(
            self.pod_id, account_info, account_pwd)

    def get_preset_user_pwd(self):
        return self.iam_api.get_preset_user_pwd(self.pod_id)
